/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import github.kasuminova.mmce.common.util.IExtendedGasHandler;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentGas;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeGas;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.HybridFluidUtils;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.util.ResourceLocation;

public class RequirementGas
extends ComponentRequirement.MultiCompParallelizable<Object, RequirementTypeGas>
implements ComponentRequirement.ChancedRequirement,
Asyncable {
    public final GasStack required;
    public float chance = 1.0f;

    public RequirementGas(IOType actionType, GasStack required) {
        super(RequirementTypesMM.REQUIREMENT_GAS, actionType);
        this.required = required.copy();
    }

    @Override
    public int getSortingWeight() {
        return 100;
    }

    public RequirementGas deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementGas deepCopyModified(List<RecipeModifier> modifiers) {
        GasStack copied = this.required.copy();
        copied.amount = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)copied.amount, false));
        RequirementGas fluid = new RequirementGas(this.actionType, copied);
        fluid.chance = RecipeModifier.applyModifiers(modifiers, this, this.chance, true);
        return fluid;
    }

    @Override
    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentGas(this);
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeGas)this.requirementType).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        return cmp.getContainerProvider() instanceof IExtendedGasHandler && cmp.ioType == this.actionType;
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.INPUT && chance.canWork(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
            this.doGasIO(components, context);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.OUTPUT && chance.canWork(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
            this.doGasIO(components, context);
        }
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        return this.doGasIO(components, context);
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return HybridFluidUtils.copyGasHandlerComponents(components);
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            if (this.doGasIOInternal(components, context, 1) >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        return this.doGasIOInternal(components, context, maxParallelism);
    }

    private CraftCheck doGasIO(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        int mul = this.doGasIOInternal(components, context, this.parallelism);
        if (mul < this.parallelism) {
            CraftCheck craftCheck;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    craftCheck = CraftCheck.failure("craftcheck.failure.gas.input");
                    break;
                }
                case OUTPUT: {
                    craftCheck = this.ignoreOutputCheck ? CraftCheck.success() : CraftCheck.failure("craftcheck.failure.gas.output.space");
                }
            }
            return craftCheck;
        }
        return CraftCheck.success();
    }

    private int doGasIOInternal(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxMultiplier) {
        List<IExtendedGasHandler> gasHandlers = HybridFluidUtils.castGasHandlerComponents(components);
        long required = Math.round(RecipeModifier.applyModifiers(context, this, (double)this.required.amount, false));
        long maxRequired = required * (long)maxMultiplier;
        GasStack stack = this.required.copy();
        long totalIO = HybridFluidUtils.doSimulateDrainOrFill(stack, gasHandlers, maxRequired, this.actionType);
        if (totalIO < required) {
            return 0;
        }
        HybridFluidUtils.doDrainOrFill(stack, totalIO, gasHandlers, this.actionType);
        return (int)(totalIO / required);
    }
}

