/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentFluidPerTick;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeFluidPerTick;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.HybridFluidUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RequirementFluidPerTick
extends ComponentRequirement.PerTickParallelizable<FluidStack, RequirementTypeFluidPerTick>
implements ComponentRequirement.Parallelizable {
    public final FluidStack required;
    protected NBTTagCompound tagMatch = null;
    protected NBTTagCompound tagDisplay = null;
    protected boolean isSuccess = false;

    public RequirementFluidPerTick(IOType actionType, FluidStack required) {
        super(RequirementTypesMM.REQUIREMENT_FLUID_PERTICK, actionType);
        this.required = required.copy();
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        ComponentType cmpType = cmp.getComponentType();
        return (cmpType.equals((Object)ComponentTypesMM.COMPONENT_FLUID) || cmpType.equals((Object)ComponentTypesMM.COMPONENT_ITEM_FLUID_GAS)) && cmp.ioType == this.actionType;
    }

    public RequirementFluidPerTick deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementFluidPerTick deepCopyModified(List<RecipeModifier> modifiers) {
        FluidStack stack = this.required.copy();
        stack.amount = (int)Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_FLUID, this.actionType, (double)stack.amount, false));
        RequirementFluidPerTick fluid = new RequirementFluidPerTick(this.actionType, stack);
        fluid.tagMatch = this.tagMatch;
        fluid.tagDisplay = this.tagDisplay;
        return fluid;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeFluidPerTick)this.requirementType).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public ComponentRequirement.JEIComponent<FluidStack> provideJEIComponent() {
        return new JEIComponentFluidPerTick(this);
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        return this.doFluidIO(components, context);
    }

    @Override
    public CraftCheck doIOTick(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float durationMultiplier) {
        return this.doFluidIO(components, context);
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return HybridFluidUtils.copyFluidHandlerComponents(components);
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            if (this.doFluidIOInternal(components, context, 1) >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        return this.doFluidIOInternal(components, context, maxParallelism);
    }

    private CraftCheck doFluidIO(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        int mul = this.doFluidIOInternal(components, context, this.parallelism);
        if (mul < this.parallelism) {
            CraftCheck craftCheck;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    craftCheck = CraftCheck.failure("craftcheck.failure.fluid.input");
                    break;
                }
                case OUTPUT: {
                    craftCheck = this.ignoreOutputCheck ? CraftCheck.success() : CraftCheck.failure("craftcheck.failure.fluid.output.space");
                }
            }
            return craftCheck;
        }
        return CraftCheck.success();
    }

    public int doFluidIOInternal(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxMultiplier) {
        List<IFluidHandler> fluidHandlers = HybridFluidUtils.castFluidHandlerComponents(components);
        long required = Math.round(RecipeModifier.applyModifiers(context, RequirementTypesMM.REQUIREMENT_FLUID, this.actionType, (double)this.required.amount, false));
        if (required <= 0L) {
            return maxMultiplier;
        }
        long maxRequired = required * (long)maxMultiplier;
        FluidStack stack = this.required.copy();
        long totalIO = HybridFluidUtils.doSimulateDrainOrFill(stack, fluidHandlers, maxRequired, this.actionType);
        if (totalIO < required) {
            return 0;
        }
        HybridFluidUtils.doDrainOrFill(stack, totalIO, fluidHandlers, this.actionType);
        return (int)(totalIO / required);
    }
}

