/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeFluid;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.HybridFluidUtils;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RequirementFluid
extends ComponentRequirement.MultiCompParallelizable<Object, RequirementTypeFluid>
implements ComponentRequirement.ChancedRequirement,
Asyncable {
    public final FluidStack required;
    public float chance = 1.0f;
    private NBTTagCompound tagMatch = null;
    private NBTTagCompound tagDisplay = null;

    public RequirementFluid(IOType ioType, @Nonnull FluidStack fluid) {
        this(RequirementTypesMM.REQUIREMENT_FLUID, ioType, fluid.copy());
    }

    private RequirementFluid(RequirementTypeFluid type, IOType ioType, FluidStack required) {
        super(type, ioType);
        this.required = required.copy();
    }

    @Override
    public int getSortingWeight() {
        return 100;
    }

    public RequirementFluid deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    public RequirementFluid deepCopyModified(List<RecipeModifier> modifiers) {
        FluidStack copied = this.required.copy();
        copied.amount = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)copied.amount, false));
        RequirementFluid fluid = new RequirementFluid((RequirementTypeFluid)this.requirementType, this.actionType, copied);
        fluid.chance = RecipeModifier.applyModifiers(modifiers, this, this.chance, true);
        fluid.tagMatch = this.getTagMatch();
        fluid.tagDisplay = this.getTagDisplay();
        return fluid;
    }

    @Override
    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentFluid(this);
    }

    public void setMatchNBTTag(@Nullable NBTTagCompound tag) {
        this.tagMatch = tag;
    }

    @Nullable
    public NBTTagCompound getTagMatch() {
        if (this.tagMatch == null) {
            return null;
        }
        return this.tagMatch.func_74737_b();
    }

    public void setDisplayNBTTag(@Nullable NBTTagCompound tag) {
        this.tagDisplay = tag;
    }

    @Nullable
    public NBTTagCompound getTagDisplay() {
        if (this.tagDisplay == null) {
            return null;
        }
        return this.tagDisplay.func_74737_b();
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeFluid)this.requirementType).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        ComponentType cmpType = cmp.getComponentType();
        return (cmpType.equals((Object)ComponentTypesMM.COMPONENT_FLUID) || cmpType.equals((Object)ComponentTypesMM.COMPONENT_ITEM_FLUID_GAS)) && cmp.ioType == this.actionType;
    }

    @Override
    public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.INPUT && chance.canWork(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
            this.doFluidIO(components, context);
        }
    }

    @Override
    public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        if (this.actionType == IOType.OUTPUT && chance.canWork(RecipeModifier.applyModifiers(context, this, this.chance, true))) {
            this.doFluidIO(components, context);
        }
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        return this.doFluidIO(components, context);
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        return HybridFluidUtils.copyFluidHandlerComponents(components);
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            if (this.doFluidIOInternal(components, context, 1) >= 1) {
                return maxParallelism;
            }
            return 0;
        }
        return this.doFluidIOInternal(components, context, maxParallelism);
    }

    private CraftCheck doFluidIO(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        int mul = this.doFluidIOInternal(components, context, this.parallelism);
        if (mul < this.parallelism) {
            CraftCheck craftCheck;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    craftCheck = CraftCheck.failure("craftcheck.failure.fluid.input");
                    break;
                }
                case OUTPUT: {
                    craftCheck = this.ignoreOutputCheck ? CraftCheck.success() : CraftCheck.failure("craftcheck.failure.fluid.output.space");
                }
            }
            return craftCheck;
        }
        return CraftCheck.success();
    }

    private int doFluidIOInternal(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxMultiplier) {
        List<IFluidHandler> fluidHandlers = HybridFluidUtils.castFluidHandlerComponents(components);
        long required = Math.round(RecipeModifier.applyModifiers(context, this, (double)this.required.amount, false));
        long maxRequired = required * (long)maxMultiplier;
        FluidStack stack = this.required.copy();
        long totalIO = HybridFluidUtils.doSimulateDrainOrFill(stack, fluidHandlers, maxRequired, this.actionType);
        if (totalIO < required) {
            return 0;
        }
        HybridFluidUtils.doDrainOrFill(stack, totalIO, fluidHandlers, this.actionType);
        return (int)(totalIO / required);
    }
}

