/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirement;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.jei.JEIComponentEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementTypeEnergy;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.Asyncable;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class RequirementEnergy
extends ComponentRequirement.PerTickParallelizable<Long, RequirementTypeEnergy>
implements ComponentRequirement.Parallelizable,
Asyncable {
    public final long requirementPerTick;

    public RequirementEnergy(IOType ioType, long requirementPerTick) {
        super(RequirementTypesMM.REQUIREMENT_ENERGY, ioType);
        this.requirementPerTick = requirementPerTick;
    }

    @Override
    public int getSortingWeight() {
        return 50000000;
    }

    @Override
    public ComponentRequirement<Long, RequirementTypeEnergy> deepCopy() {
        return this.deepCopyModified(Collections.emptyList());
    }

    @Override
    public ComponentRequirement<Long, RequirementTypeEnergy> deepCopyModified(List<RecipeModifier> modifiers) {
        long requirement = Math.round(RecipeModifier.applyModifiers(modifiers, this, (double)this.requirementPerTick, false));
        return new RequirementEnergy(this.actionType, requirement);
    }

    @Override
    @Nonnull
    public String getMissingComponentErrorMessage(IOType ioType) {
        ResourceLocation compKey = ((RequirementTypeEnergy)this.requirementType).getRegistryName();
        return String.format("component.missing.%s.%s.%s", compKey.func_110624_b(), compKey.func_110623_a(), ioType.name().toLowerCase());
    }

    public long getRequiredEnergyPerTick() {
        return this.requirementPerTick;
    }

    @Override
    public ComponentRequirement.JEIComponent<Long> provideJEIComponent() {
        return new JEIComponentEnergy(this);
    }

    @Override
    public boolean isValidComponent(ProcessingComponent<?> component, RecipeCraftingContext ctx) {
        MachineComponent<?> cmp = component.component();
        return cmp.getComponentType().equals((Object)ComponentTypesMM.COMPONENT_ENERGY) && cmp.getContainerProvider() instanceof IEnergyHandler && cmp instanceof MachineComponent.EnergyHatch && cmp.ioType == this.actionType;
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context) {
        return this.doEnergyIO(components, context, 1.0f, true);
    }

    @Override
    public CraftCheck doIOTick(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float durationMultiplier) {
        return this.doEnergyIO(components, context, durationMultiplier, false);
    }

    @Override
    @Nonnull
    public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> components) {
        ArrayList list = new ArrayList();
        for (ProcessingComponent<?> component : components) {
            ProcessingComponent<IEnergyHandlerImpl> objectProcessingComponent = new ProcessingComponent<IEnergyHandlerImpl>(component.component(), new IEnergyHandlerImpl((IEnergyHandler)component.getProvidedComponent()), component.getTag());
            list.add(objectProcessingComponent);
        }
        return list;
    }

    @Override
    public int getMaxParallelism(List<ProcessingComponent<?>> components, RecipeCraftingContext context, int maxParallelism) {
        if (this.ignoreOutputCheck && this.actionType == IOType.OUTPUT) {
            return maxParallelism;
        }
        if (this.parallelizeUnaffected) {
            if (this.doEnergyIOInternal(components, context, 1.0f, true) >= 1.0f) {
                return maxParallelism;
            }
            return 0;
        }
        return (int)this.doEnergyIOInternal(components, context, maxParallelism, true);
    }

    private CraftCheck doEnergyIO(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float durationMultiplier, boolean simulate) {
        float maxMultiplier = (float)this.parallelism * durationMultiplier;
        float mul = this.doEnergyIOInternal(components, context, maxMultiplier, simulate);
        if (mul < maxMultiplier) {
            CraftCheck craftCheck;
            switch (this.actionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INPUT: {
                    craftCheck = CraftCheck.failure("craftcheck.failure.energy.input");
                    break;
                }
                case OUTPUT: {
                    craftCheck = this.ignoreOutputCheck ? CraftCheck.success() : CraftCheck.failure("craftcheck.failure.energy.output.space");
                }
            }
            return craftCheck;
        }
        return CraftCheck.success();
    }

    private float doEnergyIOInternal(List<ProcessingComponent<?>> components, RecipeCraftingContext context, float maxMultiplier, boolean simulate) {
        long required = (long)RecipeModifier.applyModifiers(context, this, (double)this.requirementPerTick, false);
        long maxRequired = (long)((float)required * maxMultiplier);
        List<IEnergyHandler> handlers = components.size() == 1 ? Collections.singletonList((IEnergyHandler)components.get(0).getProvidedComponent()) : Lists.transform(components, component -> component != null ? (IEnergyHandler)component.getProvidedComponent() : null);
        float consumed = this.consumeOrInsertEnergy(handlers, maxRequired, required, maxMultiplier, true);
        if (simulate) {
            return consumed;
        }
        if (consumed >= maxMultiplier) {
            return this.consumeOrInsertEnergy(handlers, maxRequired, required, maxMultiplier, false);
        }
        return 0.0f;
    }

    private float consumeOrInsertEnergy(List<IEnergyHandler> handlers, double total, long required, float multiplier, boolean simulate) {
        double maxRequired = total;
        switch (this.actionType) {
            case INPUT: {
                for (IEnergyHandler handler : handlers) {
                    long current = handler.getCurrentEnergy();
                    long toConsume = (long)Math.min((double)current, maxRequired);
                    if (!simulate) {
                        if (handler instanceof IEnergyHandlerAsync) {
                            IEnergyHandlerAsync handlerAsync = (IEnergyHandlerAsync)handler;
                            if (!handlerAsync.extractEnergy(toConsume)) continue;
                            maxRequired -= (double)toConsume;
                            continue;
                        }
                        handler.setCurrentEnergy(current - toConsume);
                        maxRequired -= (double)toConsume;
                        continue;
                    }
                    maxRequired -= (double)toConsume;
                }
                break;
            }
            case OUTPUT: {
                for (IEnergyHandler handler : handlers) {
                    long remaining = handler.getRemainingCapacity();
                    long toReceive = (long)Math.min((double)remaining, maxRequired);
                    if (!simulate) {
                        if (handler instanceof IEnergyHandlerAsync) {
                            IEnergyHandlerAsync handlerAsync = (IEnergyHandlerAsync)handler;
                            if (!handlerAsync.receiveEnergy(toReceive)) continue;
                            maxRequired -= (double)toReceive;
                            continue;
                        }
                        handler.setCurrentEnergy(handler.getCurrentEnergy() + toReceive);
                        maxRequired -= (double)toReceive;
                        continue;
                    }
                    maxRequired -= (double)toReceive;
                }
                break;
            }
        }
        if (maxRequired > 0.0) {
            return (float)((total - maxRequired) / (double)required);
        }
        return multiplier;
    }
}

