/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ComponentRequirement<T, V extends RequirementType<T, ? extends ComponentRequirement<T, V>>> {
    public static final int PRIORITY_WEIGHT_ENERGY = 50000000;
    public static final int PRIORITY_WEIGHT_FLUID = 100;
    public static final int PRIORITY_WEIGHT_ITEM = 50000;
    public final V requirementType;
    protected final IOType actionType;
    protected ComponentSelectorTag tag = null;
    protected boolean triggered = false;
    protected boolean triggerRepeatable = false;
    protected int triggerTime = 0;
    protected boolean ignoreOutputCheck = false;

    public ComponentRequirement(V requirementType, IOType actionType) {
        this.requirementType = requirementType;
        this.actionType = actionType;
    }

    public final V getRequirementType() {
        return this.requirementType;
    }

    public final IOType getActionType() {
        return this.actionType;
    }

    public final ComponentSelectorTag getTag() {
        return this.tag;
    }

    public final void setTag(ComponentSelectorTag tag) {
        this.tag = tag;
    }

    public int getTriggerTime() {
        return this.triggerTime;
    }

    public void setTriggerTime(int tickTime) {
        this.triggerTime = tickTime;
    }

    public boolean isTriggerRepeatable() {
        return this.triggerRepeatable;
    }

    public void setTriggerRepeatable(boolean triggerRepeatable) {
        this.triggerRepeatable = triggerRepeatable;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }

    public int getSortingWeight() {
        return 0;
    }

    public abstract boolean isValidComponent(ProcessingComponent<?> var1, RecipeCraftingContext var2);

    public boolean startCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        return true;
    }

    @Nonnull
    public CraftCheck finishCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, ResultChance chance) {
        return CraftCheck.success();
    }

    @Nonnull
    public abstract CraftCheck canStartCrafting(ProcessingComponent<?> var1, RecipeCraftingContext var2, List<ComponentOutputRestrictor> var3);

    public abstract ComponentRequirement<T, V> deepCopy();

    public abstract ComponentRequirement<T, V> deepCopyModified(List<RecipeModifier> var1);

    public ComponentRequirement<T, V> postDeepCopy(ComponentRequirement<?, ?> another) {
        this.tag = another.tag;
        this.triggerTime = another.triggerTime;
        this.triggerRepeatable = another.triggerRepeatable;
        this.ignoreOutputCheck = another.ignoreOutputCheck;
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    @Nonnull
    public abstract String getMissingComponentErrorMessage(IOType var1);

    public abstract JEIComponent<T> provideJEIComponent();

    public void initializeJEIRequirements() {
    }

    public boolean isIgnoreOutputCheck() {
        return this.ignoreOutputCheck;
    }

    public void setIgnoreOutputCheck(boolean ignoreOutputCheck) {
        this.ignoreOutputCheck = ignoreOutputCheck;
    }

    public static abstract class PerTickParallelizable<T, V extends RequirementType<T, ? extends PerTick<T, V>>>
    extends PerTickMultiComponent<T, V>
    implements Parallelizable {
        protected int parallelism = 1;
        protected boolean parallelizeUnaffected = false;

        public PerTickParallelizable(V requirementType, IOType actionType) {
            super(requirementType, actionType);
        }

        @Override
        public ComponentRequirement<T, V> postDeepCopy(ComponentRequirement<?, ?> another) {
            super.postDeepCopy(another);
            if (another instanceof PerTickParallelizable) {
                PerTickParallelizable parallelizable = (PerTickParallelizable)another;
                this.parallelizeUnaffected = parallelizable.parallelizeUnaffected;
            }
            return this;
        }

        @Override
        public boolean isParallelizeUnaffected() {
            return this.parallelizeUnaffected;
        }

        @Override
        public void setParallelizeUnaffected(boolean unaffected) {
            this.parallelizeUnaffected = unaffected;
            if (this.parallelizeUnaffected) {
                this.parallelism = 1;
            }
        }

        @Override
        public int getParallelism() {
            return this.parallelism;
        }

        @Override
        public void setParallelism(int parallelism) {
            if (!this.parallelizeUnaffected) {
                this.parallelism = parallelism;
            }
        }
    }

    public static abstract class PerTickMultiComponent<T, V extends RequirementType<T, ? extends PerTick<T, V>>>
    extends PerTick<T, V>
    implements MultiComponent {
        public PerTickMultiComponent(V requirementType, IOType actionType) {
            super(requirementType, actionType);
        }

        @Override
        @Nonnull
        public final CraftCheck doIOTick(ProcessingComponent<?> component, RecipeCraftingContext context) {
            return CraftCheck.success();
        }

        public abstract CraftCheck doIOTick(List<ProcessingComponent<?>> var1, RecipeCraftingContext var2, float var3);
    }

    public static abstract class PerTick<T, V extends RequirementType<T, ? extends PerTick<T, V>>>
    extends ComponentRequirement<T, V> {
        public PerTick(V requirementType, IOType actionType) {
            super(requirementType, actionType);
        }

        @Override
        @Nonnull
        public CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
            return CraftCheck.success();
        }

        public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        }

        @Nonnull
        public CraftCheck resetIOTick(RecipeCraftingContext context) {
            return CraftCheck.success();
        }

        @Nonnull
        public abstract CraftCheck doIOTick(ProcessingComponent<?> var1, RecipeCraftingContext var2);
    }

    public static abstract class MultiCompParallelizable<T, V extends RequirementType<T, ? extends ComponentRequirement<T, V>>>
    extends MultiComponentRequirement<T, V>
    implements Parallelizable {
        protected int parallelism = 1;
        protected boolean parallelizeUnaffected = false;

        public MultiCompParallelizable(V requirementType, IOType actionType) {
            super(requirementType, actionType);
        }

        @Override
        public ComponentRequirement<T, V> postDeepCopy(ComponentRequirement<?, ?> another) {
            super.postDeepCopy(another);
            if (another instanceof MultiCompParallelizable) {
                MultiCompParallelizable parallelizable = (MultiCompParallelizable)another;
                this.parallelizeUnaffected = parallelizable.parallelizeUnaffected;
            }
            return this;
        }

        @Override
        public boolean isParallelizeUnaffected() {
            return this.parallelizeUnaffected;
        }

        @Override
        public void setParallelizeUnaffected(boolean unaffected) {
            this.parallelizeUnaffected = unaffected;
            if (this.parallelizeUnaffected) {
                this.parallelism = 1;
            }
        }

        @Override
        public int getParallelism() {
            return this.parallelism;
        }

        @Override
        public void setParallelism(int parallelism) {
            if (!this.parallelizeUnaffected) {
                this.parallelism = parallelism;
            }
        }
    }

    public static abstract class MultiComponentRequirement<T, V extends RequirementType<T, ? extends ComponentRequirement<T, V>>>
    extends ComponentRequirement<T, V>
    implements MultiComponent {
        public MultiComponentRequirement(V requirementType, IOType actionType) {
            super(requirementType, actionType);
        }

        @Override
        @Nonnull
        public final CraftCheck canStartCrafting(ProcessingComponent<?> component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
            return CraftCheck.success();
        }
    }

    public static abstract class JEIComponent<T> {
        public abstract Class<T> getJEIRequirementClass();

        public abstract List<T> getJEIIORequirements();

        @SideOnly(value=Side.CLIENT)
        public abstract RecipeLayoutPart<T> getLayoutPart(Point var1);

        @SideOnly(value=Side.CLIENT)
        public RecipeLayoutPart<T> getTemplateLayout() {
            return this.getLayoutPart(new Point(0, 0));
        }

        @SideOnly(value=Side.CLIENT)
        public abstract void onJEIHoverTooltip(int var1, boolean var2, T var3, List<String> var4);
    }

    public static interface MultiComponent {
        @Nonnull
        public List<ProcessingComponent<?>> copyComponents(List<ProcessingComponent<?>> var1);

        @Nonnull
        public CraftCheck canStartCrafting(List<ProcessingComponent<?>> var1, RecipeCraftingContext var2);

        default public void startCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        }

        default public void finishCrafting(List<ProcessingComponent<?>> components, RecipeCraftingContext context, ResultChance chance) {
        }
    }

    public static interface Parallelizable
    extends MultiComponent {
        public int getMaxParallelism(List<ProcessingComponent<?>> var1, RecipeCraftingContext var2, int var3);

        public int getParallelism();

        public void setParallelism(int var1);

        public boolean isParallelizeUnaffected();

        public void setParallelizeUnaffected(boolean var1);
    }

    public static interface ChancedRequirement {
        public void setChance(float var1);
    }
}

