/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter.te5;

import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.mmce.common.util.HashedItemStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeAdapter
extends RecipeAdapter {
    public static final int ENERGY_PER_TICK = 20;
    private final boolean tree;

    public InsolatorRecipeAdapter(boolean tree) {
        super(new ResourceLocation("thermalexpansion", tree ? "insolator_tree" : "insolator"));
        this.tree = tree;
    }

    private static boolean isFertilizer(ItemStack primaryInput) {
        return InsolatorManager.isItemFertilizer((ItemStack)primaryInput) || primaryInput.func_77973_b() == Items.field_151114_aO;
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        ArrayList<MachineRecipe> recipes = new ArrayList<MachineRecipe>();
        InsolatorManager.InsolatorRecipe[] insolatorRecipes = InsolatorManager.getRecipeList();
        Arrays.sort(insolatorRecipes, (o1, o2) -> {
            ItemStack primaryOutput = o1.getPrimaryOutput();
            ItemStack primaryOutput2 = o2.getPrimaryOutput();
            int result = Integer.compare(primaryOutput.func_190916_E(), primaryOutput2.func_190916_E());
            if (result != 0) {
                return result;
            }
            return Integer.compare(o1.getSecondaryOutputChance(), o2.getSecondaryOutputChance());
        });
        ObjectOpenHashSet inputs = new ObjectOpenHashSet();
        for (InsolatorManager.InsolatorRecipe insolatorRecipe : insolatorRecipes) {
            boolean isTree;
            boolean bl = isTree = insolatorRecipe.getType() == InsolatorManager.Type.TREE;
            if (this.tree != isTree) continue;
            ItemStack primaryInput = insolatorRecipe.getPrimaryInput();
            ItemStack secondaryInput = insolatorRecipe.getSecondaryInput();
            boolean hasFertilizer = insolatorRecipe.hasFertilizer();
            ItemStack input = hasFertilizer ? (InsolatorRecipeAdapter.isFertilizer(primaryInput) ? secondaryInput : primaryInput) : primaryInput;
            HashedItemStack hashed = HashedItemStack.ofUnsafe(input);
            if (inputs.contains(hashed)) continue;
            inputs.add(hashed.copy());
            ItemStack primaryOutput = insolatorRecipe.getPrimaryOutput();
            ItemStack secondaryOutput = insolatorRecipe.getSecondaryOutput();
            int secondaryOutputChance = insolatorRecipe.getSecondaryOutputChance();
            int water = insolatorRecipe.getWater();
            int energy = insolatorRecipe.getEnergy();
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("thermalexpansion", (this.tree ? "insolator_tree_" : "insolator_") + this.incId), owningMachineName, Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, IOType.INPUT, (float)energy / 20.0f, false)), this.incId, false);
            ++this.incId;
            int energyPerTick = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, 20.0f, false));
            if (energyPerTick > 0) {
                recipe.addRequirement(new RequirementEnergy(IOType.INPUT, energyPerTick));
            }
            int primaryInputAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)input.func_190916_E(), false));
            int secondaryInputAmount = hasFertilizer ? 0 : Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)secondaryInput.func_190916_E(), false));
            int waterAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_FLUID, IOType.INPUT, (float)water, false));
            int primaryOutputAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.OUTPUT, (float)primaryOutput.func_190916_E(), false));
            int secondaryOutputAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.OUTPUT, (float)secondaryOutput.func_190916_E(), false));
            float secondaryOutputChanceModified = RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.OUTPUT, (float)secondaryOutputChance / 100.0f, true);
            if (primaryInputAmount > 0) {
                recipe.addRequirement(new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize(input, primaryInputAmount)));
            }
            if (secondaryInputAmount > 0) {
                recipe.addRequirement(new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize(secondaryInput, secondaryInputAmount)));
            }
            if (waterAmount > 0) {
                recipe.addRequirement(new RequirementFluid(IOType.INPUT, new FluidStack(FluidRegistry.WATER, waterAmount)));
            }
            if (primaryOutputAmount > 0) {
                recipe.addRequirement(new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize(primaryOutput, primaryOutputAmount)));
            }
            if (secondaryOutputAmount > 0) {
                if (secondaryOutputChanceModified > 1.0f) {
                    int secOutputAmt = secondaryOutputAmount * (int)secondaryOutputChanceModified;
                    recipe.addRequirement(new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize(secondaryOutput, secOutputAmt)));
                    float thirdOutputChance = secondaryOutputChanceModified - (float)((int)secondaryOutputChanceModified);
                    if (thirdOutputChance > 0.0f) {
                        RequirementItem thirdOutput = new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize(secondaryOutput, secondaryOutputAmount));
                        thirdOutput.setChance(thirdOutputChance);
                        recipe.addRequirement(thirdOutput);
                    }
                } else {
                    RequirementItem secondOutput = new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize(secondaryOutput, secondaryOutputAmount));
                    secondOutput.setChance(secondaryOutputChanceModified);
                    recipe.addRequirement(secondOutput);
                }
            }
            recipes.add(recipe);
        }
        return recipes;
    }
}

