/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter.nco;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.nco.AdapterNCOMachine;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.recipe.processor.MelterRecipes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AdapterNCOMelter
extends AdapterNCOMachine {
    public static final int WORK_TIME = 800;
    public static final int BASE_ENERGY_USAGE = 40;

    public AdapterNCOMelter() {
        super(new ResourceLocation("nuclearcraft", "melter"));
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        MelterRecipes melterRecipes = NCRecipes.melter;
        List recipeList = melterRecipes.getRecipeList();
        ArrayList<MachineRecipe> machineRecipeList = new ArrayList<MachineRecipe>(recipeList.size());
        for (BasicRecipe basicRecipe : recipeList) {
            int inAmount;
            ItemStack stack;
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("nuclearcraft", "melter_" + this.incId), owningMachineName, (int)basicRecipe.getBaseProcessTime((double)Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, IOType.INPUT, 800.0f, false))), this.incId, false);
            for (IItemIngredient iItemIngredient : basicRecipe.getItemIngredients()) {
                stack = (ItemStack)iItemIngredient.getStack();
                inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)stack.func_190916_E(), false));
                if (inAmount <= 0) continue;
                if (iItemIngredient instanceof OreIngredient) {
                    OreIngredient oreIngredient = (OreIngredient)iItemIngredient;
                    recipe.addRequirement(new RequirementItem(IOType.INPUT, oreIngredient.oreName, inAmount));
                    continue;
                }
                if (iItemIngredient instanceof ItemArrayIngredient) {
                    ItemArrayIngredient arrayIngredient = (ItemArrayIngredient)iItemIngredient;
                    List ingredientList = arrayIngredient.ingredientList;
                    ArrayList<ChancedIngredientStack> ingredientStackList = new ArrayList<ChancedIngredientStack>(ingredientList.size());
                    for (IItemIngredient itemIngredient : ingredientList) {
                        if (itemIngredient instanceof OreIngredient) {
                            OreIngredient oreIngredient = (OreIngredient)itemIngredient;
                            int subInAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)oreIngredient.stackSize, false));
                            ingredientStackList.add(new ChancedIngredientStack(oreIngredient.oreName, subInAmount));
                            continue;
                        }
                        ItemStack ingredientStack = (ItemStack)itemIngredient.getStack();
                        int subInAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)ingredientStack.func_190916_E(), false));
                        ingredientStackList.add(new ChancedIngredientStack(ItemUtils.copyStackWithSize(ingredientStack, subInAmount)));
                    }
                    recipe.addRequirement(new RequirementIngredientArray(ingredientStackList));
                    continue;
                }
                recipe.addRequirement(new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize(stack, inAmount)));
            }
            for (IFluidIngredient fluidIngredient : basicRecipe.getFluidProducts()) {
                stack = ((FluidStack)fluidIngredient.getStack()).copy();
                inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_FLUID, IOType.INPUT, (float)stack.amount, false));
                if (inAmount <= 0) continue;
                stack.amount = inAmount;
                recipe.addRequirement(new RequirementFluid(IOType.OUTPUT, (FluidStack)stack));
            }
            recipe.addRequirement(new RequirementEnergy(IOType.INPUT, Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, 40.0f, false))));
            machineRecipeList.add(recipe);
            ++this.incId;
        }
        return machineRecipeList;
    }
}

