/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter.nco;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.nco.AdapterNCOMachine;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementFluid;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.IFluidIngredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AdapterNCOChemicalReactor
extends AdapterNCOMachine {
    public static final int WORK_TIME = 400;
    public static final int BASE_ENERGY_USAGE = 5;

    public AdapterNCOChemicalReactor() {
        super(new ResourceLocation("nuclearcraft", "chemical_reactor"));
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        List recipeList = NCRecipes.chemical_reactor.getRecipeList();
        ArrayList<MachineRecipe> machineRecipeList = new ArrayList<MachineRecipe>(recipeList.size());
        for (BasicRecipe basicRecipe : recipeList) {
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("nuclearcraft", "chemical_reactor_" + this.incId), owningMachineName, (int)basicRecipe.getBaseProcessTime((double)Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, IOType.INPUT, 400.0f, false))), this.incId, false);
            for (IFluidIngredient fluidIngredient : basicRecipe.getFluidIngredients()) {
                FluidStack copied = ((FluidStack)fluidIngredient.getStack()).copy();
                int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_FLUID, IOType.INPUT, (float)copied.amount, false));
                if (inAmount <= 0) continue;
                copied.amount = inAmount;
                recipe.addRequirement(new RequirementFluid(IOType.INPUT, copied));
            }
            for (IFluidIngredient fluidProduct : basicRecipe.getFluidProducts()) {
                FluidStack productStack = (FluidStack)fluidProduct.getStack();
                if (productStack == null) continue;
                FluidStack copied = productStack.copy();
                int outputAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_FLUID, IOType.OUTPUT, (float)copied.amount, false));
                if (outputAmount <= 0) continue;
                copied.amount = outputAmount;
                recipe.addRequirement(new RequirementFluid(IOType.OUTPUT, copied));
            }
            recipe.addRequirement(new RequirementEnergy(IOType.INPUT, Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, 5.0f, false))));
            machineRecipeList.add(recipe);
            ++this.incId;
        }
        return machineRecipeList;
    }
}

