/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;

public class AdapterMinecraftFurnace
extends RecipeAdapter {
    public AdapterMinecraftFurnace() {
        super(new ResourceLocation("minecraft", "furnace"));
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?, ?>> additionalRequirements, Map<Class<?>, List<IEventHandler<RecipeEvent>>> eventHandlers, List<String> recipeTooltips) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        Map inputOutputMap = furnaceRecipes.func_77599_b();
        ArrayList<MachineRecipe> smeltingRecipes = new ArrayList<MachineRecipe>(inputOutputMap.size());
        for (Map.Entry smelting : inputOutputMap.entrySet()) {
            int inEnergy;
            int outAmount;
            ItemStack input = (ItemStack)smelting.getKey();
            ItemStack output = (ItemStack)smelting.getValue();
            int tickTime = Math.round(Math.max(1.0f, RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, null, 120.0f, false)));
            float experience = furnaceRecipes.func_151398_b(output);
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("minecraft", "smelting_" + this.incId + "_" + input + "_" + output), owningMachineName, tickTime, 0, false);
            recipe.addRecipeEventHandler(RecipeCheckEvent.class, event -> {
                if (event.phase == Phase.START) {
                    event.getActiveRecipe().getDataCompound().func_74776_a("experience", experience);
                }
            });
            int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.INPUT, (float)input.func_190916_E(), false));
            if (inAmount > 0) {
                recipe.addRequirement(new RequirementItem(IOType.INPUT, ItemUtils.copyStackWithSize(input, inAmount)));
            }
            if ((outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ITEM, IOType.OUTPUT, (float)output.func_190916_E(), false))) > 0) {
                recipe.addRequirement(new RequirementItem(IOType.OUTPUT, ItemUtils.copyStackWithSize(output, outAmount)));
            }
            if ((inEnergy = Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, 20.0f, false))) > 0) {
                recipe.addRequirement(new RequirementEnergy(IOType.INPUT, inEnergy));
            }
            smeltingRecipes.add(recipe);
        }
        ++this.incId;
        return smeltingRecipes;
    }
}

