/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.IntegrationTypeHelper;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeLoader;
import hellfirepvp.modularmachinery.common.crafting.command.RecipeCommandContainer;
import hellfirepvp.modularmachinery.common.crafting.command.RecipeRunnableCommand;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipeAdapterBuilder;
import hellfirepvp.modularmachinery.common.lib.RegistriesMM;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineRecipe
implements Comparable<MachineRecipe> {
    protected static int counter = 0;
    protected final int sortId;
    protected final String recipeFilePath;
    protected final ResourceLocation owningMachine;
    protected final ResourceLocation registryName;
    protected final int tickTime;
    protected final List<ComponentRequirement<?, ?>> recipeRequirements = Lists.newArrayList();
    protected final RecipeCommandContainer commandContainer = new RecipeCommandContainer();
    protected final int configuredPriority;
    protected final boolean voidPerTickFailure;
    protected final Map<Class<?>, List<IEventHandler<RecipeEvent>>> recipeEventHandlers;
    protected final List<String> tooltipList;
    protected boolean parallelized;
    protected String threadName;
    protected int maxThreads;
    protected boolean loadJEI;

    public MachineRecipe(String path, ResourceLocation registryName, ResourceLocation owningMachine, int tickTime, int configuredPriority, boolean voidPerTickFailure, boolean parallelized) {
        this.sortId = counter++;
        this.recipeFilePath = path;
        this.registryName = registryName;
        this.owningMachine = owningMachine;
        this.tickTime = tickTime;
        this.configuredPriority = configuredPriority;
        this.voidPerTickFailure = voidPerTickFailure;
        this.parallelized = parallelized;
        this.recipeEventHandlers = new HashMap();
        this.tooltipList = new ArrayList<String>();
        this.threadName = "";
        this.maxThreads = -1;
        this.loadJEI = true;
    }

    public MachineRecipe(String path, ResourceLocation registryName, ResourceLocation owningMachine, int tickTime, int configuredPriority, boolean voidPerTickFailure, boolean parallelized, Map<Class<?>, List<IEventHandler<RecipeEvent>>> recipeEventHandlers, List<String> tooltipList, String threadName, int maxThreads, boolean loadJEI) {
        this.sortId = counter++;
        this.recipeFilePath = path;
        this.registryName = registryName;
        this.owningMachine = owningMachine;
        this.tickTime = tickTime;
        this.configuredPriority = configuredPriority;
        this.voidPerTickFailure = voidPerTickFailure;
        this.parallelized = parallelized;
        this.recipeEventHandlers = recipeEventHandlers;
        this.tooltipList = tooltipList;
        this.threadName = threadName;
        this.maxThreads = maxThreads;
        this.loadJEI = loadJEI;
    }

    public MachineRecipe(PreparedRecipe preparedRecipe) {
        this.sortId = counter++;
        this.recipeFilePath = preparedRecipe.getFilePath();
        this.registryName = preparedRecipe.getRecipeRegistryName();
        this.owningMachine = preparedRecipe.getAssociatedMachineName();
        this.tickTime = preparedRecipe.getTotalProcessingTickTime();
        this.configuredPriority = preparedRecipe.getPriority();
        this.voidPerTickFailure = preparedRecipe.voidPerTickFailure();
        this.parallelized = preparedRecipe.isParallelized();
        this.recipeEventHandlers = preparedRecipe.getRecipeEventHandlers();
        this.tooltipList = preparedRecipe.getTooltipList();
        this.threadName = preparedRecipe.getThreadName();
        this.maxThreads = preparedRecipe.getMaxThreads();
        this.loadJEI = preparedRecipe.getLoadJEI();
    }

    public void mergeAdapter(RecipeAdapterBuilder adapterBuilder) {
        this.parallelized = adapterBuilder.isParallelized();
        this.tooltipList.addAll(adapterBuilder.getTooltipList());
        this.loadJEI = adapterBuilder.getLoadJEI();
        if (!adapterBuilder.getThreadName().isEmpty()) {
            this.threadName = adapterBuilder.getThreadName();
        }
        if (adapterBuilder.getMaxThreads() != -1) {
            this.maxThreads = adapterBuilder.getMaxThreads();
        }
        for (ComponentRequirement<?, ?> requirement : adapterBuilder.getComponents()) {
            this.addRequirement(requirement);
        }
        adapterBuilder.getRecipeEventHandlers().forEach((clazz, actions) -> actions.forEach(action -> this.addRecipeEventHandler((Class<?>)clazz, (IEventHandler)action)));
    }

    public void addTooltip(String tooltip) {
        this.tooltipList.add(tooltip);
    }

    public List<String> getTooltipList() {
        return this.tooltipList;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getFormattedTooltip() {
        return this.tooltipList.stream().map(tip -> I18n.func_188566_a((String)tip) ? I18n.func_135052_a((String)tip, (Object[])new Object[0]) : tip).collect(Collectors.toList());
    }

    public <H extends RecipeEvent> void addRecipeEventHandler(Class<?> hClass, IEventHandler<H> handler) {
        this.recipeEventHandlers.putIfAbsent(hClass, new ArrayList());
        this.recipeEventHandlers.get(hClass).add(handler);
    }

    public boolean isParallelized() {
        return this.parallelized;
    }

    @Nullable
    public List<IEventHandler<RecipeEvent>> getRecipeEventHandlers(Class<?> handlerClass) {
        return this.recipeEventHandlers.get(handlerClass);
    }

    public Map<Class<?>, List<IEventHandler<RecipeEvent>>> getRecipeEventHandlers() {
        return this.recipeEventHandlers;
    }

    public String getRecipeFilePath() {
        return this.recipeFilePath;
    }

    public boolean getLoadJEI() {
        return this.loadJEI;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ResourceLocation getOwningMachineIdentifier() {
        return this.owningMachine;
    }

    public List<ComponentRequirement<?, ?>> getCraftingRequirements() {
        return Collections.unmodifiableList(this.recipeRequirements);
    }

    public RecipeCommandContainer getCommandContainer() {
        return this.commandContainer;
    }

    public void addRequirement(ComponentRequirement<?, ?> requirement) {
        if (requirement instanceof RequirementEnergy) {
            for (ComponentRequirement<?, ?> req : this.recipeRequirements) {
                if (!(req instanceof RequirementEnergy) || req.getActionType() != requirement.getActionType()) continue;
                throw new IllegalStateException("Tried to add multiple energy requirements for the same ioType! Please only add one for each ioType!");
            }
        }
        this.recipeRequirements.add(requirement);
    }

    public int getRecipeTotalTickTime() {
        return this.tickTime;
    }

    public int getConfiguredPriority() {
        return this.configuredPriority;
    }

    public boolean doesCancelRecipeOnPerTickFailure() {
        return this.voidPerTickFailure;
    }

    @Nullable
    public DynamicMachine getOwningMachine() {
        return MachineRegistry.getRegistry().getMachine(this.owningMachine);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public MachineRecipe copy(Function<ResourceLocation, ResourceLocation> registryNameChange, ResourceLocation newOwningMachineIdentifier, List<RecipeModifier> modifiers) {
        MachineRecipe copy = new MachineRecipe(this.recipeFilePath, registryNameChange.apply(this.registryName), newOwningMachineIdentifier, Math.round(RecipeModifier.applyModifiers(modifiers, RequirementTypesMM.REQUIREMENT_DURATION, null, (float)this.tickTime, false)), this.configuredPriority, this.doesCancelRecipeOnPerTickFailure(), this.parallelized, this.recipeEventHandlers, this.tooltipList, this.threadName, this.maxThreads, this.loadJEI);
        for (ComponentRequirement<?, ?> requirement : this.getCraftingRequirements()) {
            copy.addRequirement(requirement.deepCopyModified(modifiers).postDeepCopy(requirement));
        }
        return copy;
    }

    @Override
    public int compareTo(MachineRecipe o) {
        return Integer.compare(this.buildWeight(), o.buildWeight());
    }

    private int buildWeight() {
        int weightOut = this.sortId;
        for (ComponentRequirement<?, ?> req : this.recipeRequirements) {
            if (req.getActionType() == IOType.OUTPUT) continue;
            weightOut -= req.getSortingWeight();
        }
        return weightOut;
    }

    public static class ComponentDeserializer
    implements JsonDeserializer<ComponentRequirement<?, ?>> {
        public ComponentRequirement<?, ?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Component Requirements have to be objects!");
            }
            JsonObject requirement = json.getAsJsonObject();
            if (!(requirement.has("type") && requirement.get("type").isJsonPrimitive() && requirement.get("type").getAsJsonPrimitive().isString())) {
                throw new JsonParseException("'type' of a requirement is missing or isn't a string!");
            }
            String type = requirement.getAsJsonPrimitive("type").getAsString();
            if (!(requirement.has("io-type") && requirement.get("io-type").isJsonPrimitive() && requirement.get("io-type").getAsJsonPrimitive().isString())) {
                throw new JsonParseException("'io-type' of a requirement is missing or isn't a string!");
            }
            String ioType = requirement.getAsJsonPrimitive("io-type").getAsString();
            RequirementType<?, ?> requirementType = (RequirementType<?, ?>)RegistriesMM.REQUIREMENT_TYPE_REGISTRY.getValue(new ResourceLocation(type));
            if (requirementType == null && (requirementType = IntegrationTypeHelper.searchRequirementType(type)) != null) {
                ModularMachinery.log.info("[Modular Machinery]: Deprecated requirement name '{}'! Consider using {}", (Object)type, (Object)requirementType.getRegistryName().toString());
            }
            if (requirementType == null) {
                throw new JsonParseException("'" + type + "' is not a valid RequirementType!");
            }
            IOType machineIoType = IOType.getByString(ioType);
            if (machineIoType == null) {
                throw new JsonParseException("'" + ioType + "' is not a valid IOType!");
            }
            ComponentRequirement<?, RequirementType<?, ?>> req = requirementType.createRequirement(machineIoType, requirement);
            if (requirement.has("selector-tag")) {
                JsonElement strTag = requirement.get("selector-tag");
                if (!strTag.isJsonPrimitive()) {
                    throw new JsonParseException("The 'selector-tag' in an requirement must be a string!");
                }
                if (!strTag.getAsString().isEmpty()) {
                    req.setTag(new ComponentSelectorTag(strTag.getAsString()));
                }
            }
            return req;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<MachineRecipeContainer> {
        private static void loadCommands(JsonObject root, JsonDeserializationContext context, String arrayTag, Consumer<RecipeRunnableCommand> addFunction) {
            if (root.has(arrayTag)) {
                JsonElement elementStartCommands = root.get(arrayTag);
                if (!elementStartCommands.isJsonArray()) {
                    throw new JsonParseException(arrayTag + " should be an array of commands!");
                }
                for (JsonElement je : elementStartCommands.getAsJsonArray()) {
                    addFunction.accept((RecipeRunnableCommand)context.deserialize(je, RecipeRunnableCommand.class));
                }
            }
        }

        public MachineRecipeContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation parentName;
            JsonObject root = json.getAsJsonObject();
            if (!root.has("machine")) {
                throw new JsonParseException("No 'machine'-entry specified!");
            }
            if (!root.has("registryName") && !root.has("registryname")) {
                throw new JsonParseException("No 'registryName'-entry specified!");
            }
            if (!root.has("recipeTime")) {
                throw new JsonParseException("No 'recipeTime'-entry specified!");
            }
            JsonElement elementMachine = root.get("machine");
            LinkedList qualifiedMachineNames = Lists.newLinkedList();
            if (elementMachine.isJsonArray()) {
                if (elementMachine.getAsJsonArray().size() <= 0) {
                    throw new JsonParseException("'machine' is an array, but it's empty! Provide at least 1 owning-machine name!");
                }
                JsonArray jar = elementMachine.getAsJsonArray();
                for (JsonElement je : jar) {
                    if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isString()) {
                        qualifiedMachineNames.add(new ResourceLocation("modularmachinery", je.getAsJsonPrimitive().getAsString()));
                        continue;
                    }
                    throw new JsonParseException("Found an element in the array specified in 'machine' that is not a string! " + je);
                }
                if (qualifiedMachineNames.isEmpty()) {
                    throw new JsonParseException("'machine' is an array, but it's empty! Provide at least 1 owning-machine name!");
                }
            } else if (elementMachine.isJsonPrimitive() && elementMachine.getAsJsonPrimitive().isString()) {
                qualifiedMachineNames.add(new ResourceLocation("modularmachinery", elementMachine.getAsJsonPrimitive().getAsString()));
            } else {
                throw new JsonParseException("'machine' has to be either an array of strings or just a string! - Found " + elementMachine + " instead!");
            }
            JsonElement elementRegistryName = root.get("registryName");
            if (elementRegistryName == null) {
                elementRegistryName = root.get("registryname");
            }
            if (!elementRegistryName.isJsonPrimitive() || !elementRegistryName.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("'registryName' has to have as value only a String that defines its unique registry name!");
            }
            JsonElement elementTime = root.get("recipeTime");
            if (!elementTime.isJsonPrimitive() || !elementTime.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("'recipeTime' has to be a number!");
            }
            int priority = 0;
            if (root.has("priority")) {
                JsonElement elementPriority = root.get("priority");
                if (!elementPriority.isJsonPrimitive() || !elementPriority.getAsJsonPrimitive().isNumber()) {
                    throw new JsonParseException("'priority' has to be a number! (if specified)");
                }
                priority = elementPriority.getAsInt();
            }
            boolean voidPerTickFailure = false;
            if (root.has("cancelIfPerTickFails")) {
                JsonElement elementDeletePerTick = root.get("cancelIfPerTickFails");
                if (!elementDeletePerTick.isJsonPrimitive() || !elementDeletePerTick.getAsJsonPrimitive().isBoolean()) {
                    throw new JsonParseException("'cancelIfPerTickFails' has to be a boolean! (if specified)");
                }
                voidPerTickFailure = elementDeletePerTick.getAsBoolean();
            }
            if ((parentName = (ResourceLocation)Iterables.getFirst((Iterable)qualifiedMachineNames, null)) == null) {
                throw new IllegalStateException("Couldn't find machine name from qualified-names list: " + Arrays.toString(qualifiedMachineNames.toArray()));
            }
            String registryName = elementRegistryName.getAsJsonPrimitive().getAsString();
            int recipeTime = elementTime.getAsJsonPrimitive().getAsInt();
            MachineRecipe recipe = new MachineRecipe(RecipeLoader.CURRENTLY_READING_PATH.get(), new ResourceLocation("modularmachinery", registryName), parentName, recipeTime, priority, voidPerTickFailure, Config.recipeParallelizeEnabledByDefault);
            MachineRecipeContainer outContainer = new MachineRecipeContainer(recipe);
            outContainer.recipeOwnerList.addAll(qualifiedMachineNames);
            if (!root.has("requirements")) {
                throw new JsonParseException("No 'requirements'-entry specified!");
            }
            JsonElement elementRequirements = root.get("requirements");
            if (!elementRequirements.isJsonArray()) {
                throw new JsonParseException("'requirements' should be an array of recipe requirements!");
            }
            JsonArray requirementsArray = elementRequirements.getAsJsonArray();
            for (int i = 0; i < requirementsArray.size(); ++i) {
                JsonElement elementRequirement = requirementsArray.get(i);
                if (!elementRequirement.isJsonObject()) {
                    throw new JsonParseException("Each element in the 'requirements' array needs to be a fully defined requirement-object!");
                }
                recipe.recipeRequirements.add((ComponentRequirement)context.deserialize(elementRequirement, ComponentRequirement.class));
            }
            if (recipe.recipeRequirements.isEmpty()) {
                throw new JsonParseException("A recipe needs to have at least 1 requirement!");
            }
            Deserializer.loadCommands(root, context, "startCommands", cmd -> recipe.getCommandContainer().addStartCommand((RecipeRunnableCommand)cmd));
            Deserializer.loadCommands(root, context, "processingCommands", cmd -> recipe.getCommandContainer().addProcessingCommand((RecipeRunnableCommand)cmd));
            Deserializer.loadCommands(root, context, "finishCommands", cmd -> recipe.getCommandContainer().addFinishCommand((RecipeRunnableCommand)cmd));
            return outContainer;
        }
    }

    public static class MachineRecipeContainer {
        private final MachineRecipe parent;
        private final List<ResourceLocation> recipeOwnerList = Lists.newLinkedList();

        private MachineRecipeContainer(MachineRecipe copyParent) {
            this.parent = copyParent;
        }

        public List<MachineRecipe> getRecipes() {
            ArrayList out = Lists.newArrayListWithCapacity((int)this.recipeOwnerList.size());
            for (int i = 0; i < this.recipeOwnerList.size(); ++i) {
                ResourceLocation location = this.recipeOwnerList.get(i);
                MachineRecipe rec = new MachineRecipe(this.parent.recipeFilePath + "_sub_" + i, new ResourceLocation(this.parent.registryName.func_110624_b(), this.parent.registryName.func_110623_a() + "_sub_" + i), location, this.parent.tickTime, this.parent.configuredPriority, this.parent.voidPerTickFailure, this.parent.parallelized);
                for (ComponentRequirement<?, ?> req : this.parent.recipeRequirements) {
                    rec.recipeRequirements.add(req.deepCopy().postDeepCopy(req));
                }
                out.add(rec);
            }
            return out;
        }
    }
}

