/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block.prop;

import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.config.Configuration;

public enum ParallelControllerData implements IStringSerializable
{
    NORMAL(4),
    REINFORCED(16),
    ELITE(64),
    SUPER(256),
    ULTIMATE(512);

    private final int defaultMaxParallelism;
    private int maxParallelism;

    private ParallelControllerData(int defaultMaxParallelism) {
        this.defaultMaxParallelism = defaultMaxParallelism;
    }

    public static void loadFromConfig(Configuration cfg) {
        for (ParallelControllerData data : ParallelControllerData.values()) {
            data.maxParallelism = cfg.getInt("max-parallelism", "parallel-controller." + data.func_176610_l(), data.defaultMaxParallelism, 1, Integer.MAX_VALUE, "Defines the max parallelism for the parallel controller.");
        }
    }

    @Nonnull
    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }
}

