/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block;

import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.block.BlockMachineComponent;
import hellfirepvp.modularmachinery.common.block.BlockVariants;
import hellfirepvp.modularmachinery.common.block.prop.WorkingState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStatedMachineComponent
extends BlockMachineComponent
implements BlockVariants {
    public static final List<BlockStatedMachineComponent> WAIT_FOR_REGISTRY = new ArrayList<BlockStatedMachineComponent>();
    public static final PropertyEnum<WorkingState> WORKING_STATE = PropertyEnum.func_177709_a((String)"working_state", WorkingState.class);
    private boolean isColoured = false;

    public BlockStatedMachineComponent() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(CommonProxy.creativeTabModularMachinery);
    }

    public boolean func_149662_c(IBlockState state) {
        return !Objects.equals(this.getRegistryName(), new ResourceLocation("modularmachinery", "crushing_wheels"));
    }

    public boolean isColoured() {
        return this.isColoured;
    }

    public BlockStatedMachineComponent setColoured(boolean coloured) {
        this.isColoured = coloured;
        return this;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_149732_F() {
        String prefix = this.isColoured ? "tile" : "block";
        return I18n.func_135052_a((String)(prefix + ".modularmachinery." + this.getRegistryName().func_110623_a() + ".name"), (Object[])new Object[0]);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(WORKING_STATE, (Comparable)((Object)WorkingState.values()[meta]));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((WorkingState)((Object)state.func_177229_b(WORKING_STATE))).ordinal();
    }

    @Override
    public Iterable<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (WorkingState type : WorkingState.values()) {
            states.add(this.func_176223_P().func_177226_a(WORKING_STATE, (Comparable)((Object)type)));
        }
        return states;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WORKING_STATE});
    }

    @Override
    public String getBlockStateName(IBlockState state) {
        return ((WorkingState)((Object)state.func_177229_b(WORKING_STATE))).func_176610_l();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return this.isColoured;
    }

    @Override
    public boolean func_149716_u() {
        return this.isColoured;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.isColoured ? super.createTileEntity(world, state) : null;
    }

    @Override
    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.isColoured ? super.func_149915_a(worldIn, meta) : null;
    }
}

