/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block;

import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFactoryController
extends BlockController {
    public static final Map<DynamicMachine, BlockFactoryController> FACTORY_CONTROLLERS = new HashMap<DynamicMachine, BlockFactoryController>();

    public BlockFactoryController() {
    }

    public BlockFactoryController(DynamicMachine parentMachine) {
        this();
        this.parentMachine = parentMachine;
        this.setRegistryName(new ResourceLocation("modularmachinery", parentMachine.getRegistryName().func_110623_a() + "_factory_controller"));
    }

    public static BlockFactoryController getControllerWithMachine(DynamicMachine machine) {
        return FACTORY_CONTROLLERS.get(machine);
    }

    @Override
    public boolean func_180639_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileFactoryController) {
            playerIn.openGui((Object)"modularmachinery", CommonProxy.GuiType.FACTORY.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_149732_F() {
        if (this.parentMachine != null) {
            return I18n.func_135052_a((String)"tile.modularmachinery.machinefactorycontroller.name", (Object[])new Object[]{this.parentMachine.getLocalizedName()});
        }
        return I18n.func_135052_a((String)"tile.modularmachinery.blockfactorycontroller.name", (Object[])new Object[0]);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFactoryController(state);
    }

    @Override
    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFactoryController(this.func_176203_a(meta));
    }
}

