/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.util;

import github.kasuminova.mmce.common.util.DynamicPattern;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.client.util.BlockArrayRenderHelper;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicMachineRenderContext {
    private final DynamicMachine machine;
    private final BlockArrayRenderHelper render;
    private final BlockArray pattern;
    private final BlockPos moveOffset;
    private int dynamicPatternSize;
    private boolean render3D = true;
    private int renderSlice = 0;
    private float scale = 1.0f;
    private long shiftSnap = -1L;

    private DynamicMachineRenderContext(DynamicMachine machine) {
        this(machine, machine.getPattern(), 0);
    }

    private DynamicMachineRenderContext(DynamicMachine machine, BlockArray pattern, int dynamicPatternSize) {
        this.machine = machine;
        this.dynamicPatternSize = dynamicPatternSize;
        BlockArray copy = this.buildDynamicPattern(machine, new BlockArray(pattern));
        BlockPos min = copy.getMin();
        BlockPos max = copy.getMax();
        this.moveOffset = new BlockPos((min.func_177958_n() + (max.func_177958_n() - min.func_177958_n()) / 2) * -1, -min.func_177956_o(), (min.func_177952_p() + (max.func_177952_p() - min.func_177952_p()) / 2) * -1);
        copy = new BlockArray(copy, this.moveOffset);
        DynamicMachineRenderContext.addControllerToBlockArray(machine, copy, (Vec3i)this.moveOffset);
        DynamicMachineRenderContext.addReplacementToBlockArray(machine.getModifiersAsMatchingReplacements(), copy, (Vec3i)this.moveOffset);
        this.pattern = copy;
        this.render = new BlockArrayRenderHelper(copy);
    }

    private static void addControllerToBlockArray(DynamicMachine machine, BlockArray copy, Vec3i moveOffset) {
        if (machine.isHasFactory() && machine.isFactoryOnly()) {
            BlockFactoryController factory = BlockFactoryController.getControllerWithMachine(machine);
            if (factory == null) {
                factory = BlocksMM.blockFactoryController;
            }
            copy.addBlock(new BlockPos(moveOffset), new BlockArray.BlockInformation(Collections.singletonList(new IBlockStateDescriptor(factory.func_176223_P()))));
            return;
        }
        ArrayList<IBlockStateDescriptor> descriptors = new ArrayList<IBlockStateDescriptor>();
        BlockController ctrl = BlockController.getControllerWithMachine(machine);
        if (ctrl == null) {
            ctrl = BlocksMM.blockController;
        }
        descriptors.add(new IBlockStateDescriptor(ctrl.func_176223_P()));
        if (machine.isHasFactory() || Config.enableFactoryControllerByDefault) {
            BlockFactoryController factory = BlockFactoryController.getControllerWithMachine(machine);
            if (factory == null) {
                factory = BlocksMM.blockFactoryController;
            }
            descriptors.add(new IBlockStateDescriptor(factory.func_176223_P()));
        }
        copy.addBlock(new BlockPos(moveOffset), new BlockArray.BlockInformation(descriptors));
    }

    public static void addReplacementToBlockArray(DynamicMachine.ModifierReplacementMap replacementMap, BlockArray blockArray, Vec3i moveOffset) {
        for (Map.Entry entry : replacementMap.entrySet()) {
            BlockPos pos = ((BlockPos)entry.getKey()).func_177971_a(moveOffset);
            List informationList = (List)entry.getValue();
            for (BlockArray.BlockInformation info : informationList) {
                Map<BlockPos, BlockArray.BlockInformation> pattern = blockArray.getPattern();
                if (pattern.containsKey(pos)) {
                    BlockArray.BlockInformation newInfo = pattern.get(pos).copy();
                    newInfo.addMatchingStates(info.getMatchingStates());
                    blockArray.addBlock(pos, newInfo);
                    continue;
                }
                blockArray.addBlock(pos, info);
            }
        }
    }

    public static DynamicMachineRenderContext createContext(DynamicMachine machine) {
        return new DynamicMachineRenderContext(machine);
    }

    public static DynamicMachineRenderContext createContext(DynamicMachine machine, int dynamicPatternSize) {
        return new DynamicMachineRenderContext(machine, machine.getPattern(), dynamicPatternSize);
    }

    private BlockArray buildDynamicPattern(DynamicMachine machine, BlockArray copy) {
        Map<String, DynamicPattern> dynamicPatterns = machine.getDynamicPatterns();
        if (!dynamicPatterns.isEmpty()) {
            for (DynamicPattern pattern : dynamicPatterns.values()) {
                this.dynamicPatternSize = Math.max(this.dynamicPatternSize, pattern.getMinSize());
            }
            for (DynamicPattern pattern : dynamicPatterns.values()) {
                pattern.addPatternToBlockArray(copy, Math.min(Math.max(pattern.getMinSize(), this.dynamicPatternSize), pattern.getMaxSize()), pattern.getFaces().iterator().next(), EnumFacing.NORTH);
            }
        }
        return copy;
    }

    BlockArrayRenderHelper getRender() {
        return this.render;
    }

    public BlockArray getPattern() {
        return this.pattern;
    }

    public int getDynamicPatternSize() {
        return this.dynamicPatternSize;
    }

    public Vec3i getMoveOffset() {
        return this.moveOffset;
    }

    public long getShiftSnap() {
        return this.shiftSnap;
    }

    public void setShiftSnap(long shiftSnap) {
        this.shiftSnap = shiftSnap;
    }

    public void snapSamples() {
        this.shiftSnap = ClientScheduler.getClientTick();
    }

    public void releaseSamples() {
        this.shiftSnap = -1L;
    }

    public void resetRender() {
        this.setTo2D();
        this.setTo3D();
    }

    public void setTo2D() {
        if (!this.render3D) {
            return;
        }
        this.render3D = false;
        this.renderSlice = this.render.getBlocks().getMin().func_177956_o();
        this.render.resetRotation2D();
        this.scale = 1.0f;
    }

    public void setTo3D() {
        if (this.render3D) {
            return;
        }
        this.render3D = true;
        this.renderSlice = 0;
        this.render.resetRotation();
        this.scale = 1.0f;
    }

    public float getScale() {
        return this.scale;
    }

    public Vec3d getCurrentMachineTranslate() {
        if (this.render3D) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        return this.render.getCurrentTranslation();
    }

    public Vec2f getCurrentRenderOffset(float x, float z) {
        Minecraft mc = Minecraft.func_71410_x();
        double sc = new ScaledResolution(mc).func_78325_e();
        double oX = (double)x + 16.0 / sc;
        double oZ = (double)z + 16.0 / sc;
        Vec3d tr = this.getCurrentMachineTranslate();
        return new Vec2f((float)(oX + tr.field_72450_a), (float)(oZ + tr.field_72449_c));
    }

    public void zoomOut() {
        this.scale *= 0.85f;
    }

    public void zoomIn() {
        this.scale *= 1.15f;
    }

    public boolean doesRenderIn3D() {
        return this.render3D;
    }

    public int getRenderSlice() {
        return this.renderSlice - this.moveOffset.func_177956_o();
    }

    public boolean hasSliceDown() {
        return this.render.getBlocks().getMin().func_177956_o() < this.renderSlice;
    }

    public boolean hasSliceUp() {
        return this.render.getBlocks().getMax().func_177956_o() > this.renderSlice;
    }

    public void sliceUp() {
        if (this.hasSliceUp()) {
            ++this.renderSlice;
        }
    }

    public void sliceDown() {
        if (this.hasSliceDown()) {
            --this.renderSlice;
        }
    }

    public DynamicMachine getDisplayedMachine() {
        return this.machine;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getDescriptiveStacks() {
        return this.pattern.getAsDescriptiveStacks(this.shiftSnap);
    }

    public void renderAt(int x, int z) {
        this.renderAt(x, z, 1.0f);
    }

    public void renderAt(int x, int z, float partialTicks) {
        this.render.sampleSnap = this.shiftSnap;
        if (this.render3D) {
            this.render.render3DGUI(x, z, this.scale, partialTicks);
        } else {
            this.render.render3DGUI(x, z, this.scale, partialTicks, Optional.of(this.renderSlice));
        }
    }

    public void rotateRender(double x, double y, double z) {
        this.render.rotate(x, y, z);
    }

    public void moveRender(double x, double y, double z) {
        this.render.translate(x, y, z);
    }
}

