/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.util;

import github.kasuminova.mmce.common.util.BlockPos2ValueMap;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.BlockCompatHelper;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class BlockArrayRenderHelper {
    private final BlockArray blocks;
    private final WorldBlockArrayRenderAccess renderAccess;
    long sampleSnap = -1L;
    private double rotX;
    private double rotY;
    private double rotZ;
    private double sliceTrX;
    private double sliceTrY;
    private double sliceTrZ;

    BlockArrayRenderHelper(BlockArray blocks) {
        this.blocks = blocks;
        this.renderAccess = new WorldBlockArrayRenderAccess(this, blocks);
        this.resetRotation();
    }

    WorldBlockArrayRenderAccess getRenderAccess() {
        return this.renderAccess;
    }

    void resetRotation() {
        this.rotX = -30.0;
        this.rotY = 45.0;
        this.rotZ = 0.0;
        this.sliceTrX = 0.0;
        this.sliceTrY = 0.0;
        this.sliceTrZ = 0.0;
    }

    void resetRotation2D() {
        this.rotX = -90.0;
        this.rotY = 0.0;
        this.rotZ = 0.0;
        this.sliceTrX = 0.0;
        this.sliceTrY = 0.0;
        this.sliceTrZ = 0.0;
    }

    BlockArray getBlocks() {
        return this.blocks;
    }

    public void translate(double x, double y, double z) {
        this.sliceTrX += x;
        this.sliceTrY += y;
        this.sliceTrZ += z;
    }

    public void rotate(double x, double y, double z) {
        this.rotX += x;
        this.rotY += y;
        this.rotZ += z;
    }

    public Vec3d getCurrentTranslation() {
        return new Vec3d(this.sliceTrX, this.sliceTrY, this.sliceTrZ);
    }

    public void render3DGUI(double x, double y, float scaleMultiplier, float pTicks) {
        this.render3DGUI(x, y, scaleMultiplier, pTicks, Optional.empty());
    }

    public void render3DGUI(double x, double y, float scaleMultiplier, float pTicks, Optional<Integer> slice) {
        BlockPos offset;
        GuiScreen scr = Minecraft.func_71410_x().field_71462_r;
        if (scr == null) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        BlockPos max = this.blocks.getMax();
        BlockPos min = this.blocks.getMin();
        Vec3i move = new Vec3i(max.func_177958_n() - min.func_177958_n(), max.func_177956_o() - min.func_177956_o(), max.func_177952_p() - min.func_177952_p());
        Minecraft mc = Minecraft.func_71410_x();
        double sc = new ScaledResolution(mc).func_78325_e();
        GL11.glTranslated((double)(x + 16.0 / sc), (double)(y + 16.0 / sc), (double)512.0);
        double mul = scaleMultiplier * 7.0f;
        double size = 2.0;
        double minSize = 0.5;
        if (!slice.isPresent()) {
            double maxLength = 0.0;
            double pointDst = max.func_177958_n() - min.func_177958_n();
            if (pointDst > maxLength) {
                maxLength = pointDst;
            }
            if ((pointDst = (double)(max.func_177956_o() - min.func_177956_o())) > maxLength) {
                maxLength = pointDst;
            }
            if ((pointDst = (double)(max.func_177952_p() - min.func_177952_p())) > maxLength) {
                maxLength = pointDst;
            }
            if ((maxLength -= 5.0) > 0.0) {
                size = (size - minSize) * (1.0 - maxLength / 75.0);
            }
        }
        double dr = -5.75 * size;
        GL11.glTranslated((double)dr, (double)dr, (double)dr);
        GL11.glRotated((double)this.rotX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)this.rotY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)this.rotZ, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-dr), (double)(-dr), (double)(-dr));
        GL11.glTranslated((double)this.sliceTrX, (double)this.sliceTrY, (double)this.sliceTrZ);
        GL11.glScaled((double)(-size * mul), (double)(-size * mul), (double)(-size * mul));
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        VertexFormat blockFormat = DefaultVertexFormats.field_176600_a;
        this.renderAccess.respectRenderSlice = slice.isPresent();
        this.renderAccess.currentRenderSlice = slice.orElse(0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, blockFormat);
        for (Map.Entry<BlockPos, BakedBlockData> data : this.renderAccess.blockRenderData.entrySet()) {
            offset = data.getKey();
            if (slice.isPresent() && slice.get().intValue() != offset.func_177956_o()) continue;
            BakedBlockData renderData = data.getValue();
            SampleRenderState state = renderData.getSampleState();
            if (state.state.func_177230_c() == Blocks.field_150350_a) continue;
            TileEntityRenderData terd = state.renderData;
            if (terd != null && terd.tileEntity != null) {
                terd.tileEntity.func_145834_a((World)Minecraft.func_71410_x().field_71441_e);
                terd.tileEntity.func_174878_a(offset);
            }
            try {
                IBlockState actRenderState = state.state;
                actRenderState = actRenderState.func_177230_c().func_176221_a(actRenderState, (IBlockAccess)this.renderAccess, offset);
                brd.func_175018_a(actRenderState, offset, (IBlockAccess)this.renderAccess, vb);
            }
            catch (Exception exc) {
                brd.func_175019_b().func_178267_a((IBlockAccess)this.renderAccess, brd.func_175023_a().func_178126_b().func_174951_a(), state.state, offset, vb, true);
            }
        }
        tes.func_78381_a();
        for (Map.Entry<BlockPos, BakedBlockData> data : this.renderAccess.blockRenderData.entrySet()) {
            offset = data.getKey();
            if (slice.isPresent() && slice.get().intValue() != offset.func_177956_o()) continue;
            SampleRenderState state = data.getValue().getSampleState();
            TileEntityRenderData terd = state.renderData;
            if (terd == null || terd.tileEntity == null || terd.renderer == null) continue;
            terd.tileEntity.func_145834_a((World)Minecraft.func_71410_x().field_71441_e);
            terd.tileEntity.func_174878_a(offset);
            try {
                terd.renderer.func_192841_a(terd.tileEntity, (double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), pTicks, 0, 1.0f);
            }
            catch (Exception exception) {}
        }
        this.renderAccess.respectRenderSlice = false;
        this.renderAccess.currentRenderSlice = 0;
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static class WorldBlockArrayRenderAccess
    implements IBlockAccess {
        final Map<BlockPos, BakedBlockData> blockRenderData = new BlockPos2ValueMap<BakedBlockData>();
        private final BlockArray originalArray;
        private int currentRenderSlice = 0;
        private boolean respectRenderSlice = false;

        private WorldBlockArrayRenderAccess(BlockArrayRenderHelper ref, BlockArray array) {
            this.originalArray = array;
            for (Map.Entry<BlockPos, BlockArray.BlockInformation> entry : array.getPattern().entrySet()) {
                BlockPos offset = entry.getKey();
                BlockArray.BlockInformation info = entry.getValue();
                BlockArray.TileInstantiateContext context = new BlockArray.TileInstantiateContext((World)Minecraft.func_71410_x().field_71441_e, offset);
                this.blockRenderData.put(offset, new BakedBlockData(ref, info.getMatchingStates(), info.getPreviewTag(), context));
            }
        }

        static WorldBlockArrayRenderAccess build(BlockArrayRenderHelper ref, BlockArray array, BlockPos toOffset) {
            return new WorldBlockArrayRenderAccess(ref, new BlockArray(array, toOffset));
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            if (!this.isInBounds(pos)) {
                return null;
            }
            SampleRenderState sample = this.getSample(pos);
            if (sample == null || sample.renderData == null) {
                return null;
            }
            return sample.renderData.tileEntity;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0;
        }

        @Nonnull
        public IBlockState func_180495_p(BlockPos pos) {
            if (!this.isInBounds(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            SampleRenderState sample = this.getSample(pos);
            if (sample == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return sample.state;
        }

        public boolean func_175623_d(BlockPos pos) {
            if (!this.isInBounds(pos)) {
                return true;
            }
            SampleRenderState sample = this.getSample(pos);
            return sample == null || sample.state == null || sample.state.func_177230_c() == Blocks.field_150350_a;
        }

        @Nullable
        private SampleRenderState getSample(BlockPos pos) {
            return this.blockRenderData.get(pos).getSampleState();
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_76772_c;
        }

        private boolean isInBounds(BlockPos pos) {
            if (this.respectRenderSlice && pos.func_177956_o() != this.currentRenderSlice) {
                return false;
            }
            return this.blockRenderData.containsKey(pos);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public WorldType func_175624_G() {
            return Minecraft.func_71410_x().field_71441_e.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.isInBounds(pos) ? this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side) : _default;
        }
    }

    static class BakedBlockData {
        private final BlockArrayRenderHelper ref;
        private final List<SampleRenderState> renderStates = new ArrayList<SampleRenderState>();

        private BakedBlockData(BlockArrayRenderHelper ref, List<IBlockStateDescriptor> states, @Nullable NBTTagCompound matchTag, BlockArray.TileInstantiateContext context) {
            this.ref = ref;
            for (IBlockStateDescriptor desc : states) {
                for (IBlockState state : desc.getApplicable()) {
                    this.renderStates.add(new SampleRenderState(state, matchTag, context));
                }
            }
        }

        SampleRenderState getSampleState() {
            int tickSpeed = 30;
            if (this.renderStates.size() > 10) {
                tickSpeed = (int)((double)tickSpeed * 0.6);
            }
            int p = (int)((this.ref.sampleSnap == -1L ? ClientScheduler.getClientTick() : this.ref.sampleSnap) / (long)tickSpeed);
            int part = p % this.renderStates.size();
            return this.renderStates.get(part);
        }
    }

    static class SampleRenderState {
        final IBlockState state;
        final TileEntityRenderData renderData;

        private SampleRenderState(IBlockState state, @Nullable NBTTagCompound matchTag, BlockArray.TileInstantiateContext context) {
            Tuple<IBlockState, TileEntity> tt = BlockCompatHelper.transformState(state, matchTag, context);
            this.state = (IBlockState)tt.func_76341_a();
            TileEntity te = (TileEntity)tt.func_76340_b();
            this.renderData = new TileEntityRenderData(te);
        }
    }

    static class TileEntityRenderData {
        final TileEntity tileEntity;
        final TileEntitySpecialRenderer<TileEntity> renderer;

        private TileEntityRenderData(TileEntity tileEntity) {
            this.tileEntity = tileEntity;
            this.renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity);
        }
    }
}

