/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.gui;

import github.kasuminova.mmce.common.event.client.ControllerGUIRenderEvent;
import hellfirepvp.modularmachinery.client.gui.GuiContainerBase;
import hellfirepvp.modularmachinery.client.gui.widget.GuiScrollbar;
import hellfirepvp.modularmachinery.common.container.ContainerFactoryController;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiFactoryController
extends GuiContainerBase<ContainerFactoryController> {
    public static final double FONT_SCALE = 0.72;
    private static final ResourceLocation TEXTURES_FACTORY = new ResourceLocation("modularmachinery", "textures/gui/guifactory.png");
    private static final ResourceLocation TEXTURES_FACTORY_ELEMENTS = new ResourceLocation("modularmachinery", "textures/gui/guifactoryelements.png");
    private static final int SCROLLBAR_TOP = 8;
    private static final int SCROLLBAR_LEFT = 94;
    private static final int SCROLLBAR_HEIGHT = 197;
    private static final int MAX_PAGE_ELEMENTS = 6;
    private static final int FACTORY_ELEMENT_WIDTH = 86;
    private static final int FACTORY_ELEMENT_HEIGHT = 32;
    private static final int TEXT_DRAW_OFFSET_X = 113;
    private static final int TEXT_DRAW_OFFSET_Y = 12;
    private static final int RECIPE_QUEUE_OFFSET_X = 8;
    private static final int RECIPE_QUEUE_OFFSET_Y = 8;
    private final GuiScrollbar scrollbar = new GuiScrollbar();
    private final TileFactoryController factory;

    public GuiFactoryController(TileFactoryController factory, EntityPlayer player) {
        super(new ContainerFactoryController(factory, player));
        this.factory = factory;
        this.field_146999_f = 280;
        this.field_147000_g = 213;
    }

    private static int drawBlueprintInfo(int offsetX, int y, FontRenderer fr, DynamicMachine machine, boolean formed) {
        int offsetY = y;
        if (machine != null) {
            String drawnHead = I18n.func_135052_a((String)"gui.controller.blueprint", (Object[])new Object[]{""});
            List out = fr.func_78271_c(machine.getLocalizedName(), MathHelper.func_76128_c((double)187.5));
            fr.func_175063_a(drawnHead, (float)offsetX, (float)offsetY, 0xFFFFFF);
            for (String draw : out) {
                fr.func_175063_a(draw, (float)offsetX, (float)(offsetY += 10), 0xFFFFFF);
            }
            offsetY += 15;
        } else if (!formed) {
            String drawnHead = I18n.func_135052_a((String)"gui.controller.blueprint", (Object[])new Object[]{I18n.func_135052_a((String)"gui.controller.blueprint.none", (Object[])new Object[0])});
            fr.func_175063_a(drawnHead, (float)offsetX, (float)offsetY, 0xFFFFFF);
            offsetY += 15;
        }
        return offsetY;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawRecipeQueue();
        this.drawFactoryStatus();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_FACTORY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
        this.updateScrollbar(x, y);
        this.scrollbar.draw((GuiScreen)this, this.field_146297_k);
    }

    private void drawRecipeQueue() {
        int offsetY = 8;
        int currentScroll = this.scrollbar.getCurrentScroll();
        Collection<FactoryRecipeThread> coreThreadList = this.factory.getCoreRecipeThreads().values();
        List<FactoryRecipeThread> threads = this.factory.getFactoryRecipeThreadList();
        ArrayList<FactoryRecipeThread> recipeThreadList = new ArrayList<FactoryRecipeThread>((int)((double)(coreThreadList.size() + threads.size()) * 1.5));
        recipeThreadList.addAll(coreThreadList);
        recipeThreadList.addAll(threads);
        for (int i = 0; i < Math.min(6, recipeThreadList.size()); ++i) {
            FactoryRecipeThread thread = (FactoryRecipeThread)recipeThreadList.get(i + currentScroll);
            this.drawRecipeInfo(thread, i + currentScroll, offsetY);
            offsetY += 33;
        }
    }

    private void drawRecipeInfo(FactoryRecipeThread thread, int id, int offsetY) {
        CraftingStatus status = thread.getStatus();
        ActiveMachineRecipe activeRecipe = thread.getActiveRecipe();
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_FACTORY_ELEMENTS);
        if (thread.isCoreThread()) {
            GlStateManager.func_179131_c((float)0.7f, (float)0.9f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.func_73729_b(8, offsetY, 0, 0, 86, 32);
        if (status.isCrafting()) {
            GlStateManager.func_179131_c((float)0.6f, (float)1.0f, (float)0.75f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)0.6f, (float)0.6f, (float)1.0f);
        }
        if (activeRecipe != null) {
            float progress = (float)activeRecipe.getTick() / (float)activeRecipe.getTotalTick();
            this.func_73729_b(8, offsetY, 0, 0, (int)(86.0f * progress), 32);
        }
        this.drawRecipeStatus(thread, id, offsetY + 2);
    }

    private void drawRecipeStatus(FactoryRecipeThread thread, int id, int y) {
        String name;
        int parallelism;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.72, (double)0.72, (double)0.72);
        FontRenderer fr = this.field_146289_q;
        int offsetX = 13;
        int offsetY = (int)((double)y / 0.72);
        ActiveMachineRecipe activeRecipe = thread.getActiveRecipe();
        CraftingStatus status = thread.getStatus();
        int n = parallelism = activeRecipe == null ? 1 : activeRecipe.getParallelism();
        String threadName = thread.isCoreThread() ? (I18n.func_188566_a((String)(name = thread.getThreadName())) ? I18n.func_135052_a((String)name, (Object[])new Object[0]) : name) : I18n.func_135052_a((String)"gui.factory.thread", (Object[])new Object[]{id});
        if (parallelism > 1) {
            fr.func_78276_b(threadName + " (" + I18n.func_135052_a((String)"gui.controller.parallelism", (Object[])new Object[]{parallelism}) + ')', offsetX, offsetY, 0x222222);
        } else {
            fr.func_78276_b(threadName, offsetX, offsetY, 0x222222);
        }
        offsetY += 12;
        List out = fr.func_78271_c(I18n.func_135052_a((String)status.getUnlocMessage(), (Object[])new Object[0]), 111);
        for (String draw : out) {
            fr.func_78276_b(draw, offsetX, offsetY, 0x222222);
            offsetY += 10;
        }
        if (activeRecipe != null && activeRecipe.getTotalTick() > 0) {
            int progress = activeRecipe.getTick() * 100 / activeRecipe.getTotalTick();
            fr.func_78276_b(I18n.func_135052_a((String)"gui.controller.status.crafting.progress", (Object[])new Object[]{progress + "%"}), offsetX, offsetY, 0x222222);
        }
        GlStateManager.func_179121_F();
    }

    private void drawFactoryStatus() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.72, (double)0.72, (double)0.72);
        int offsetX = 156;
        int offsetY = 12;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FontRenderer fr = this.field_146289_q;
        int redstone = this.factory.func_145831_w().func_175676_y(this.factory.func_174877_v());
        if (redstone > 0) {
            String drawnStop = I18n.func_135052_a((String)"gui.controller.status.redstone_stopped", (Object[])new Object[0]);
            List out = fr.func_78271_c(drawnStop, MathHelper.func_76128_c((double)187.5));
            for (String draw : out) {
                fr.func_175063_a(draw, (float)offsetX, (float)offsetY, 0xFFFFFF);
                offsetY += 10;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            return;
        }
        DynamicMachine machine = this.factory.getBlueprintMachine();
        offsetY = GuiFactoryController.drawBlueprintInfo(offsetX, offsetY, fr, machine, this.factory.isStructureFormed());
        DynamicMachine found = this.factory.getFoundMachine();
        offsetY = this.drawStructureInfo(offsetX, offsetY, fr, found);
        if (!this.factory.isStructureFormed()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            return;
        }
        offsetY += 15;
        int tmp = offsetY = this.drawFactoryRecipeSearchStatusInfo(offsetX, offsetY, fr);
        offsetY = this.drawFactoryThreadsInfo(offsetX, offsetY, fr);
        if (tmp != (offsetY = this.drawParallelismInfo(offsetX, offsetY, fr))) {
            offsetY += 5;
        }
        int usedTimeCache = TileMultiblockMachineController.usedTimeCache;
        float searchUsedTimeCache = TileMultiblockMachineController.searchUsedTimeCache;
        String workMode = TileMultiblockMachineController.workModeCache.getDisplayName();
        fr.func_175063_a(String.format("Avg: %s\u03bcs/t (Search: %sms), WorkMode: %s", usedTimeCache, MiscUtils.formatFloat(searchUsedTimeCache / 1000.0f, 2), workMode), (float)offsetX, (float)offsetY, 0xFFFFFF);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private int drawFactoryRecipeSearchStatusInfo(int offsetX, int y, FontRenderer fr) {
        if (!this.factory.hasIdleThread()) {
            return y;
        }
        int offsetY = y;
        String status = I18n.func_135052_a((String)"gui.controller.status", (Object[])new Object[0]);
        fr.func_175063_a(status, (float)offsetX, (float)offsetY, 0xFFFFFF);
        String statusKey = this.factory.getControllerStatus().getUnlocMessage();
        List out = fr.func_78271_c(I18n.func_135052_a((String)statusKey, (Object[])new Object[0]), MathHelper.func_76128_c((double)187.5));
        for (String draw : out) {
            fr.func_175063_a(draw, (float)offsetX, (float)(offsetY += 10), 0xFFFFFF);
        }
        return offsetY + 15;
    }

    private int drawFactoryThreadsInfo(int offsetX, int offsetY, FontRenderer fr) {
        if (this.factory.getMaxThreads() <= 0) {
            return offsetY;
        }
        fr.func_175063_a(I18n.func_135052_a((String)"gui.factory.threads", (Object[])new Object[]{this.factory.getFactoryRecipeThreadList().size(), this.factory.getMaxThreads()}), (float)offsetX, (float)offsetY, 0xFFFFFF);
        return offsetY + 10;
    }

    private int drawParallelismInfo(int offsetX, int y, FontRenderer fr) {
        ActiveMachineRecipe activeRecipe;
        int offsetY = y;
        int parallelism = 1;
        int maxParallelism = this.factory.getTotalParallelism();
        if (maxParallelism <= 1) {
            return offsetY;
        }
        for (FactoryRecipeThread thread : this.factory.getFactoryRecipeThreadList()) {
            activeRecipe = thread.getActiveRecipe();
            if (activeRecipe == null) continue;
            parallelism += activeRecipe.getParallelism() - 1;
        }
        for (FactoryRecipeThread thread : this.factory.getCoreRecipeThreads().values()) {
            activeRecipe = thread.getActiveRecipe();
            if (activeRecipe == null) continue;
            parallelism += activeRecipe.getParallelism() - 1;
        }
        if (parallelism <= 1) {
            return offsetY;
        }
        String parallelismStr = I18n.func_135052_a((String)"gui.controller.parallelism", (Object[])new Object[]{parallelism});
        fr.func_175063_a(parallelismStr, (float)offsetX, (float)offsetY, 0xFFFFFF);
        String maxParallelismStr = I18n.func_135052_a((String)"gui.controller.max_parallelism", (Object[])new Object[]{maxParallelism});
        fr.func_175063_a(maxParallelismStr, (float)offsetX, (float)(offsetY += 10), 0xFFFFFF);
        return offsetY += 10;
    }

    private int drawStructureInfo(int offsetX, int y, FontRenderer fr, DynamicMachine found) {
        int offsetY = y;
        if (found != null) {
            String drawnHead = I18n.func_135052_a((String)"gui.controller.structure", (Object[])new Object[]{""});
            List out = fr.func_78271_c(found.getLocalizedName(), MathHelper.func_76128_c((double)187.5));
            fr.func_175063_a(drawnHead, (float)offsetX, (float)offsetY, 0xFFFFFF);
            for (String draw : out) {
                fr.func_175063_a(draw, (float)offsetX, (float)(offsetY += 10), 0xFFFFFF);
            }
            offsetY = this.drawExtraInfo(offsetX, offsetY, fr);
        } else {
            String drawnHead = I18n.func_135052_a((String)"gui.controller.structure", (Object[])new Object[]{I18n.func_135052_a((String)"gui.controller.structure.none", (Object[])new Object[0])});
            fr.func_175063_a(drawnHead, (float)offsetX, (float)offsetY, 0xFFFFFF);
            offsetY += 15;
        }
        return offsetY;
    }

    private int drawExtraInfo(int offsetX, int y, FontRenderer fr) {
        int offsetY = y;
        ControllerGUIRenderEvent event = new ControllerGUIRenderEvent(this.factory);
        event.postEvent();
        String[] extraInfo = event.getExtraInfo();
        if (extraInfo.length != 0) {
            ArrayList waitForDraw = new ArrayList();
            for (String s : extraInfo) {
                waitForDraw.addAll(fr.func_78271_c(s, MathHelper.func_76128_c((double)187.5)));
            }
            offsetY += 5;
            for (String s : waitForDraw) {
                fr.func_175063_a(s, (float)offsetX, (float)(offsetY += 10), 0xFFFFFF);
            }
        }
        return offsetY;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.scrollbar.wheel(i);
        }
    }

    private void updateScrollbar(int displayX, int displayY) {
        this.scrollbar.setLeft(94 + displayX).setTop(8 + displayY).setHeight(197);
        Map<String, FactoryRecipeThread> coreThreads = this.factory.getCoreRecipeThreads();
        List<FactoryRecipeThread> threadList = this.factory.getFactoryRecipeThreadList();
        this.scrollbar.setRange(0, Math.max(0, coreThreads.size() + threadList.size() - 6), 1);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.scrollbar.click(mouseX, mouseY);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.scrollbar.click(mouseX, mouseY);
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    protected void setWidthHeight() {
    }
}

