/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.gui;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.gui.GuiContainerBase;
import hellfirepvp.modularmachinery.client.util.EnergyDisplayUtil;
import hellfirepvp.modularmachinery.common.container.ContainerEnergyHatch;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiContainerEnergyHatch
extends GuiContainerBase<ContainerEnergyHatch> {
    public static final ResourceLocation TEXTURES_ENERGY_HATCH = new ResourceLocation("modularmachinery", "textures/gui/guibar.png");
    private final TileEnergyHatch energyHatch;

    public GuiContainerEnergyHatch(TileEnergyHatch tileFluidTank, EntityPlayer opening) {
        super(new ContainerEnergyHatch(tileFluidTank, opening));
        this.energyHatch = tileFluidTank;
    }

    @Override
    protected void setWidthHeight() {
    }

    protected void func_191948_b(int x, int z) {
        super.func_191948_b(x, z);
        int offsetX = (this.field_146294_l - this.field_146999_f) / 2;
        int offsetZ = (this.field_146295_m - this.field_147000_g) / 2;
        if (x >= 15 + offsetX && x <= 35 + offsetX && z >= 10 + offsetZ && z <= 71 + offsetZ) {
            long currentEnergy = EnergyDisplayUtil.type.formatEnergyForDisplay(this.energyHatch.getCurrentEnergy());
            long maxEnergy = EnergyDisplayUtil.type.formatEnergyForDisplay(this.energyHatch.getMaxEnergy());
            ArrayList text = Lists.newArrayList();
            text.add(I18n.func_135052_a((String)"tooltip.energyhatch.charge", (Object[])new Object[]{MiscUtils.formatNumber(currentEnergy), MiscUtils.formatNumber(maxEnergy), I18n.func_135052_a((String)EnergyDisplayUtil.type.getUnlocalizedFormat(), (Object[])new Object[0])}));
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            this.drawHoveringText(text, x, z, font == null ? this.field_146289_q : font);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        float percFilled = (float)this.energyHatch.getCurrentEnergy() / (float)this.energyHatch.getMaxEnergy();
        int pxFilled = MathHelper.func_76123_f((float)(percFilled * 61.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_ENERGY_HATCH);
        this.func_73729_b(15, 71 - pxFilled, 196, 61 - pxFilled, 20, pxFilled);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_ENERGY_HATCH);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

