/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.world;

import github.kasuminova.mmce.common.tile.MEPatternMirrorImage;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import github.kasuminova.mmce.common.util.concurrent.ExecuteGroup;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class MachineComponentManager {
    public static final MachineComponentManager INSTANCE = new MachineComponentManager();
    private final Map<World, Map<BlockPos, ComponentInfo>> componentMap = new ConcurrentHashMap<World, Map<BlockPos, ComponentInfo>>();

    private MachineComponentManager() {
    }

    @Optional.Method(modid="appliedenergistics2")
    private static Object[] getResult(TileEntity component, World world) {
        BlockPos pos = component.func_174877_v();
        TileEntity te = component;
        if (component instanceof MEPatternMirrorImage) {
            TileEntity tileEntity;
            MEPatternMirrorImage mepi = (MEPatternMirrorImage)component;
            if (mepi.providerPos != null && (tileEntity = world.func_175625_s(mepi.providerPos)) instanceof MEPatternProvider) {
                MEPatternProvider mep = (MEPatternProvider)tileEntity;
                te = mep;
                pos = mep.func_174877_v();
            }
        }
        return new Object[]{pos, te};
    }

    public void addWorld(World world) {
        this.componentMap.put(world, new ConcurrentHashMap());
    }

    public void removeWorld(World world) {
        Map<BlockPos, ComponentInfo> removed = this.componentMap.remove(world);
        if (removed == null) {
            return;
        }
        for (ComponentInfo info : removed.values()) {
            info.owners.clear();
        }
        removed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkComponentShared(TileEntity component, TileMultiblockMachineController ctrl) {
        TileEntity te;
        BlockPos pos;
        World world = component.func_145831_w();
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            Object[] result = MachineComponentManager.getResult(component, world);
            pos = (BlockPos)result[0];
            te = (TileEntity)result[1];
        } else {
            te = component;
            pos = component.func_174877_v();
        }
        Map posComponentMap = this.componentMap.computeIfAbsent(world, v -> new ConcurrentHashMap());
        TileEntity tileEntity = te;
        synchronized (tileEntity) {
            ComponentInfo info = posComponentMap.computeIfAbsent(pos, v -> new ComponentInfo(te, pos, (Set<TileMultiblockMachineController>)ReferenceSets.synchronize((ReferenceSet)new ReferenceOpenHashSet(Collections.singleton(ctrl)))));
            if (!info.areTileEntityEquals(te)) {
                ComponentInfo newInfo = new ComponentInfo(te, pos, (Set<TileMultiblockMachineController>)ReferenceSets.synchronize((ReferenceSet)new ReferenceOpenHashSet(Collections.singleton(ctrl))));
                posComponentMap.put(pos, newInfo);
                return;
            }
            Set owners = info.owners;
            if (owners.contains(ctrl)) {
                return;
            }
            owners.add(ctrl);
            if (owners.size() <= 1) {
                return;
            }
            long groupId = owners.stream().filter(owner -> owner.getExecuteGroupId() != -1L).findFirst().map(TileMultiblockMachineController::getExecuteGroupId).orElse(ExecuteGroup.newGroupId());
            owners.forEach(owner -> owner.setExecuteGroupId(groupId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOwner(TileEntity component, TileMultiblockMachineController ctrl) {
        TileEntity te;
        BlockPos pos;
        World world = component.func_145831_w();
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            Object[] result = MachineComponentManager.getResult(component, world);
            pos = (BlockPos)result[0];
            te = (TileEntity)result[1];
        } else {
            te = component;
            pos = component.func_174877_v();
        }
        Map posComponentMap = this.componentMap.computeIfAbsent(world, v -> new ConcurrentHashMap());
        ComponentInfo info = (ComponentInfo)posComponentMap.get(pos);
        if (info == null) {
            return;
        }
        if (!info.areTileEntityEquals(te)) {
            ComponentInfo newInfo = new ComponentInfo(te, pos, (Set<TileMultiblockMachineController>)new ObjectArraySet());
            posComponentMap.put(pos, newInfo);
        } else {
            Set owners;
            Set set = owners = info.owners;
            synchronized (set) {
                owners.remove(ctrl);
            }
        }
    }

    public static final class ComponentInfo {
        private final TileEntity te;
        private final BlockPos pos;
        private final Set<TileMultiblockMachineController> owners;

        public ComponentInfo(TileEntity te, BlockPos pos, Set<TileMultiblockMachineController> owners) {
            this.te = te;
            this.pos = pos;
            this.owners = owners;
        }

        public boolean areTileEntityEquals(TileEntity te) {
            return this.te == te;
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComponentInfo) {
                ComponentInfo componentInfo = (ComponentInfo)obj;
                return this.pos.equals((Object)componentInfo.pos);
            }
            return false;
        }

        public String toString() {
            return "ComponentInfo[" + "te=" + this.te + "," + "pos=" + this.pos + "," + "owners=" + this.owners + "]";
        }

        public TileEntity te() {
            return this.te;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public Set<TileMultiblockMachineController> owners() {
            return this.owners;
        }
    }
}

