/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import github.kasuminova.mmce.common.util.concurrent.ActionExecutor;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;

public class TimeRecorder {
    private final IntArrayFIFOQueue usedTimeList = new IntArrayFIFOQueue();
    private final IntArrayFIFOQueue searchUsedTimeList = new IntArrayFIFOQueue();
    private int usedTimeCache = 0;
    private int searchUsedTimeCache = 0;

    public void updateUsedTime(ActionExecutor executor) {
        this.addUsedTime(executor == null ? 0 : executor.usedTime);
    }

    public void incrementUsedTime(int add) {
        this.usedTimeCache += add;
        if (!this.usedTimeList.isEmpty()) {
            this.usedTimeList.enqueueFirst(this.usedTimeList.dequeueInt() + add);
        } else {
            this.usedTimeList.enqueueFirst(add);
        }
    }

    public void addUsedTime(int time) {
        this.usedTimeCache += time;
        this.usedTimeList.enqueueFirst(time);
        if (this.usedTimeList.size() > 100) {
            this.usedTimeCache -= this.usedTimeList.dequeueLastInt();
        }
    }

    public void addRecipeResearchUsedTime(int time) {
        this.searchUsedTimeCache += time;
        this.searchUsedTimeList.enqueueFirst(time);
        if (this.searchUsedTimeList.size() > 20) {
            this.searchUsedTimeCache -= this.searchUsedTimeList.dequeueLastInt();
        }
    }

    public void incrementRecipeResearchUsedTime(int add) {
        this.searchUsedTimeCache += add;
        if (!this.searchUsedTimeList.isEmpty()) {
            this.searchUsedTimeList.enqueueFirst(this.searchUsedTimeList.dequeueInt() + add);
        } else {
            this.searchUsedTimeList.enqueueFirst(add);
        }
    }

    public int usedTimeAvg() {
        if (this.usedTimeList.isEmpty()) {
            return 0;
        }
        return this.usedTimeCache / this.usedTimeList.size();
    }

    public int recipeSearchUsedTimeAvg() {
        if (this.searchUsedTimeList.isEmpty()) {
            return 0;
        }
        return this.searchUsedTimeCache / this.searchUsedTimeList.size();
    }
}

