/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.util;

import github.kasuminova.mmce.common.util.IExtendedGasHandler;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class MultiGasTank
implements IExtendedGasHandler {
    private final GasStack[] contents;
    private final GasTankInfo[] props;
    private int capacity;
    private IntConsumer onSlotChanged = null;

    public MultiGasTank(int capacity, int tankCount) {
        this.capacity = capacity;
        this.contents = new GasStack[tankCount];
        this.props = new GasTankInfo[tankCount];
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i] = new GasTankInfoImpl(i);
        }
    }

    public MultiGasTank(MultiGasTank from) {
        this(from.capacity, from.contents.length);
        for (int i = 0; i < this.contents.length; ++i) {
            GasStack stack = from.contents[i];
            if (stack == null) continue;
            this.contents[i] = stack.copy();
        }
    }

    public MultiGasTank(IGasHandler from) {
        this(0, from.getTankInfo().length);
        GasTankInfo[] properties = from.getTankInfo();
        for (int i = 0; i < this.contents.length; ++i) {
            GasTankInfo prop = properties[i];
            this.capacity = Math.max(this.capacity, prop.getMaxGas());
            GasStack stack = prop.getGas();
            if (stack == null) continue;
            this.contents[i] = stack.copy();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public MultiGasTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return this.props;
    }

    public synchronized int receiveGas(EnumFacing side, GasStack gasStack, boolean doFill) {
        if (gasStack == null || gasStack.amount <= 0) {
            return 0;
        }
        GasStack insert = gasStack.copy();
        int totalFillAmount = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            int filled = this.fill(i, insert, doFill);
            totalFillAmount += filled;
            if (insert.amount <= filled) break;
            insert.amount -= filled;
        }
        return totalFillAmount;
    }

    public int fill(int slot, GasStack insert, boolean doFill) {
        if (insert == null || insert.amount <= 0) {
            return 0;
        }
        GasStack content = this.contents[slot];
        if (content == null) {
            if (this.capacity > insert.amount) {
                if (doFill) {
                    this.contents[slot] = insert;
                    this.onSlotChanged(slot);
                }
                return insert.amount;
            }
            if (doFill) {
                GasStack copied = insert.copy();
                copied.amount = this.capacity;
                this.contents[slot] = copied;
                this.onSlotChanged(slot);
            }
            return this.capacity;
        }
        if (!content.isGasEqual(insert) || content.amount >= this.capacity) {
            return 0;
        }
        int maxCanFill = this.capacity - content.amount;
        if (maxCanFill > insert.amount) {
            if (doFill) {
                content.amount += insert.amount;
                this.onSlotChanged(slot);
            }
            return insert.amount;
        }
        if (doFill) {
            content.amount = this.capacity;
            this.onSlotChanged(slot);
        }
        return maxCanFill;
    }

    @Override
    @Nullable
    public synchronized GasStack drawGas(GasStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0) {
            return null;
        }
        GasStack res = resource.copy();
        int totalDrainAmount = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            GasStack drainedStack;
            GasStack content = this.contents[i];
            if (content == null || !content.isGasEqual(res) || (drainedStack = this.drain(i, res.amount, doDrain)) == null) continue;
            int drained = drainedStack.amount;
            totalDrainAmount += drained;
            if (drained >= res.amount) break;
            res.amount -= drained;
        }
        GasStack drained = res.copy();
        drained.amount = totalDrainAmount;
        return drained;
    }

    @Nullable
    public GasStack drain(int slot, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        GasStack content = this.contents[slot];
        if (content == null) {
            return null;
        }
        if (content.amount < maxDrain) {
            if (doDrain) {
                this.contents[slot] = null;
                this.onSlotChanged(slot);
                return content;
            }
            return content.copy();
        }
        if (doDrain) {
            content.amount -= maxDrain;
            this.onSlotChanged(slot);
        }
        GasStack copied = content.copy();
        copied.amount = maxDrain;
        return copied;
    }

    @Nullable
    public synchronized GasStack drawGas(EnumFacing side, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        GasStack toDrain = Arrays.stream(this.contents).filter(Objects::nonNull).findFirst().map(GasStack::copy).orElse(null);
        if (toDrain == null) {
            return null;
        }
        toDrain.amount = maxDrain;
        return this.drawGas(toDrain, doDrain);
    }

    public GasStack getGasInSlot(int slot) {
        return slot >= 0 && slot < this.contents.length ? this.contents[slot] : null;
    }

    public void setGasInSlot(int slot, GasStack stack) {
        if (slot >= 0 && slot < this.contents.length) {
            this.contents[slot] = stack;
            this.onSlotChanged(slot);
        }
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.receiveGas(null, new GasStack(type, 1), false) > 0;
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.drawGas(new GasStack(type, 1), false) != null;
    }

    public int getSlots() {
        return this.contents.length;
    }

    public void setOnSlotChanged(IntConsumer onSlotChanged) {
        this.onSlotChanged = onSlotChanged;
    }

    private void onSlotChanged(int slot) {
        if (this.onSlotChanged != null) {
            this.onSlotChanged.accept(slot);
        }
    }

    public void readFromNBT(NBTTagCompound compound, String name) {
        NBTTagCompound tag = compound.func_74775_l(name);
        Arrays.fill(this.contents, null);
        if (tag.func_82582_d()) {
            return;
        }
        for (int i = 0; i < this.contents.length; ++i) {
            NBTTagCompound t = tag.func_74775_l("#" + i);
            this.contents[i] = t.func_82582_d() ? null : GasStack.readFromNBT((NBTTagCompound)t);
        }
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.contents.length; ++i) {
            GasStack stack = this.contents[i];
            if (stack == null) continue;
            NBTTagCompound t = new NBTTagCompound();
            stack.write(t);
            tag.func_74782_a("#" + i, (NBTBase)t);
        }
        compound.func_74782_a(name, (NBTBase)tag);
    }

    public class GasTankInfoImpl
    implements GasTankInfo {
        private final int index;

        public GasTankInfoImpl(int index) {
            this.index = index;
        }

        @Nullable
        public GasStack getGas() {
            return MultiGasTank.this.contents[this.index];
        }

        public int getStored() {
            GasStack content = MultiGasTank.this.contents[this.index];
            return content != null ? content.amount : 0;
        }

        public int getMaxGas() {
            return MultiGasTank.this.capacity;
        }
    }
}

