/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile.base;

import appeng.api.AEApi;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.storage.channels.IItemStorageChannel;
import github.kasuminova.mmce.common.tile.base.MEMachineComponent;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class MEItemBus
extends MEMachineComponent
implements IGridTickable {
    protected final IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    protected IOInventory inventory = this.buildInventory();
    protected boolean[] changedSlots = new boolean[this.inventory.getSlots()];
    protected int[] failureCounter = new int[this.inventory.getSlots()];
    protected long lastFullCheckTick = 0L;
    protected boolean inTick = false;

    public abstract IOInventory buildInventory();

    protected synchronized int[] getNeedUpdateSlots() {
        long current = this.field_145850_b.func_82737_E();
        if (this.lastFullCheckTick + 100L < current) {
            this.lastFullCheckTick = current;
            return IntStream.range(0, this.inventory.getSlots()).toArray();
        }
        IntArrayList needUpdateSlots = new IntArrayList(this.changedSlots.length + 1);
        int bound = this.changedSlots.length;
        for (int i = 0; i < bound; ++i) {
            if (!this.changedSlots[i] || this.failureCounter[i] > 0) continue;
            needUpdateSlots.add(i);
        }
        return needUpdateSlots.toIntArray();
    }

    public IOInventory getInternalInventory() {
        return this.inventory;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        if (capability == cap) {
            return (T)cap.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (compound.func_74764_b("inventory")) {
            this.readInventoryNBT(compound.func_74775_l("inventory"));
        }
    }

    public void readInventoryNBT(NBTTagCompound tag) {
        this.inventory = IOInventory.deserialize(this, tag);
        this.inventory.setListener(slot -> {
            MEItemBus mEItemBus = this;
            synchronized (mEItemBus) {
                this.changedSlots[slot.intValue()] = true;
            }
        });
        int[] slotIDs = new int[this.inventory.getSlots()];
        for (int slotID = 0; slotID < slotIDs.length; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        this.inventory.setStackLimit(Integer.MAX_VALUE, slotIDs);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.writeNBT());
    }

    public boolean hasItem() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChangedSlots() {
        for (boolean changed : this.changedSlots) {
            if (!changed) continue;
            return true;
        }
        return false;
    }
}

