/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile.base;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.util.IConfigManager;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.IGasInventoryHost;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import github.kasuminova.mmce.common.tile.base.MEMachineComponent;
import github.kasuminova.mmce.common.util.GasInventoryHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class MEGasBus
extends MEMachineComponent
implements IGasInventoryHost,
IUpgradeableHost,
IConfigManagerHost,
IAEAppEngInventory,
IGridTickable {
    public static final int TANK_SLOT_AMOUNT = 9;
    public static final int TANK_DEFAULT_CAPACITY = 8000;
    protected final IGasStorageChannel channel = (IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
    protected final ConfigManager cm = new ConfigManager((IConfigManagerHost)this);
    protected final UpgradeInventory upgrades;
    protected final GasInventory tanks = new GasInventory(9, 8000, (IGasInventoryHost)this);
    protected final GasInventoryHandler handler = new GasInventoryHandler((IGasInventory)this.tanks);
    protected boolean[] changedSlots;
    protected long lastFullCheckTick = 0L;
    protected boolean inTick = false;

    public MEGasBus() {
        this.upgrades = new StackUpgradeInventory(this.proxy.getMachineRepresentation(), (IAEAppEngInventory)this, 5);
        this.changedSlots = new boolean[9];
    }

    protected synchronized int[] getNeedUpdateSlots() {
        long current = this.field_145850_b.func_82737_E();
        if (this.lastFullCheckTick + 100L < current) {
            this.lastFullCheckTick = current;
            return IntStream.range(0, this.tanks.size()).toArray();
        }
        IntArrayList needUpdateSlots = new IntArrayList(this.changedSlots.length + 1);
        int bound = this.changedSlots.length;
        for (int i = 0; i < bound; ++i) {
            if (!this.changedSlots[i]) continue;
            needUpdateSlots.add(i);
        }
        return needUpdateSlots.toIntArray();
    }

    public GasInventory getTanks() {
        return this.tanks;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Capability cap = Capabilities.GAS_HANDLER_CAPABILITY;
        if (capability == cap) {
            return (T)cap.cast((Object)this.handler);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.upgrades.readFromNBT(compound, "upgrades");
        this.tanks.load(compound.func_74775_l("tanks"));
        this.updateTankCapacity();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.upgrades.writeToNBT(compound, "upgrades");
        compound.func_74782_a("tanks", (NBTBase)this.tanks.save());
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public IItemHandlerModifiable getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.updateTankCapacity();
        this.markNoUpdateSync();
    }

    public void onGasInventoryChanged(IGasInventory iGasInventory, int slot) {
        if (!this.inTick) {
            this.changedSlots[slot] = true;
        }
        this.markNoUpdateSync();
    }

    private void updateTankCapacity() {
        this.tanks.setCap((int)(Math.pow(4.0, this.getInstalledUpgrades(Upgrades.CAPACITY) + 1) * 2000.0));
    }

    public void saveChanges() {
    }

    public TileEntity getTile() {
        return this;
    }
}

