/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import github.kasuminova.mmce.common.tile.SettingsTransfer;
import github.kasuminova.mmce.common.tile.base.MEItemBus;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MEItemInputBus
extends MEItemBus
implements SettingsTransfer {
    private static final String CONFIG_TAG_KEY = "configInventory";
    private static final Map<ItemStack, IAEItemStack> AE_STACK_CACHE = new WeakHashMap<ItemStack, IAEItemStack>();
    private IOInventory configInventory = this.buildConfigInventory();

    @Override
    public IOInventory buildInventory() {
        int size = 16;
        int[] slotIDs = new int[size];
        for (int slotID = 0; slotID < size; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        IOInventory inv = new IOInventory(this, slotIDs, new int[0]);
        inv.setStackLimit(Integer.MAX_VALUE, slotIDs);
        inv.setListener(slot -> {
            MEItemInputBus mEItemInputBus = this;
            synchronized (mEItemInputBus) {
                this.changedSlots[slot.intValue()] = true;
            }
        });
        return inv;
    }

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(ItemsMM.meItemInputBus);
    }

    public IOInventory buildConfigInventory() {
        int size = 16;
        int[] slotIDs = new int[size];
        for (int slotID = 0; slotID < size; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        IOInventory inv = new IOInventory(this, new int[0], new int[0]);
        inv.setStackLimit(Integer.MAX_VALUE, slotIDs);
        inv.setMiscSlots(slotIDs);
        inv.setListener(slot -> {
            MEItemInputBus mEItemInputBus = this;
            synchronized (mEItemInputBus) {
                this.changedSlots[slot.intValue()] = true;
            }
        });
        return inv;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (compound.func_74764_b(CONFIG_TAG_KEY)) {
            this.readConfigInventoryNBT(compound.func_74775_l(CONFIG_TAG_KEY));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a(CONFIG_TAG_KEY, (NBTBase)this.configInventory.writeNBT());
    }

    public IOInventory getConfigInventory() {
        return this.configInventory;
    }

    @Nullable
    public MachineComponent.ItemBus provideComponent() {
        return new MachineComponent.ItemBus(IOType.INPUT){

            @Override
            public IOInventory getContainerProvider() {
                return MEItemInputBus.this.inventory;
            }
        };
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(10, 120, !this.needsUpdate(), true);
    }

    private boolean needsUpdate() {
        for (int slot = 0; slot < this.configInventory.getSlots(); ++slot) {
            ItemStack cfgStack = this.configInventory.getStackInSlot(slot);
            ItemStack invStack = this.inventory.getStackInSlot(slot);
            if (cfgStack.func_190926_b()) {
                if (invStack.func_190926_b()) continue;
                return true;
            }
            if (invStack.func_190926_b()) {
                return true;
            }
            if (ItemUtils.matchStacks(cfgStack, invStack) && invStack.func_190916_E() == cfgStack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.proxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        int[] needUpdateSlots = this.getNeedUpdateSlots();
        if (needUpdateSlots.length == 0) {
            return TickRateModulation.SLOWER;
        }
        ReadWriteLock rwLock = this.inventory.getRWLock();
        try {
            rwLock.writeLock().lock();
            boolean successAtLeastOnce = false;
            this.inTick = true;
            IMEMonitor inv = this.proxy.getStorage().getInventory((IStorageChannel)this.channel);
            for (int slot : needUpdateSlots) {
                ItemStack stack;
                this.changedSlots[slot] = false;
                ItemStack cfgStack = this.configInventory.getStackInSlot(slot);
                ItemStack invStack = this.inventory.getStackInSlot(slot);
                if (cfgStack.func_190926_b()) {
                    if (invStack.func_190926_b()) continue;
                    this.inventory.setStackInSlot(slot, this.insertStackToAE((IMEMonitor<IAEItemStack>)inv, invStack));
                    continue;
                }
                if (!ItemUtils.matchStacks(cfgStack, invStack)) {
                    if (!invStack.func_190926_b() && !this.insertStackToAE((IMEMonitor<IAEItemStack>)inv, invStack).func_190926_b()) continue;
                    ItemStack stack2 = this.extractStackFromAE((IMEMonitor<IAEItemStack>)inv, cfgStack);
                    this.inventory.setStackInSlot(slot, stack2);
                    if (stack2.func_190926_b()) continue;
                    successAtLeastOnce = true;
                    continue;
                }
                if (cfgStack.func_190916_E() == invStack.func_190916_E()) continue;
                if (cfgStack.func_190916_E() > invStack.func_190916_E()) {
                    int countToReceive = cfgStack.func_190916_E() - invStack.func_190916_E();
                    stack = this.extractStackFromAE((IMEMonitor<IAEItemStack>)inv, ItemUtils.copyStackWithSize(invStack, countToReceive));
                    if (!stack.func_190926_b()) {
                        int newCount = invStack.func_190916_E() + stack.func_190916_E();
                        this.inventory.setStackInSlot(slot, ItemUtils.copyStackWithSize(invStack, newCount));
                        successAtLeastOnce = true;
                        this.failureCounter[slot] = 0;
                        continue;
                    }
                    int n = slot;
                    this.failureCounter[n] = this.failureCounter[n] + 1;
                    continue;
                }
                int countToExtract = invStack.func_190916_E() - cfgStack.func_190916_E();
                stack = this.insertStackToAE((IMEMonitor<IAEItemStack>)inv, ItemUtils.copyStackWithSize(invStack, countToExtract));
                if (stack.func_190926_b()) {
                    this.inventory.setStackInSlot(slot, ItemUtils.copyStackWithSize(invStack, invStack.func_190916_E() - countToExtract));
                } else {
                    this.inventory.setStackInSlot(slot, ItemUtils.copyStackWithSize(invStack, invStack.func_190916_E() - countToExtract + stack.func_190916_E()));
                }
                successAtLeastOnce = true;
            }
            this.inTick = false;
            rwLock.writeLock().unlock();
            return successAtLeastOnce ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        catch (GridAccessException e) {
            this.inTick = false;
            this.changedSlots = new boolean[this.changedSlots.length];
            rwLock.writeLock().unlock();
            return TickRateModulation.IDLE;
        }
    }

    private ItemStack extractStackFromAE(IMEMonitor<IAEItemStack> inv, ItemStack stack) throws GridAccessException {
        IAEItemStack aeStack = this.createStack(stack);
        if (aeStack == null) {
            return ItemStack.field_190927_a;
        }
        IAEItemStack extracted = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)aeStack, (IActionSource)this.source);
        if (extracted == null) {
            return ItemStack.field_190927_a;
        }
        return extracted.createItemStack();
    }

    private ItemStack insertStackToAE(IMEMonitor<IAEItemStack> inv, ItemStack stack) throws GridAccessException {
        IAEItemStack aeStack = this.createStack(stack);
        if (aeStack == null) {
            return stack;
        }
        IAEItemStack left = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)aeStack, (IActionSource)this.source);
        if (left == null) {
            return ItemStack.field_190927_a;
        }
        return left.createItemStack();
    }

    private IAEItemStack createStack(ItemStack stack) {
        return AE_STACK_CACHE.computeIfAbsent(stack, v -> (IAEItemStack)this.channel.createStack((Object)stack));
    }

    @Override
    public void markNoUpdate() {
        if (this.hasChangedSlots()) {
            try {
                this.proxy.getTick().alertDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        super.markNoUpdate();
    }

    public boolean configInvHasItem() {
        for (int i = 0; i < this.configInventory.getSlots(); ++i) {
            ItemStack stack = this.configInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void readConfigInventoryNBT(NBTTagCompound compound) {
        this.configInventory = IOInventory.deserialize(this, compound);
        this.configInventory.setListener(slot -> {
            MEItemInputBus mEItemInputBus = this;
            synchronized (mEItemInputBus) {
                this.changedSlots[slot.intValue()] = true;
            }
        });
        int[] slotIDs = new int[this.configInventory.getSlots()];
        for (int slotID = 0; slotID < slotIDs.length; ++slotID) {
            slotIDs[slotID] = slotID;
        }
        this.configInventory.setStackLimit(Integer.MAX_VALUE, slotIDs);
    }

    @Override
    public NBTTagCompound downloadSettings() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(CONFIG_TAG_KEY, (NBTBase)this.configInventory.writeNBT());
        return tag;
    }

    @Override
    public void uploadSettings(NBTTagCompound settings) {
        this.readConfigInventoryNBT(settings.func_74775_l(CONFIG_TAG_KEY));
        try {
            this.proxy.getTick().alertDevice(this.proxy.getNode());
        }
        catch (GridAccessException e) {
            ModularMachinery.log.warn("Error while uploading settings", (Throwable)e);
        }
    }
}

