/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventoryHost;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import github.kasuminova.mmce.common.tile.SettingsTransfer;
import github.kasuminova.mmce.common.tile.base.MEGasBus;
import github.kasuminova.mmce.common.util.IExtendedGasHandler;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.lib.ComponentTypesMM;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MEGasInputBus
extends MEGasBus
implements SettingsTransfer {
    private static final String CONFIG_TAG_KEY = "config";
    private final GasInventory config = new GasInventory(9, (IGasInventoryHost)this);

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(ItemsMM.meGasInputBus);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.config.load(compound.func_74775_l(CONFIG_TAG_KEY));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a(CONFIG_TAG_KEY, (NBTBase)this.config.save());
        this.upgrades.writeToNBT(compound, "upgrades");
    }

    public GasInventory getConfig() {
        return this.config;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(10, 120, !this.needsUpdate(), true);
    }

    private boolean needsUpdate() {
        int capacity = this.tanks.getTanks()[0].getMaxGas();
        for (int slot = 0; slot < this.config.size(); ++slot) {
            GasStack cfgStack = this.config.getGasStack(slot);
            GasStack invStack = this.tanks.getGasStack(slot);
            if (cfgStack == null) {
                if (invStack == null) continue;
                return true;
            }
            if (invStack == null) {
                return true;
            }
            if (cfgStack.isGasEqual(invStack) && invStack.amount == capacity) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.proxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        this.inTick = true;
        try {
            boolean successAtLeastOnce = false;
            IMEMonitor inv = this.proxy.getStorage().getInventory((IStorageChannel)this.channel);
            int capacity = this.tanks.getTanks()[0].getMaxGas();
            GasInventory gasInventory = this.tanks;
            synchronized (gasInventory) {
                for (int slot : this.getNeedUpdateSlots()) {
                    GasStack copied;
                    this.changedSlots[slot] = false;
                    GasStack cfgStack = this.config.getGasStack(slot);
                    GasStack invStack = this.tanks.getGasStack(slot);
                    if (cfgStack == null) {
                        if (invStack == null) continue;
                        IAEGasStack left = this.insertStackToAE((IMEMonitor<IAEGasStack>)inv, invStack);
                        this.tanks.setGas(slot, left == null ? null : left.getGasStack());
                        continue;
                    }
                    if (!cfgStack.isGasEqual(invStack)) {
                        IAEGasStack left;
                        if (invStack != null && (left = this.insertStackToAE((IMEMonitor<IAEGasStack>)inv, invStack)) != null) {
                            this.tanks.setGas(slot, left.getGasStack());
                            continue;
                        }
                        GasStack copied2 = cfgStack.copy();
                        copied2.amount = capacity;
                        IAEGasStack stack = this.extractStackFromAE((IMEMonitor<IAEGasStack>)inv, copied2);
                        if (stack == null) continue;
                        this.tanks.setGas(slot, stack.getGasStack());
                        successAtLeastOnce = true;
                        continue;
                    }
                    if (capacity == invStack.amount) continue;
                    if (capacity > invStack.amount) {
                        int countToReceive = capacity - invStack.amount;
                        copied = invStack.copy();
                        copied.amount = countToReceive;
                        IAEGasStack stack = this.extractStackFromAE((IMEMonitor<IAEGasStack>)inv, copied);
                        if (stack == null) continue;
                        copied = invStack.copy();
                        copied.amount = (int)((long)invStack.amount + stack.getStackSize());
                        this.tanks.setGas(slot, copied);
                        successAtLeastOnce = true;
                        continue;
                    }
                    int countToExtract = invStack.amount - capacity;
                    copied = invStack.copy();
                    copied.amount = countToExtract;
                    IAEGasStack left = this.insertStackToAE((IMEMonitor<IAEGasStack>)inv, copied);
                    if (left == null) {
                        copied.amount = invStack.amount - countToExtract;
                        this.tanks.setGas(slot, copied);
                    } else {
                        copied.amount = (int)((long)(invStack.amount - countToExtract) + left.getStackSize());
                        this.tanks.setGas(slot, copied);
                    }
                    successAtLeastOnce = true;
                }
            }
            this.inTick = false;
            return successAtLeastOnce ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        catch (GridAccessException e) {
            this.inTick = false;
            this.changedSlots = new boolean[9];
            return TickRateModulation.IDLE;
        }
    }

    private IAEGasStack extractStackFromAE(IMEMonitor<IAEGasStack> inv, GasStack stack) throws GridAccessException {
        return (IAEGasStack)Platform.poweredExtraction((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)((IAEGasStack)Objects.requireNonNull(AEGasStack.of((GasStack)stack))), (IActionSource)this.source);
    }

    private IAEGasStack insertStackToAE(IMEMonitor<IAEGasStack> inv, GasStack stack) throws GridAccessException {
        return (IAEGasStack)Platform.poweredInsert((IEnergySource)this.proxy.getEnergy(), inv, (IAEStack)((IAEGasStack)Objects.requireNonNull(AEGasStack.of((GasStack)stack))), (IActionSource)this.source);
    }

    @Nullable
    public MachineComponent<IExtendedGasHandler> provideComponent() {
        return new MachineComponent<IExtendedGasHandler>(IOType.INPUT){

            @Override
            public ComponentType getComponentType() {
                return ComponentTypesMM.COMPONENT_GAS;
            }

            @Override
            public IExtendedGasHandler getContainerProvider() {
                return MEGasInputBus.this.handler;
            }
        };
    }

    @Override
    public void markNoUpdate() {
        if (this.needsUpdate()) {
            try {
                this.proxy.getTick().alertDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        super.markNoUpdate();
    }

    @Override
    public NBTTagCompound downloadSettings() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(CONFIG_TAG_KEY, (NBTBase)this.config.save());
        return tag;
    }

    @Override
    public void uploadSettings(NBTTagCompound settings) {
        this.config.load(settings.func_74775_l(CONFIG_TAG_KEY));
        try {
            this.proxy.getTick().alertDevice(this.proxy.getNode());
        }
        catch (GridAccessException e) {
            ModularMachinery.log.warn("Error while uploading settings", (Throwable)e);
        }
    }
}

