/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import github.kasuminova.mmce.common.tile.base.MEFluidBus;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MEFluidOutputBus
extends MEFluidBus {
    public MEFluidOutputBus() {
        this.tanks.setOneFluidOneSlot(true);
    }

    @Override
    public ItemStack getVisualItemStack() {
        return new ItemStack(ItemsMM.meFluidOutputBus);
    }

    @Nullable
    public MachineComponent<IFluidHandler> provideComponent() {
        return new MachineComponent.FluidHatch(IOType.OUTPUT){

            @Override
            public IFluidHandler getContainerProvider() {
                return MEFluidOutputBus.this.tanks;
            }
        };
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(5, 60, !this.hasFluid(), true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.proxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        int[] needUpdateSlots = this.getNeedUpdateSlots();
        if (needUpdateSlots.length == 0) {
            return TickRateModulation.SLOWER;
        }
        ReadWriteLock rwLock = this.tanks.getRWLock();
        try {
            rwLock.writeLock().lock();
            this.inTick = true;
            boolean successAtLeastOnce = false;
            IMEMonitor inv = this.proxy.getStorage().getInventory((IStorageChannel)this.channel);
            for (int slot : needUpdateSlots) {
                this.changedSlots[slot] = false;
                IAEFluidStack fluid = this.tanks.getFluidInSlot(slot);
                if (fluid == null) continue;
                IAEFluidStack left = (IAEFluidStack)Platform.poweredInsert((IEnergySource)this.proxy.getEnergy(), (IMEInventory)inv, (IAEStack)fluid.copy(), (IActionSource)this.source);
                if (left != null) {
                    if (fluid.getStackSize() != left.getStackSize()) {
                        successAtLeastOnce = true;
                    }
                } else {
                    successAtLeastOnce = true;
                }
                this.tanks.setFluidInSlot(slot, left);
            }
            this.inTick = false;
            rwLock.writeLock().unlock();
            return successAtLeastOnce ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        catch (GridAccessException e) {
            this.inTick = false;
            this.changedSlots = new boolean[9];
            rwLock.writeLock().unlock();
            return TickRateModulation.IDLE;
        }
    }

    public boolean hasFluid() {
        for (int i = 0; i < this.tanks.getSlots(); ++i) {
            IAEFluidStack stack = this.tanks.getFluidInSlot(i);
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void markNoUpdate() {
        if (this.hasFluid()) {
            try {
                this.proxy.getTick().alertDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        super.markNoUpdate();
    }
}

