/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.integration.gregtech.componentproxy;

import github.kasuminova.mmce.common.integration.gregtech.handlerproxy.GTFluidTankProxy;
import github.kasuminova.mmce.common.machine.component.MachineComponentProxy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityFluidHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEInputHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEOutputHatch;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GTFluidHatchProxy
implements MachineComponentProxy<GTFluidHatchMachineComponent> {
    public static final GTFluidHatchProxy INSTANCE = new GTFluidHatchProxy();

    private GTFluidHatchProxy() {
    }

    @Nullable
    protected static GTFluidHatchMachineComponent getGtFluidHatchMachineComponent(MultiblockAbility<IFluidTank> ability, List<IFluidTank> abilities) {
        if (ability == MultiblockAbility.IMPORT_FLUIDS) {
            return new GTFluidHatchMachineComponent(IOType.INPUT, abilities.get(0));
        }
        if (ability == MultiblockAbility.EXPORT_FLUIDS) {
            return new GTFluidHatchMachineComponent(IOType.OUTPUT, abilities.get(0));
        }
        return null;
    }

    @Override
    public boolean isSupported(TileEntity te) {
        if (te instanceof MetaTileEntityHolder) {
            MetaTileEntityHolder metaTEHolder = (MetaTileEntityHolder)te;
            MetaTileEntity metaTE = metaTEHolder.getMetaTileEntity();
            return metaTE instanceof MetaTileEntityFluidHatch || metaTE instanceof MetaTileEntityMEInputHatch || metaTE instanceof MetaTileEntityMEOutputHatch;
        }
        return false;
    }

    @Override
    public GTFluidHatchMachineComponent proxyComponent(TileEntity te) {
        if (!(te instanceof MetaTileEntityHolder)) {
            return null;
        }
        MetaTileEntityHolder metaTEHolder = (MetaTileEntityHolder)te;
        MetaTileEntity metaTE = metaTEHolder.getMetaTileEntity();
        ArrayList<IFluidTank> abilities = new ArrayList<IFluidTank>();
        if (metaTE instanceof MetaTileEntityFluidHatch) {
            MetaTileEntityFluidHatch itemBus = (MetaTileEntityFluidHatch)metaTE;
            itemBus.registerAbilities(abilities);
            return GTFluidHatchProxy.getGtFluidHatchMachineComponent((MultiblockAbility<IFluidTank>)itemBus.getAbility(), abilities);
        }
        if (metaTE instanceof MetaTileEntityMEInputHatch) {
            MetaTileEntityMEInputHatch meInputHatch = (MetaTileEntityMEInputHatch)metaTE;
            meInputHatch.registerAbilities(abilities);
            return GTFluidHatchProxy.getGtFluidHatchMachineComponent((MultiblockAbility<IFluidTank>)meInputHatch.getAbility(), abilities);
        }
        if (metaTE instanceof MetaTileEntityMEOutputHatch) {
            MetaTileEntityMEOutputHatch meOutputHatch = (MetaTileEntityMEOutputHatch)metaTE;
            meOutputHatch.registerAbilities(abilities);
            return GTFluidHatchProxy.getGtFluidHatchMachineComponent((MultiblockAbility<IFluidTank>)meOutputHatch.getAbility(), abilities);
        }
        return null;
    }

    public static class GTFluidHatchMachineComponent
    extends MachineComponent.FluidHatch {
        private final IFluidHandler fluidHandler;

        public GTFluidHatchMachineComponent(IOType ioType, IFluidTank fluidTank) {
            super(ioType);
            this.fluidHandler = new GTFluidTankProxy(fluidTank);
        }

        @Override
        public boolean isAsyncSupported() {
            return false;
        }

        @Override
        public IFluidHandler getContainerProvider() {
            return this.fluidHandler;
        }
    }
}

