/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.integration.gregtech.componentproxy;

import github.kasuminova.mmce.common.integration.gregtech.handlerproxy.GTEnergyHandlerProxy;
import github.kasuminova.mmce.common.machine.component.MachineComponentProxy;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityEnergyHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityLaserHatch;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class GTEnergyHatchProxy
implements MachineComponentProxy<GTEnergyHatchMachineComponent> {
    public static final GTEnergyHatchProxy INSTANCE = new GTEnergyHatchProxy();

    private GTEnergyHatchProxy() {
    }

    @Override
    public boolean isSupported(TileEntity te) {
        if (te instanceof MetaTileEntityHolder) {
            MetaTileEntityHolder metaTEHolder = (MetaTileEntityHolder)te;
            MetaTileEntity metaTE = metaTEHolder.getMetaTileEntity();
            return metaTE instanceof MetaTileEntityEnergyHatch || metaTE instanceof MetaTileEntityLaserHatch;
        }
        return false;
    }

    @Override
    @Nullable
    public GTEnergyHatchMachineComponent proxyComponent(TileEntity te) {
        if (!(te instanceof MetaTileEntityHolder)) {
            return null;
        }
        MetaTileEntityHolder metaTEHolder = (MetaTileEntityHolder)te;
        MetaTileEntity metaTE = metaTEHolder.getMetaTileEntity();
        if (metaTE instanceof MetaTileEntityEnergyHatch) {
            MetaTileEntityEnergyHatch energyHatch = (MetaTileEntityEnergyHatch)metaTE;
            ArrayList list = new ArrayList(2);
            MultiblockAbility ability = energyHatch.getAbility();
            if (ability == MultiblockAbility.INPUT_ENERGY) {
                energyHatch.registerAbilities(list);
                return new GTEnergyHatchMachineComponent(IOType.INPUT, (IEnergyContainer)list.get(0));
            }
            if (ability == MultiblockAbility.OUTPUT_ENERGY) {
                energyHatch.registerAbilities(list);
                return new GTEnergyHatchMachineComponent(IOType.OUTPUT, (IEnergyContainer)list.get(0));
            }
            return null;
        }
        if (metaTE instanceof MetaTileEntityLaserHatch) {
            MetaTileEntityLaserHatch laserHatch = (MetaTileEntityLaserHatch)metaTE;
            ArrayList list = new ArrayList(2);
            MultiblockAbility ability = laserHatch.getAbility();
            if (ability == MultiblockAbility.INPUT_LASER) {
                laserHatch.registerAbilities(list);
                return new GTEnergyHatchMachineComponent(IOType.INPUT, (IEnergyContainer)list.get(0));
            }
            if (ability == MultiblockAbility.OUTPUT_LASER) {
                laserHatch.registerAbilities(list);
                return new GTEnergyHatchMachineComponent(IOType.OUTPUT, (IEnergyContainer)list.get(0));
            }
            return null;
        }
        return null;
    }

    public static class GTEnergyHatchMachineComponent
    extends MachineComponent.EnergyHatch {
        private final IEnergyContainer energyContainer;

        public GTEnergyHatchMachineComponent(IOType ioType, IEnergyContainer energyContainer) {
            super(ioType);
            this.energyContainer = energyContainer;
        }

        @Override
        public boolean isAsyncSupported() {
            return false;
        }

        @Override
        public IEnergyHandlerAsync getContainerProvider() {
            return new GTEnergyHandlerProxy(this.energyContainer);
        }
    }
}

