/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.handler;

import appeng.container.AEBaseContainer;
import github.kasuminova.mmce.common.network.PktPerformanceReport;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.container.ContainerBase;
import hellfirepvp.modularmachinery.common.item.ItemBlockController;
import hellfirepvp.modularmachinery.common.tiles.base.SelectiveUpdateTileEntity;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandler {
    private static boolean checkTERange(EntityPlayer player, TileEntity te) {
        BlockPos playerPos;
        BlockPos tePos = te.func_174877_v();
        return tePos.func_185332_f((playerPos = player.func_180425_c()).func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()) >= 6.0;
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(event.getPos());
        if (te instanceof SelectiveUpdateTileEntity && te instanceof TileEntitySynchronized) {
            TileEntitySynchronized teSync = (TileEntitySynchronized)te;
            teSync.notifyUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Object te;
        if (event.phase != TickEvent.Phase.START || event.side != Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerBase) {
            te = ((ContainerBase)container).getOwner();
        } else {
            if (!Mods.AE2.isPresent() || !(container instanceof AEBaseContainer)) {
                return;
            }
            te = ((AEBaseContainer)container).getTileEntity();
        }
        if (!(te instanceof SelectiveUpdateTileEntity) || !(te instanceof TileEntitySynchronized)) {
            return;
        }
        TileEntitySynchronized teSync = (TileEntitySynchronized)((Object)te);
        if (EventHandler.checkTERange(player, te)) {
            player.func_71053_j();
            return;
        }
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            if (teSync.getLastUpdateTick() + 1L >= playerMP.field_70170_p.func_82737_E()) {
                playerMP.field_71135_a.func_147359_a((Packet)teSync.func_189518_D_());
            }
            World world = event.player.func_130014_f_();
            if (te instanceof TileMultiblockMachineController) {
                TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
                if (world.func_72820_D() % 15L == 0L) {
                    int usedTime = ctrl.usedTimeAvg();
                    int searchUsedTimeAvg = ctrl.recipeSearchUsedTimeAvg();
                    ModularMachinery.NET_CHANNEL.sendTo((IMessage)new PktPerformanceReport(usedTime, searchUsedTimeAvg, ctrl.getWorkMode()), playerMP);
                }
            }
        });
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!TileMultiblockMachineController.enableSecuritySystem) {
            return;
        }
        if (!(event.getState().func_177230_c() instanceof BlockController)) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player.func_184812_l_()) {
            return;
        }
        World world = event.getWorld();
        TileEntity te = world.func_175625_s(event.getPos());
        if (!(te instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        UUID ownerUUID = ctrl.getOwner();
        if (ownerUUID == null) {
            return;
        }
        UUID playerUUID = player.func_146103_bH().getId();
        if (!playerUUID.equals(ownerUUID)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (!TileMultiblockMachineController.enableSecuritySystem) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player.func_184812_l_()) {
            return;
        }
        ItemStack itemInHand = event.getItemInHand();
        if (!(itemInHand.func_77973_b() instanceof ItemBlockController)) {
            return;
        }
        NBTTagCompound stackTag = itemInHand.func_77978_p();
        if (stackTag == null || !stackTag.func_74764_b("owner")) {
            return;
        }
        String ownerUUIDStr = stackTag.func_74779_i("owner");
        try {
            UUID ownerUUID = UUID.fromString(ownerUUIDStr);
            UUID playerUUID = player.func_146103_bH().getId();
            if (!playerUUID.equals(ownerUUID)) {
                event.setCanceled(true);
            }
        }
        catch (Exception e) {
            ModularMachinery.log.warn("Invalid owner uuid " + ownerUUIDStr, (Throwable)e);
        }
    }
}

