/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.event.recipe;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.RecipeEvent;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.RecipeTickEvent")
public class RecipeTickEvent
extends RecipeEvent {
    public final Phase phase;
    private final RecipeThread recipeThread;
    private boolean isFailure = false;
    private boolean destructRecipe = false;
    private boolean preventProgressing = false;
    private String failureReason = null;

    public RecipeTickEvent(TileMultiblockMachineController controller, RecipeThread recipeThread, Phase phase) {
        super(controller, recipeThread, recipeThread.getContext());
        this.phase = phase;
        this.recipeThread = recipeThread;
    }

    @Override
    public void postEvent() {
        super.postEvent();
        if (this.preventProgressing) {
            ActiveMachineRecipe activeRecipe = this.recipeThread.getActiveRecipe();
            if (activeRecipe.getTick() > 0) {
                activeRecipe.setTick(activeRecipe.getTick() - 1);
            }
            this.recipeThread.setStatus(CraftingStatus.working(this.failureReason));
            return;
        }
        if (this.isFailure) {
            if (this.destructRecipe) {
                this.recipeThread.setActiveRecipe(null).setContext(null).setStatus(CraftingStatus.failure(this.failureReason)).getSemiPermanentModifiers().clear();
                return;
            }
            this.recipeThread.setStatus(CraftingStatus.failure(this.failureReason));
        }
    }

    @ZenMethod
    public void preventProgressing(String reason) {
        this.preventProgressing = true;
        this.failureReason = reason;
        this.setCanceled(true);
    }

    @ZenMethod
    public void setFailed(boolean destructRecipe, String reason) {
        this.isFailure = true;
        this.destructRecipe = destructRecipe;
        this.failureReason = reason;
        this.setCanceled(true);
    }

    public boolean isFailure() {
        return this.isFailure;
    }

    public boolean isPreventProgressing() {
        return this.preventProgressing;
    }

    public boolean isDestructRecipe() {
        return this.destructRecipe;
    }

    public String getFailureReason() {
        return this.failureReason;
    }
}

