/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.event.recipe;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeEvent;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.FactoryRecipeTickEvent")
public class FactoryRecipeTickEvent
extends FactoryRecipeEvent {
    public final Phase phase;
    private boolean preventProgressing = false;
    private boolean isFailure = false;
    private boolean destructRecipe = false;
    private String failureReason = null;

    public FactoryRecipeTickEvent(FactoryRecipeThread recipeThread, TileMultiblockMachineController controller, Phase phase) {
        super(recipeThread, controller);
        this.phase = phase;
    }

    @Override
    public void postEvent() {
        super.postEvent();
        if (this.preventProgressing) {
            ActiveMachineRecipe activeRecipe = this.recipeThread.getActiveRecipe();
            if (activeRecipe.getTick() > 0) {
                activeRecipe.setTick(activeRecipe.getTick() - 1);
            }
            this.recipeThread.setStatus(CraftingStatus.working(this.failureReason));
            return;
        }
        if (this.isFailure) {
            if (this.destructRecipe) {
                this.recipeThread.setActiveRecipe(null).setContext(null).setStatus(CraftingStatus.failure(this.failureReason)).getSemiPermanentModifiers().clear();
                return;
            }
            this.recipeThread.setStatus(CraftingStatus.failure(this.failureReason));
        }
    }

    @ZenMethod
    public void setFailed(boolean destructRecipe, String reason) {
        this.isFailure = true;
        this.destructRecipe = destructRecipe;
        this.failureReason = reason;
        this.setCanceled(true);
    }

    @ZenMethod
    public void preventProgressing(String reason) {
        this.preventProgressing = true;
        this.failureReason = reason;
        this.setCanceled(true);
    }

    public boolean isFailure() {
        return this.isFailure;
    }

    public boolean isDestructRecipe() {
        return this.destructRecipe;
    }

    public boolean isPreventProgressing() {
        return this.preventProgressing;
    }

    public String getFailureReason() {
        return this.failureReason;
    }
}

