/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.event.client;

import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.client.model.DynamicMachineModelRegistry;
import github.kasuminova.mmce.common.event.machine.MachineEvent;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ModOnly(value="geckolib3")
@ZenClass(value="mods.modularmachinery.ControllerModelAnimationEvent")
public class ControllerModelAnimationEvent
extends MachineEvent {
    private final List<AnimationCT> animations = new ArrayList<AnimationCT>();
    private final AnimationEvent<TileMultiblockMachineController> event;
    private final String currentModelName;
    private int playState = 0;

    public ControllerModelAnimationEvent(TileMultiblockMachineController controller, AnimationEvent<TileMultiblockMachineController> event) {
        super(controller);
        this.event = event;
        String currentModelName = controller.getCurrentModelName();
        if (currentModelName.isEmpty()) {
            currentModelName = DynamicMachineModelRegistry.INSTANCE.getMachineDefaultModel(controller.getFoundMachine()).getModelName();
        }
        this.currentModelName = currentModelName;
    }

    @ZenMethod
    public void addAnimation(String animationName) {
        this.animations.add(new AnimationCT(animationName, false));
    }

    @ZenMethod
    public void addAnimation(String animationName, boolean loop) {
        this.animations.add(new AnimationCT(animationName, loop));
    }

    @ZenMethod
    public void setAnimation(String animationName) {
        this.animations.clear();
        this.addAnimation(animationName);
    }

    @ZenMethod
    public void setAnimation(String animationName, boolean loop) {
        this.animations.clear();
        this.addAnimation(animationName, loop);
    }

    @ZenGetter(value="currentModelName")
    public String getCurrentModelName() {
        return this.currentModelName;
    }

    @ZenGetter(value="transitionLengthTicks")
    public double getTransitionLengthTicks() {
        return this.event.getController().transitionLengthTicks;
    }

    @ZenSetter(value="transitionLengthTicks")
    public void setTransitionLengthTicks(double transitionLengthTicks) {
        this.event.getController().transitionLengthTicks = transitionLengthTicks;
    }

    @ZenGetter(value="playState")
    public int getPlayState() {
        return this.playState;
    }

    @ZenSetter(value="playState")
    public void setPlayState(int playState) {
        this.playState = playState;
    }

    @Nullable
    @ZenGetter(value="currentAnimationName")
    public String getCurrentAnimationName() {
        Animation current = this.event.getController().getCurrentAnimation();
        return current == null ? null : current.animationName;
    }

    @ZenGetter(value="animationSpeed")
    public double getAnimationSpeed() {
        return this.event.getController().getAnimationSpeed();
    }

    @ZenGetter(value="animationTick")
    public double getAnimationTick() {
        return this.event.getAnimationTick();
    }

    @ZenGetter(value="animationState")
    public int getAnimationState() {
        int n;
        switch (this.event.getController().getAnimationState()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Running: {
                n = 0;
                break;
            }
            case Transitioning: {
                n = 1;
                break;
            }
            case Stopped: {
                n = 2;
            }
        }
        return n;
    }

    @ZenGetter(value="limbSwing")
    public float getLimbSwing() {
        return this.event.getLimbSwing();
    }

    @ZenGetter(value="limbSwingAmount")
    public float getLimbSwingAmount() {
        return this.event.getLimbSwingAmount();
    }

    @ZenGetter(value="partialTick")
    public float getPartialTick() {
        return this.event.getPartialTick();
    }

    @ZenGetter(value="moving")
    public boolean isMoving() {
        return this.event.isMoving();
    }

    public List<AnimationCT> getAnimations() {
        return this.animations;
    }

    public static final class AnimationCT {
        private final String animationName;
        private final boolean loop;

        public AnimationCT(String animationName, boolean loop) {
            this.animationName = animationName;
            this.loop = loop;
        }

        public String toString() {
            return "AnimationCT[" + "animationName=" + this.animationName + "," + "loop=" + this.loop + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.animationName != null ? this.animationName.hashCode() : 0);
            result = 31 * result + (this.loop ? 1 : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((AnimationCT)arg0).animationName, this.animationName)) {
                return false;
            }
            return ((AnimationCT)arg0).loop == this.loop;
            {
            }
        }

        public String animationName() {
            return this.animationName;
        }

        public boolean loop() {
            return this.loop;
        }
    }
}

