/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotNormal;
import appeng.container.slot.SlotRestrictedInput;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.util.IAEFluidTank;
import appeng.helpers.InventoryAction;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import github.kasuminova.mmce.common.tile.MEPatternProvider;
import github.kasuminova.mmce.common.util.AEFluidInventoryUpgradeable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;

public class ContainerMEPatternProvider
extends AEBaseContainer
implements IFluidSyncContainer {
    protected final FluidSyncHelper tankSync;
    private final MEPatternProvider owner;

    public ContainerMEPatternProvider(MEPatternProvider owner, EntityPlayer player) {
        super(player.field_71071_by, (Object)owner);
        this.owner = owner;
        this.tankSync = new FluidSyncHelper((IAEFluidTank)owner.getSubFluidHandler(), 0);
        this.bindPlayerInventory(this.getInventoryPlayer(), 0, 114);
        AppEngInternalInventory patterns = owner.getPatterns();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a((Slot)new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, (IItemHandler)patterns, row * 9 + col, 8 + col * 18, 28 + row * 18, this.getInventoryPlayer()));
            }
        }
        AppEngInternalInventory subItemHandler = owner.getSubItemHandler();
        for (int i = 0; i < 2; ++i) {
            this.func_75146_a((Slot)new SlotNormal((IItemHandler)subItemHandler, i, 181 + i * 18, 172));
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        ItemStack heldCopy = held.func_77946_l();
        heldCopy.func_190920_e(1);
        IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)heldCopy);
        if (fh == null) {
            return;
        }
        AEFluidInventoryUpgradeable fluidHandler = this.owner.getSubFluidHandler();
        IAEFluidStack fluidInSlot = fluidHandler.getFluidInSlot(0);
        if (action == InventoryAction.FILL_ITEM && fluidInSlot != null) {
            IAEFluidStack stack = fluidInSlot.copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), false);
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedFluidContainer = held.func_77946_l();
                copiedFluidContainer.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copiedFluidContainer);
                if (fh == null) continue;
                FluidStack extractableFluid = fluidHandler.drain(((IAEFluidStack)stack.setStackSize((long)amountAllowed)).getFluidStack(), false);
                if (extractableFluid != null && extractableFluid.amount != 0) {
                    int maxCanFill = fh.fill(extractableFluid, false);
                    if (maxCanFill > 0) {
                        FluidStack extractedFluid = fluidHandler.drain(extractableFluid, true);
                        fh.fill(extractedFluid, true);
                    }
                    if (held.func_190916_E() == 1) {
                        player.field_71071_by.func_70437_b(fh.getContainer());
                        continue;
                    }
                    player.field_71071_by.func_70445_o().func_190918_g(1);
                    if (player.field_71071_by.func_70441_a(fh.getContainer())) continue;
                    player.func_71019_a(fh.getContainer(), false);
                    continue;
                }
                break;
            }
        } else if (action == InventoryAction.EMPTY_ITEM) {
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedFluidContainer = held.func_77946_l();
                copiedFluidContainer.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copiedFluidContainer);
                if (fh == null) continue;
                FluidStack maxCanDrain = fh.drain(fluidHandler.getTankProperties()[slot].getCapacity(), false);
                if (maxCanDrain != null) {
                    fh.drain(maxCanDrain, true);
                    fluidHandler.fill(maxCanDrain, true);
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(fh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(fh.getContainer())) continue;
                player.func_71019_a(fh.getContainer(), false);
            }
        }
        this.updateHeld(player);
    }

    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        this.tankSync.readPacket(fluids);
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.tankSync.sendDiff((Iterable)this.field_75149_d);
        }
        super.func_75142_b();
    }

    public MEPatternProvider getOwner() {
        return this.owner;
    }
}

