/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.container.slot.SlotRestrictedInput;
import appeng.fluids.container.ContainerFluidConfigurable;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import github.kasuminova.mmce.common.tile.MEFluidInputBus;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.items.IItemHandler;

public class ContainerMEFluidInputBus
extends ContainerFluidConfigurable {
    private final MEFluidInputBus owner;
    private final FluidSyncHelper tankSync;

    public ContainerMEFluidInputBus(MEFluidInputBus owner, EntityPlayer player) {
        super(player.field_71071_by, (IUpgradeableHost)owner);
        this.owner = owner;
        this.tankSync = new FluidSyncHelper(owner.getTanks(), 9);
    }

    public MEFluidInputBus getOwner() {
        return this.owner;
    }

    protected int getHeight() {
        return 231;
    }

    public IAEFluidTank getFluidConfigInventory() {
        return this.owner.getConfig();
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.tankSync.sendDiff((Iterable)this.field_75149_d);
        }
        super.func_75142_b();
    }

    protected void setupConfig() {
        this.setupUpgrades();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    protected void setupUpgrades() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        for (int i = 0; i < this.availableUpgrades(); ++i) {
            this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, i, 187, 8 + 18 * i, this.getInventoryPlayer()).setNotDraggable());
        }
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        super.receiveFluidSlots(fluids);
        this.tankSync.readPacket(fluids);
    }

    protected boolean supportCapacity() {
        return false;
    }

    public int availableUpgrades() {
        return 5;
    }

    public boolean hasToolbox() {
        return false;
    }
}

