/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.concurrent;

import github.kasuminova.mmce.common.util.Sides;
import github.kasuminova.mmce.common.util.concurrent.Action;
import github.kasuminova.mmce.common.util.concurrent.ActionExecutor;
import github.kasuminova.mmce.common.util.concurrent.CustomForkJoinWorkerThreadFactory;
import github.kasuminova.mmce.common.util.concurrent.CustomThreadFactory;
import github.kasuminova.mmce.common.util.concurrent.ExecuteGroup;
import github.kasuminova.mmce.common.util.concurrent.Queues;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import io.netty.util.internal.ThrowableUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.Queue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.relauncher.Side;

public class TaskExecutor {
    public static final int THREAD_COUNT = Math.min(Math.max(Runtime.getRuntime().availableProcessors() / 4, 4), 8);
    public static final int CLIENT_THREAD_COUNT = Math.min(Math.max(Runtime.getRuntime().availableProcessors() / 2, 4), 16);
    public static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(THREAD_COUNT, THREAD_COUNT, 5000L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new CustomThreadFactory("MMCE-TaskExecutor-%s", (ThreadGroup)SidedThreadGroups.SERVER));
    public static final ForkJoinPool FORK_JOIN_POOL = new ForkJoinPool(Sides.isClient() ? CLIENT_THREAD_COUNT : THREAD_COUNT, new CustomForkJoinWorkerThreadFactory("MMCE-ForkJoinPool-worker-%s"), null, true);
    public static long totalExecuted = 0L;
    public static long taskUsedTime = 0L;
    public static long totalUsedTime = 0L;
    public static long executedCount = 0L;
    public static long tickExisted = 0L;
    private final Queue<ActionExecutor> submitted = Queues.createConcurrentQueue();
    private final Queue<ActionExecutor> executors = Queues.createConcurrentQueue();
    private final Long2ObjectMap<ExecuteGroup> executeGroups = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final Queue<ForkJoinTask<?>> forkJoinTasks = Queues.createConcurrentQueue();
    private final Queue<Action> mainThreadActions = Queues.createConcurrentQueue();
    private final Queue<TileEntitySynchronized> requireUpdateTEQueue = Queues.createConcurrentQueue();
    private final Queue<TileEntitySynchronized> requireMarkNoUpdateTEQueue = Queues.createConcurrentQueue();
    private final TaskSubmitter submitter = new TaskSubmitter();
    private volatile boolean inTick = false;
    private volatile boolean shouldUseForkJoinPool = false;

    private static void loopWait(long nanos) {
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < nanos) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void init() {
        THREAD_POOL.prestartAllCoreThreads();
        this.submitter.start();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        switch (event.phase) {
            case START: {
                this.inTick = true;
                this.submitter.unpark();
                break;
            }
            default: {
                this.inTick = false;
                ++tickExisted;
            }
        }
        int executed = this.executeActions();
        if (executed > 0) {
            totalExecuted += (long)executed;
            ++executedCount;
        }
        this.executeGroups.clear();
        this.checkShouldUseForkJoinPool();
    }

    private void checkShouldUseForkJoinPool() {
        if (tickExisted % 20L != 0L) {
            return;
        }
        if (this.shouldUseForkJoinPool) {
            if (!this.shouldUseForkJoinPool()) {
                ModularMachinery.log.warn("The thread pool has been re-switched to ThreadPoolExecutor (below the limit of 1500).");
                this.shouldUseForkJoinPool = false;
            }
            return;
        }
        if (this.shouldUseForkJoinPool()) {
            ModularMachinery.log.warn("The thread pool has now been replaced with a ForkJoinPool due to too many tasks in a single commit (Limit 1500).");
            this.shouldUseForkJoinPool = true;
        }
    }

    private boolean shouldUseForkJoinPool() {
        long executedAvgPerExecution = executedCount == 0L ? 0L : totalExecuted / executedCount;
        return executedAvgPerExecution >= 1500L;
    }

    public int executeActions() {
        int executed = 0;
        long time = System.nanoTime() / 1000L;
        this.submitTask();
        executed += this.spinAwaitActionExecutor();
        executed += this.executeMainThreadActions();
        this.updateTileEntity();
        if (!this.submitted.isEmpty()) {
            executed += this.executeActions();
        }
        totalUsedTime += System.nanoTime() / 1000L - time;
        return executed;
    }

    private int executeMainThreadActions() {
        Action action;
        int executed = 0;
        if (this.mainThreadActions.isEmpty()) {
            return executed;
        }
        while ((action = this.mainThreadActions.poll()) != null) {
            try {
                action.doAction();
            }
            catch (Throwable e) {
                ModularMachinery.log.warn("An error occurred during synchronous task execution!");
                ModularMachinery.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
            }
            ++executed;
        }
        return executed;
    }

    private int spinAwaitActionExecutor() {
        ActionExecutor executor;
        int executed = 0;
        while ((executor = this.submitted.poll()) != null) {
            while (!executor.isCompleted) {
                executed += this.executeMainThreadActions();
                this.updateTileEntity();
                if (executor.isCompleted) continue;
                TaskExecutor.loopWait(100000L);
            }
            taskUsedTime += (long)executor.usedTime;
            ++executed;
        }
        return executed;
    }

    private void updateTileEntity() {
        TileEntitySynchronized te;
        if (this.requireUpdateTEQueue.isEmpty() && this.requireMarkNoUpdateTEQueue.isEmpty()) {
            return;
        }
        while ((te = this.requireUpdateTEQueue.poll()) != null) {
            te.markForUpdate();
        }
        while ((te = this.requireMarkNoUpdateTEQueue.poll()) != null) {
            te.markNoUpdate();
        }
    }

    public ActionExecutor addTask(Action action) {
        return this.addTask(action, 0);
    }

    public ActionExecutor addTask(Action action, int priority) {
        ActionExecutor actionExecutor = new ActionExecutor(action, priority);
        this.executors.offer(actionExecutor);
        return actionExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionExecutor addExecuteGroupTask(Action action, long groupId) {
        ExecuteGroup group = (ExecuteGroup)this.executeGroups.get(groupId);
        if (group == null) {
            Long2ObjectMap<ExecuteGroup> long2ObjectMap = this.executeGroups;
            synchronized (long2ObjectMap) {
                group = (ExecuteGroup)this.executeGroups.get(groupId);
                if (group == null) {
                    group = new ExecuteGroup(groupId);
                    this.executeGroups.put(groupId, (Object)group);
                }
            }
        }
        return group.offer(new ActionExecutor(action));
    }

    public <T> ForkJoinTask<T> submitForkJoinTask(ForkJoinTask<T> task) {
        this.forkJoinTasks.offer(task);
        return task;
    }

    public void addSyncTask(Action action) {
        this.mainThreadActions.offer(action);
    }

    public void addTEUpdateTask(TileEntitySynchronized te) {
        this.requireUpdateTEQueue.offer(te);
    }

    public void addTEMarkNoUpdateTask(TileEntitySynchronized te) {
        this.requireMarkNoUpdateTEQueue.offer(te);
    }

    private void execute(ActionExecutor executor) {
        if (this.shouldUseForkJoinPool) {
            FORK_JOIN_POOL.execute(executor);
        } else {
            THREAD_POOL.execute(executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void submitTask() {
        ForkJoinTask<?> forkJoinTask;
        ActionExecutor executor;
        while ((executor = this.executors.poll()) != null) {
            this.execute(executor);
            this.submitted.offer(executor);
        }
        while ((forkJoinTask = this.forkJoinTasks.poll()) != null) {
            FORK_JOIN_POOL.submit(forkJoinTask);
        }
        Long2ObjectMap<ExecuteGroup> long2ObjectMap = this.executeGroups;
        synchronized (long2ObjectMap) {
            LongArrayList toRemove = new LongArrayList();
            for (ExecuteGroup group : this.executeGroups.values()) {
                if (group.isSubmitted()) continue;
                if (group.isEmpty()) {
                    toRemove.add(group.getGroupId());
                    continue;
                }
                ActionExecutor groupExecutor = new ActionExecutor(() -> {
                    ActionExecutor actionExecutor;
                    while ((actionExecutor = group.poll()) != null) {
                        actionExecutor.run();
                    }
                    group.setSubmitted(false);
                });
                group.setSubmitted(true);
                this.execute(groupExecutor);
                this.submitted.offer(groupExecutor);
            }
            LongListIterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.executeGroups.remove(it.nextLong());
            }
        }
    }

    public class TaskSubmitter
    implements Runnable {
        public Thread thread = null;

        public void start() {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.thread = new Thread(this);
            this.thread.setName("MMCE-TaskSubmitter");
            this.thread.start();
        }

        public void unpark() {
            if (this.thread != null) {
                LockSupport.unpark(this.thread);
            }
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                if (TaskExecutor.this.inTick) {
                    if (!(TaskExecutor.this.executors.isEmpty() && TaskExecutor.this.executeGroups.isEmpty() && TaskExecutor.this.forkJoinTasks.isEmpty())) {
                        TaskExecutor.this.submitTask();
                        continue;
                    }
                    LockSupport.parkNanos(10000L);
                    continue;
                }
                LockSupport.park();
            }
        }
    }
}

