/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.concurrent;

import github.kasuminova.mmce.common.concurrent.RecipeCraftingContextPool;
import github.kasuminova.mmce.common.util.concurrent.TimeRecordingTask;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;

public class RecipeSearchTask
extends TimeRecordingTask<RecipeCraftingContext> {
    protected final TileMultiblockMachineController controller;
    protected final DynamicMachine currentMachine;
    protected final int maxParallelism;
    protected final Iterable<MachineRecipe> recipeList;
    private final RecipeThread thread;
    protected CraftingStatus status = CraftingStatus.IDLE;

    public RecipeSearchTask(TileMultiblockMachineController controller, DynamicMachine currentMachine, int maxParallelism, Iterable<MachineRecipe> recipeList, RecipeThread thread) {
        this.controller = controller;
        this.currentMachine = currentMachine;
        this.maxParallelism = maxParallelism;
        this.recipeList = recipeList;
        this.thread = thread;
    }

    @Override
    protected RecipeCraftingContext computeTask() {
        DynamicMachine foundMachine = this.controller.getFoundMachine();
        if (foundMachine == null) {
            return null;
        }
        MachineRecipe highestValidity = null;
        RecipeCraftingContext.CraftingCheckResult highestValidityResult = null;
        float validity = 0.0f;
        for (MachineRecipe recipe : this.recipeList) {
            ActiveMachineRecipe activeRecipe = new ActiveMachineRecipe(recipe, this.maxParallelism);
            RecipeCraftingContext context = this.thread != null ? this.thread.createContext(activeRecipe) : this.controller.createContext(activeRecipe);
            RecipeCraftingContext.CraftingCheckResult result = this.controller.onCheck(context);
            if (result.isSuccess()) {
                foundMachine = this.controller.getFoundMachine();
                if (foundMachine == null || !foundMachine.equals(this.currentMachine)) {
                    RecipeCraftingContextPool.returnCtx(context);
                    return null;
                }
                return context;
            }
            if (highestValidity == null || result.getValidity() > validity) {
                highestValidity = recipe;
                highestValidityResult = result;
                validity = result.getValidity();
            }
            RecipeCraftingContextPool.returnCtx(context);
        }
        this.status = highestValidity != null ? CraftingStatus.failure(highestValidityResult.getFirstErrorMessage("")) : CraftingStatus.failure(TileMultiblockMachineController.Type.NO_RECIPE.getUnlocalizedDescription());
        return null;
    }

    public CraftingStatus getStatus() {
        return this.status;
    }

    public DynamicMachine getCurrentMachine() {
        return this.currentMachine;
    }
}

