/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.concurrent;

import github.kasuminova.mmce.common.concurrent.RecipeCraftingContextPool;
import github.kasuminova.mmce.common.concurrent.RecipeSearchTask;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import net.minecraft.util.ResourceLocation;

public class FactoryRecipeSearchTask
extends RecipeSearchTask {
    private final FactoryRecipeThread thread;
    private final Object2IntArrayMap<ResourceLocation> runningRecipes = new Object2IntArrayMap();
    private final TileFactoryController factory;

    public FactoryRecipeSearchTask(TileFactoryController controller, DynamicMachine currentMachine, int maxParallelism, Iterable<MachineRecipe> recipeList, FactoryRecipeThread thread, ActiveMachineRecipe[] running) {
        super(controller, currentMachine, maxParallelism, recipeList, thread);
        this.factory = controller;
        for (ActiveMachineRecipe recipe : running) {
            ResourceLocation registryName = recipe.getRecipe().getRegistryName();
            int prevCount = this.runningRecipes.getInt((Object)registryName);
            this.runningRecipes.put((Object)registryName, prevCount + 1);
        }
        this.thread = thread;
    }

    @Override
    protected RecipeCraftingContext computeTask() {
        TileFactoryController factory = this.factory;
        DynamicMachine foundMachine = factory.getFoundMachine();
        if (foundMachine == null) {
            return null;
        }
        MachineRecipe highestValidity = null;
        RecipeCraftingContext.CraftingCheckResult highestValidityResult = null;
        float validity = 0.0f;
        for (MachineRecipe recipe : this.recipeList) {
            if (!this.canCheck(recipe)) continue;
            ActiveMachineRecipe activeRecipe = new ActiveMachineRecipe(recipe, this.maxParallelism);
            RecipeCraftingContext context = this.thread != null ? this.thread.createContext(activeRecipe) : this.controller.createContext(activeRecipe);
            RecipeCraftingContext.CraftingCheckResult result = factory.onCheck(context);
            if (result.isSuccess()) {
                foundMachine = factory.getFoundMachine();
                if (foundMachine == null || !foundMachine.equals(this.currentMachine)) {
                    RecipeCraftingContextPool.returnCtx(context);
                    return null;
                }
                return context;
            }
            if (highestValidity == null || result.getValidity() > validity) {
                highestValidity = recipe;
                highestValidityResult = result;
                validity = result.getValidity();
            }
            RecipeCraftingContextPool.returnCtx(context);
        }
        this.status = highestValidity != null ? CraftingStatus.failure(highestValidityResult.getFirstErrorMessage("")) : CraftingStatus.failure(TileMultiblockMachineController.Type.NO_RECIPE.getUnlocalizedDescription());
        return null;
    }

    private boolean canCheck(MachineRecipe recipe) {
        String recipeRequiredName = recipe.getThreadName();
        if (!(recipeRequiredName.isEmpty() || this.thread != null && this.thread.getThreadName().equals(recipeRequiredName))) {
            return false;
        }
        int maxThreads = recipe.getMaxThreads();
        return maxThreads == -1 || this.runningRecipes.getInt((Object)recipe.getRegistryName()) < maxThreads;
    }
}

