/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.world;

import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import github.kasuminova.mmce.client.model.DynamicMachineModelRegistry;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModelHider {
    @SideOnly(value=Side.CLIENT)
    public static void hideOrShowBlocks(TileMultiblockMachineController ctrl) {
        if (Mods.MBD.isPresent()) {
            BlockModelHider.hideOrShowBlocksMBD(ctrl);
        } else if (Mods.COMPONENT_MODEL_HIDER.isPresent()) {
            BlockModelHider.hideOrShowBlocksPlugin(ctrl);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onWorldUnload(World world) {
        if (Minecraft.func_71410_x().field_71441_e == world) {
            if (Mods.MBD.isPresent()) {
                BlockModelHider.onWorldUnloadMBD();
            } else if (Mods.COMPONENT_MODEL_HIDER.isPresent()) {
                BlockModelHider.onWorldUnloadPlugin();
            }
        }
    }

    @Optional.Method(modid="multiblocked")
    public static void onWorldUnloadMBD() {
        MultiblockWorldSavedData.clearDisabled();
    }

    @Optional.Method(modid="component_model_hider")
    public static void onWorldUnloadPlugin() {
        MultiblockWorldSavedData.clearDisabled();
    }

    @Optional.Method(modid="multiblocked")
    private static void hideOrShowBlocksMBD(TileMultiblockMachineController ctrl) {
        TaggedPositionBlockArray foundPattern;
        DynamicMachine foundMachine = ctrl.getFoundMachine();
        BlockPos pos = ctrl.func_174877_v();
        if (ctrl.func_145837_r() || foundMachine == null || DynamicMachineModelRegistry.INSTANCE.getMachineDefaultModel(foundMachine) == null) {
            MultiblockWorldSavedData.removeDisableModel((BlockPos)pos);
            return;
        }
        if (!MultiblockWorldSavedData.multiDisabled.containsKey(pos) && (foundPattern = ctrl.getFoundPattern()) != null) {
            LinkedList<BlockPos> transformed = new LinkedList<BlockPos>();
            transformed.add(pos);
            if (foundMachine.isHideComponentsWhenFormed()) {
                for (BlockPos compPos : foundPattern.getPattern().keySet()) {
                    BlockPos add = compPos.func_177971_a((Vec3i)pos);
                    transformed.add(add);
                }
            }
            MultiblockWorldSavedData.addDisableModel((BlockPos)pos, transformed);
        }
    }

    @Optional.Method(modid="component_model_hider")
    private static void hideOrShowBlocksPlugin(TileMultiblockMachineController ctrl) {
        TaggedPositionBlockArray foundPattern;
        DynamicMachine foundMachine = ctrl.getFoundMachine();
        BlockPos pos = ctrl.func_174877_v();
        if (ctrl.func_145837_r() || foundMachine == null || DynamicMachineModelRegistry.INSTANCE.getMachineDefaultModel(foundMachine) == null) {
            MultiblockWorldSavedData.removeDisableModel((BlockPos)pos);
            return;
        }
        if (!MultiblockWorldSavedData.multiDisabled.containsKey(pos) && (foundPattern = ctrl.getFoundPattern()) != null) {
            LinkedList<BlockPos> transformed = new LinkedList<BlockPos>();
            transformed.add(pos);
            if (foundMachine.isHideComponentsWhenFormed()) {
                for (BlockPos compPos : foundPattern.getPattern().keySet()) {
                    BlockPos add = compPos.func_177971_a((Vec3i)pos);
                    transformed.add(add);
                }
            }
            MultiblockWorldSavedData.addDisableModel((BlockPos)pos, transformed);
        }
    }
}

