/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.util;

import hellfirepvp.modularmachinery.common.modifier.AbstractModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.SingleBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public final class UpgradeIngredient {
    private final ItemStack descStack;
    private final AbstractModifierReplacement replacement;
    private final Map<BlockPos, BlockArray.BlockInformation> replacementPattern;

    public UpgradeIngredient(ItemStack descStack, AbstractModifierReplacement replacement, Map<BlockPos, BlockArray.BlockInformation> replacementPattern) {
        this.descStack = descStack;
        this.replacement = replacement;
        this.replacementPattern = replacementPattern;
    }

    public static UpgradeIngredient of(ItemStack descStack, AbstractModifierReplacement replacement) {
        Map<BlockPos, BlockArray.BlockInformation> replacementPattern;
        if (replacement instanceof SingleBlockModifierReplacement) {
            SingleBlockModifierReplacement r = (SingleBlockModifierReplacement)replacement;
            replacementPattern = Collections.singletonMap(r.getPos(), r.getBlockInformation());
        } else if (replacement instanceof MultiBlockModifierReplacement) {
            MultiBlockModifierReplacement r = (MultiBlockModifierReplacement)replacement;
            replacementPattern = r.getBlockArray().getPattern();
        } else {
            replacementPattern = Collections.emptyMap();
        }
        return new UpgradeIngredient(descStack, replacement, replacementPattern);
    }

    public ItemStack descStack() {
        return this.descStack;
    }

    public AbstractModifierReplacement replacement() {
        return this.replacement;
    }

    public Map<BlockPos, BlockArray.BlockInformation> replacementPattern() {
        return this.replacementPattern;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UpgradeIngredient that = (UpgradeIngredient)obj;
        return Objects.equals(this.descStack, that.descStack) && Objects.equals(this.replacement, that.replacement) && Objects.equals(this.replacementPattern, that.replacementPattern);
    }

    public int hashCode() {
        return Objects.hash(this.descStack, this.replacement, this.replacementPattern);
    }

    public String toString() {
        return "UpgradeIngredient[descStack=" + this.descStack + ", replacement=" + this.replacement + ", replacementPattern=" + this.replacementPattern + ']';
    }
}

