/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.resource;

import com.google.common.base.Preconditions;
import github.kasuminova.mmce.client.model.DynamicMachineModelRegistry;
import github.kasuminova.mmce.client.model.MachineControllerModel;
import hellfirepvp.modularmachinery.ModularMachinery;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import software.bernie.geckolib3.file.AnimationFile;
import software.bernie.geckolib3.file.AnimationFileLoader;
import software.bernie.geckolib3.file.GeoModelLoader;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.shadowed.eliotlash.molang.MolangParser;

public class GeoModelExternalLoader
implements ISelectiveResourceReloadListener {
    public static final GeoModelExternalLoader INSTANCE = new GeoModelExternalLoader();
    private final GeoModelLoader geoModelLoader = new GeoModelLoader();
    private final AnimationFileLoader animationFileLoader = new AnimationFileLoader();
    private final MolangParser molangParser = new MolangParser();
    private volatile Map<ResourceLocation, GeoModel> geoModels = new ConcurrentHashMap<ResourceLocation, GeoModel>();
    private volatile Map<ResourceLocation, AnimationFile> animations = new ConcurrentHashMap<ResourceLocation, AnimationFile>();
    private volatile IResourceManager modelSource = null;

    private GeoModelExternalLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadAllModelAndAnimations(IResourceManager resourceManager) {
        this.modelSource = resourceManager;
        ConcurrentHashMap<ResourceLocation, GeoModel> geoModels = new ConcurrentHashMap<ResourceLocation, GeoModel>();
        ConcurrentHashMap<ResourceLocation, AnimationFile> animations = new ConcurrentHashMap<ResourceLocation, AnimationFile>();
        Collection<MachineControllerModel> models = DynamicMachineModelRegistry.INSTANCE.getAllModels();
        models.parallelStream().forEach(model -> {
            ResourceLocation animationFileLocation = model.getAnimationFileLocation();
            try {
                resourceManager.func_110536_a(animationFileLocation);
                AnimationFile animationFile = this.animationFileLoader.loadAllAnimations(this.molangParser, animationFileLocation, resourceManager);
                if (animationFile != null) {
                    animations.put(animationFileLocation, animationFile);
                    ModularMachinery.log.debug("[MM-GeoModelExternalLoader] Loaded animation file: {}", (Object)animationFileLocation);
                }
            }
            catch (Exception e) {
                ModularMachinery.log.warn("[MM-GeoModelExternalLoader] Failed to load animation file: {}", (Object)animationFileLocation, (Object)e);
            }
            ResourceLocation modelLocation = model.getModelLocation();
            try {
                resourceManager.func_110536_a(modelLocation);
                GeoModel geoModel = this.geoModelLoader.loadModel(resourceManager, modelLocation);
                if (geoModel != null) {
                    geoModels.put(modelLocation, geoModel);
                    ModularMachinery.log.debug("[MM-GeoModelExternalLoader] Loaded model file: {}", (Object)modelLocation);
                }
            }
            catch (Exception e) {
                ModularMachinery.log.warn("[MM-GeoModelExternalLoader] Failed to load model file: {}", (Object)modelLocation, (Object)e);
            }
        });
        Map<ResourceLocation, GeoModel> oldGeoModels = this.geoModels;
        Map<ResourceLocation, AnimationFile> oldAnimations = this.animations;
        GeoModelExternalLoader geoModelExternalLoader = this;
        synchronized (geoModelExternalLoader) {
            this.animations = animations;
            this.geoModels = geoModels;
        }
        oldGeoModels.clear();
        oldAnimations.clear();
        ModularMachinery.log.info("[MM-GeoModelExternalLoader] Loaded {} animation files.", (Object)animations.size());
        ModularMachinery.log.info("[MM-GeoModelExternalLoader] Loaded {} model files.", (Object)geoModels.size());
    }

    public synchronized GeoModel getModel(ResourceLocation location) {
        GeoModel geoModel = this.geoModels.get(location);
        return (GeoModel)Preconditions.checkNotNull((Object)geoModel, (Object)("Model file not found: " + location.toString()));
    }

    public synchronized GeoModel load(ResourceLocation location) {
        GeoModel model = this.geoModels.get(location);
        if (model == null) {
            throw new NullPointerException("Model file not found: " + location.toString());
        }
        try {
            return this.geoModelLoader.loadModel(this.modelSource, location);
        }
        catch (Throwable e) {
            ModularMachinery.log.warn("[MM-GeoModelExternalLoader] Failed to load model file: {}", (Object)location, (Object)e);
            return null;
        }
    }

    public synchronized AnimationFile getAnimation(ResourceLocation location) {
        AnimationFile geoModel = this.animations.get(location);
        return (AnimationFile)Preconditions.checkNotNull((Object)geoModel, (Object)("Animation file not found: " + location.toString()));
    }

    public synchronized void onReload() {
        CompletableFuture.runAsync(() -> this.loadAllModelAndAnimations(Minecraft.func_71410_x().func_110442_L()));
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.MODELS)) {
            this.loadAllModelAndAnimations(resourceManager);
        }
    }
}

