/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.renderer;

import com.cleanroommc.client.shader.ShaderManager;
import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.client.model.StaticModelBones;
import github.kasuminova.mmce.client.renderer.GeoModelRenderTask;
import github.kasuminova.mmce.client.util.BufferProvider;
import github.kasuminova.mmce.client.util.MatrixStack;
import github.kasuminova.mmce.common.concurrent.TaskExecutor;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.geo.render.built.GeoQuad;
import software.bernie.geckolib3.geo.render.built.GeoVertex;

public class MachineControllerRenderer
extends TileEntitySpecialRenderer<TileMultiblockMachineController> {
    public static final MachineControllerRenderer INSTANCE = new MachineControllerRenderer();
    public static final VertexFormat VERTEX_FORMAT = DefaultVertexFormats.field_181712_l;
    protected static final ThreadLocal<MatrixStack> MATRIX_STACK = ThreadLocal.withInitial(MatrixStack::new);
    protected static final ThreadLocal<StaticModelBones> STATIC_MODEL_BONES = new ThreadLocal();
    protected final Map<TileMultiblockMachineController, GeoModelRenderTask> tasks = new WeakHashMap<TileMultiblockMachineController, GeoModelRenderTask>();

    protected MachineControllerRenderer() {
    }

    protected static void rotateBlock(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    protected static void rotateBlockMatrix(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                MATRIX_STACK.get().rotateY((float)Math.PI);
                break;
            }
            case WEST: {
                MATRIX_STACK.get().rotateY(1.5707964f);
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                MATRIX_STACK.get().rotateY(4.712389f);
            }
        }
    }

    public static boolean shouldUseBloom() {
        return Mods.GREGTECHCEU.isPresent() || Mods.LUMENIZED.isPresent();
    }

    public void render(TileMultiblockMachineController te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.render(te, x, y, z, partialTicks, destroyStage);
    }

    public void renderDummy(TileMultiblockMachineController ctrl, MachineControllerModel model) {
        this.field_147501_a.field_147553_e.func_110577_a(model.getTextureLocation());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.01f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        this.renderWithDefault(model, ctrl);
        GlStateManager.func_179121_F();
    }

    @Optional.Method(modid="geckolib3")
    public void render(TileMultiblockMachineController tile, double x, double y, double z, float partialTicks, int destroyStage) {
        MachineControllerModel modelProvider = tile.getCurrentModel();
        if (modelProvider == null) {
            return;
        }
        this.render(modelProvider, tile, x, y, z, partialTicks);
    }

    @Optional.Method(modid="geckolib3")
    public void render(MachineControllerModel modelProvider, TileMultiblockMachineController tile, double x, double y, double z, float partialTicks) {
        this.renderWithBuffer(tile);
    }

    @Optional.Method(modid="geckolib3")
    private void renderWithBuffer(TileMultiblockMachineController animatable) {
        GeoModelRenderTask task = this.getTask(animatable);
        if (MachineControllerRenderer.shouldUseBloom() && !ShaderManager.isOptifineShaderPackLoaded()) {
            task.renderDefault();
            task.setAvailable(true);
        } else {
            task.renderAll();
        }
        if (task.shouldReRenderStatic()) {
            this.render(animatable, task, true);
        }
    }

    @Optional.Method(modid="geckolib3")
    private void renderWithDefault(MachineControllerModel modelProvider, TileMultiblockMachineController ctrl) {
        GeoModel model = modelProvider.getModel();
        modelProvider.setLivingAnimations(ctrl, ctrl.hashCode());
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, VERTEX_FORMAT);
        for (GeoBone group : model.topLevelBones) {
            this.renderRecursively(builder, group, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Optional.Method(modid="geckolib3")
    public void render(TileMultiblockMachineController tile, BufferProvider bufferProvider, boolean renderStatic) {
        MachineControllerModel modelProvider = tile.getCurrentModel();
        if (modelProvider == null) {
            return;
        }
        MachineControllerModel renderInst = modelProvider.getRenderInstance();
        GeoModel model = renderInst.getModel();
        STATIC_MODEL_BONES.set(renderInst.getStaticModelBones());
        GeoModel geoModel = model;
        synchronized (geoModel) {
            renderInst.setLivingAnimations(tile, tile.hashCode());
            bufferProvider.begin(renderStatic);
            MatrixStack matrixStack = MATRIX_STACK.get();
            BlockPos pos = tile.func_174877_v();
            matrixStack.push();
            matrixStack.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            matrixStack.translate(0.0f, 0.01f, 0.0f);
            matrixStack.translate(0.5f, 0.0f, 0.5f);
            MachineControllerRenderer.rotateBlockMatrix(tile.getControllerRotation());
            for (GeoBone group : model.topLevelBones) {
                if (group.isHidden() && group.childBonesAreHiddenToo()) continue;
                this.renderRecursively(bufferProvider, group, 1.0f, 1.0f, 1.0f, 1.0f, false, false, renderStatic);
            }
            matrixStack.pop();
            bufferProvider.finishDrawing(renderStatic);
            renderInst.returnRenderInst();
        }
    }

    @Optional.Method(modid="geckolib3")
    public void renderRecursively(BufferBuilder buffer, GeoBone bone, float red, float green, float blue, float alpha) {
        boolean emissive = bone.name.startsWith("emissive") || bone.name.startsWith("bloom");
        boolean transparent = bone.name.startsWith("transparent") || bone.name.startsWith("emissive_transparent") || bone.name.startsWith("bloom_transparent");
        float lastBrightnessX = 0.0f;
        float lastBrightnessY = 0.0f;
        if (emissive || transparent) {
            Tessellator.func_178181_a().func_78381_a();
            if (emissive) {
                GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
                GlStateManager.func_179088_q();
                lastBrightnessX = OpenGlHelper.lastBrightnessX;
                lastBrightnessY = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            }
            if (transparent) {
                GlStateManager.func_179132_a((boolean)false);
            }
            buffer.func_181668_a(7, VERTEX_FORMAT);
        }
        MatrixStack matrixStack = MATRIX_STACK.get();
        matrixStack.push();
        matrixStack.translate(bone);
        matrixStack.moveToPivot(bone);
        matrixStack.rotate(bone);
        matrixStack.scale(bone);
        matrixStack.moveBackFromPivot(bone);
        if (!bone.isHidden()) {
            for (GeoCube cube : bone.childCubes) {
                matrixStack.push();
                this.renderCube(buffer, cube, red, green, blue, alpha);
                matrixStack.pop();
            }
        }
        if (!bone.childBonesAreHiddenToo()) {
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(buffer, childBone, red, green, blue, alpha);
            }
        }
        matrixStack.pop();
        if (emissive || transparent) {
            Tessellator.func_178181_a().func_78381_a();
            if (emissive) {
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
            }
            if (transparent) {
                GlStateManager.func_179132_a((boolean)true);
            }
            buffer.func_181668_a(7, VERTEX_FORMAT);
        }
    }

    @Optional.Method(modid="geckolib3")
    public void renderRecursively(BufferProvider bufferProvider, GeoBone bone, float red, float green, float blue, float alpha, boolean bloom, boolean transparent, boolean isStatic) {
        bloom |= bone.name.startsWith("emissive") || bone.name.startsWith("bloom");
        transparent |= bone.name.startsWith("transparent") || bone.name.startsWith("emissive_transparent") || bone.name.startsWith("bloom_transparent");
        MatrixStack matrixStack = MATRIX_STACK.get();
        matrixStack.push();
        matrixStack.translate(bone);
        matrixStack.moveToPivot(bone);
        matrixStack.rotate(bone);
        matrixStack.scale(bone);
        matrixStack.moveBackFromPivot(bone);
        if (!bone.isHidden() && (isStatic && STATIC_MODEL_BONES.get().isStaticBone(bone.name) || !isStatic && !STATIC_MODEL_BONES.get().isStaticBone(bone.name))) {
            for (GeoCube cube : bone.childCubes) {
                matrixStack.push();
                this.renderCube(bufferProvider.getBuffer(bloom, transparent, isStatic), cube, red, green, blue, alpha);
                matrixStack.pop();
            }
        }
        if (!bone.childBonesAreHiddenToo()) {
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(bufferProvider, childBone, red, green, blue, alpha, bloom, transparent, isStatic);
            }
        }
        matrixStack.pop();
    }

    @Optional.Method(modid="geckolib3")
    public void renderCube(BufferBuilder builder, GeoCube cube, float red, float green, float blue, float alpha) {
        MatrixStack matrixStack = MATRIX_STACK.get();
        matrixStack.moveToPivot(cube);
        matrixStack.rotate(cube);
        matrixStack.moveBackFromPivot(cube);
        for (GeoQuad quad : cube.quads) {
            if (quad == null) continue;
            Vector3f normal = new Vector3f((float)quad.normal.func_177958_n(), (float)quad.normal.func_177956_o(), (float)quad.normal.func_177952_p());
            matrixStack.getNormalMatrix().transform((Tuple3f)normal);
            if ((cube.size.y == 0.0f || cube.size.z == 0.0f) && normal.getX() < 0.0f) {
                normal.x *= -1.0f;
            }
            if ((cube.size.x == 0.0f || cube.size.z == 0.0f) && normal.getY() < 0.0f) {
                normal.y *= -1.0f;
            }
            if ((cube.size.x == 0.0f || cube.size.y == 0.0f) && normal.getZ() < 0.0f) {
                normal.z *= -1.0f;
            }
            for (GeoVertex vertex : quad.vertices) {
                Vector4f vector4f = new Vector4f(vertex.position.getX(), vertex.position.getY(), vertex.position.getZ(), 1.0f);
                matrixStack.getModelMatrix().transform((Tuple4f)vector4f);
                builder.func_181662_b((double)vector4f.getX(), (double)vector4f.getY(), (double)vector4f.getZ()).func_187315_a((double)vertex.textureU, (double)vertex.textureV).func_181666_a(red, green, blue, alpha).func_181663_c(normal.getX(), normal.getY(), normal.getZ()).func_181675_d();
            }
        }
    }

    @Nonnull
    public GeoModelRenderTask getTask(TileMultiblockMachineController animatable) {
        GeoModelRenderTask task = this.tasks.get(animatable);
        if (task == null) {
            task = new GeoModelRenderTask(this, animatable);
            this.tasks.put(animatable, (GeoModelRenderTask)TaskExecutor.FORK_JOIN_POOL.submit(task));
        }
        if (!task.isDone()) {
            long current = System.currentTimeMillis();
            task.join();
            long after = System.currentTimeMillis();
            if (after - current > 50L) {
                ModularMachinery.log.warn("[MMCE-AsyncRender] GeoModelRenderTask took too long to complete! ({}ms)", (Object)(after - current));
            }
        }
        return task;
    }

    public boolean isGlobalRenderer(TileMultiblockMachineController te) {
        return true;
    }

    static {
        if (Mods.GECKOLIB.isPresent()) {
            AnimationController.addModelFetcher(object -> {
                TileMultiblockMachineController ctrl;
                MachineControllerModel currentModel;
                if (object instanceof TileMultiblockMachineController && (currentModel = (ctrl = (TileMultiblockMachineController)object).getCurrentModel()) != null) {
                    return currentModel;
                }
                return null;
            });
        }
    }
}

