/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.renderer;

import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.client.model.ModelBufferSize;
import github.kasuminova.mmce.client.renderer.BloomGeoModelRenderer;
import github.kasuminova.mmce.client.renderer.ControllerModelRenderManager;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import github.kasuminova.mmce.client.renderer.RenderType;
import github.kasuminova.mmce.client.util.BufferBuilderPool;
import github.kasuminova.mmce.client.util.BufferProvider;
import github.kasuminova.mmce.common.concurrent.TaskExecutor;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import io.netty.util.internal.ThrowableUtil;
import java.util.concurrent.RecursiveAction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GeoModelRenderTask
extends RecursiveAction
implements BufferProvider {
    protected final MachineControllerRenderer renderer;
    protected final TileMultiblockMachineController ctrl;
    protected volatile BufferBuilder buffer;
    protected volatile BufferBuilder bloomBuffer;
    protected volatile BufferBuilder transparentBuffer;
    protected volatile BufferBuilder bloomTransparentBuffer;
    protected int bufferSize = 0;
    protected int bloomBufferSize = 0;
    protected int transparentBufferSize = 0;
    protected int bloomTransparentBufferSize = 0;
    protected volatile BufferBuilder staticBuffer;
    protected volatile BufferBuilder staticBloomBuffer;
    protected volatile BufferBuilder staticTransparentBuffer;
    protected volatile BufferBuilder staticBloomTransparentBuffer;
    protected int staticBufferSize = 0;
    protected int staticBloomBufferSize = 0;
    protected int staticTransparentBufferSize = 0;
    protected int staticBloomTransparentBufferSize = 0;
    protected boolean available = true;
    protected MachineControllerModel currentModel = null;

    public GeoModelRenderTask(MachineControllerRenderer renderer, TileMultiblockMachineController ctrl) {
        this.renderer = renderer;
        this.ctrl = ctrl;
        if (Mods.GREGTECHCEU.isPresent()) {
            this.registerBloomRenderer();
        } else if (Mods.LUMENIZED.isPresent()) {
            this.registerBloomRendererLumenized();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="gregtech")
    public void registerBloomRenderer() {
        BloomGeoModelRenderer.INSTANCE.registerGlobal(this.ctrl);
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="lumenized")
    public void registerBloomRendererLumenized() {
        BloomGeoModelRenderer.INSTANCE.registerGlobal(this.ctrl);
    }

    @Override
    protected synchronized void compute() {
        try {
            this.calculateBufferSize();
            this.renderer.render(this.ctrl, this, false);
        }
        catch (Throwable e) {
            ModularMachinery.log.warn("[MMCE-AsyncRender] Failed to render controller model!");
            ModularMachinery.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
        }
    }

    public void renderAll() {
        this.renderDefault();
        this.renderBloom(true);
    }

    public void renderDefault() {
        if (this.buffer == null && this.transparentBuffer == null && this.staticBuffer == null && this.staticTransparentBuffer == null) {
            return;
        }
        MachineControllerModel currentModel = this.ctrl.getCurrentModel();
        if (currentModel == null) {
            return;
        }
        ResourceLocation texture = currentModel.getTextureLocation();
        int combinedLight = this.ctrl.func_145831_w().func_175626_b(this.ctrl.func_174877_v(), 0);
        if (this.buffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(combinedLight, RenderType.DEFAULT, texture, this.buffer);
        }
        if (this.transparentBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(combinedLight, RenderType.TRANSPARENT, texture, this.transparentBuffer);
        }
        if (this.staticBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(combinedLight, RenderType.DEFAULT, texture, this.staticBuffer);
        }
        if (this.staticTransparentBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(combinedLight, RenderType.TRANSPARENT, texture, this.staticTransparentBuffer);
        }
    }

    public void renderBloom(boolean postProcessing) {
        if (this.bloomBuffer == null && this.bloomTransparentBuffer == null && this.staticBloomBuffer == null && this.staticBloomTransparentBuffer == null) {
            return;
        }
        MachineControllerModel currentModel = this.ctrl.getCurrentModel();
        if (currentModel == null) {
            return;
        }
        ResourceLocation texture = currentModel.getTextureLocation();
        if (this.bloomBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(-1, RenderType.BLOOM, texture, this.bloomBuffer);
        }
        if (this.bloomTransparentBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(-1, RenderType.BLOOM_TRANSPARENT, texture, this.bloomTransparentBuffer);
        }
        if (this.staticBloomBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(-1, RenderType.BLOOM, texture, this.staticBloomBuffer);
        }
        if (this.staticBloomTransparentBuffer != null) {
            ControllerModelRenderManager.INSTANCE.addBuffer(-1, RenderType.BLOOM_TRANSPARENT, texture, this.staticBloomTransparentBuffer);
        }
        if (postProcessing) {
            ControllerModelRenderManager.INSTANCE.addReinitializeCallback(this, () -> {
                this.reinitialize();
                ControllerModelRenderManager.INSTANCE.addToRender(this.ctrl);
                MachineControllerRenderer.INSTANCE.tasks.put(this.ctrl, (GeoModelRenderTask)TaskExecutor.FORK_JOIN_POOL.submit(this));
            });
        }
    }

    private void calculateBufferSize() {
        MachineControllerModel currentModel = this.ctrl.getCurrentModel();
        if (currentModel != null) {
            ModelBufferSize modelBufferSize = currentModel.getBufferSize();
            this.bufferSize = modelBufferSize.getBufferSize();
            this.bloomBufferSize = modelBufferSize.getBloomBufferSize();
            this.transparentBufferSize = modelBufferSize.getTransparentBufferSize();
            this.bloomTransparentBufferSize = modelBufferSize.getBloomTransparentBufferSize();
            this.staticBufferSize = modelBufferSize.getStaticBufferSize();
            this.staticBloomBufferSize = modelBufferSize.getStaticBloomBufferSize();
            this.staticTransparentBufferSize = modelBufferSize.getStaticTransparentBufferSize();
            this.staticBloomTransparentBufferSize = modelBufferSize.getStaticBloomTransparentBufferSize();
        } else {
            this.bufferSize = 0;
            this.bloomBufferSize = 0;
            this.transparentBufferSize = 0;
            this.bloomTransparentBufferSize = 0;
            this.staticBufferSize = 0;
            this.staticBloomBufferSize = 0;
            this.staticTransparentBufferSize = 0;
            this.staticBloomTransparentBufferSize = 0;
        }
    }

    @Override
    public void reinitialize() {
        this.clean();
        this.available = false;
        super.reinitialize();
    }

    @Override
    public BufferBuilder getBuffer() {
        return this.buffer;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean shouldReRenderStatic() {
        if (this.currentModel != this.ctrl.getCurrentModel()) {
            this.currentModel = this.ctrl.getCurrentModel();
            return true;
        }
        return false;
    }

    @Override
    public BufferBuilder getBuffer(boolean bloom, boolean transparent, boolean isStatic) {
        if (bloom && transparent) {
            if (isStatic) {
                if (this.staticBloomTransparentBuffer == null) {
                    this.staticBloomTransparentBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.staticBloomTransparentBufferSize, 1024));
                    this.staticBloomTransparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
                }
                return this.staticBloomTransparentBuffer;
            }
            if (this.bloomTransparentBuffer == null) {
                this.bloomTransparentBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.bloomTransparentBufferSize, 1024));
                this.bloomTransparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            return this.bloomTransparentBuffer;
        }
        if (bloom) {
            if (isStatic) {
                if (this.staticBloomBuffer == null) {
                    this.staticBloomBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.staticBloomBufferSize, 2048));
                    this.staticBloomBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
                }
                return this.staticBloomBuffer;
            }
            if (this.bloomBuffer == null) {
                this.bloomBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.bloomBufferSize, 2048));
                this.bloomBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            return this.bloomBuffer;
        }
        if (transparent) {
            if (isStatic) {
                if (this.staticTransparentBuffer == null) {
                    this.staticTransparentBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.staticTransparentBufferSize, 2048));
                    this.staticTransparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
                }
                return this.staticTransparentBuffer;
            }
            if (this.transparentBuffer == null) {
                this.transparentBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.transparentBufferSize, 2048));
                this.transparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            return this.transparentBuffer;
        }
        if (isStatic) {
            if (this.staticBuffer == null) {
                this.staticBuffer = BufferBuilderPool.borrowBuffer(Math.max(this.staticBufferSize, 4096));
                this.staticBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            return this.staticBuffer;
        }
        if (this.buffer == null) {
            this.buffer = BufferBuilderPool.borrowBuffer(Math.max(this.bufferSize, 4096));
            this.buffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
        }
        return this.buffer;
    }

    @Override
    public void begin(boolean isStatic) {
        if (isStatic) {
            if (this.staticBuffer != null) {
                this.staticBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            if (this.staticBloomBuffer != null) {
                this.staticBloomBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            if (this.staticTransparentBuffer != null) {
                this.staticTransparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            if (this.staticBloomTransparentBuffer != null) {
                this.staticBloomTransparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
            }
            return;
        }
        if (this.buffer != null) {
            this.buffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
        }
        if (this.transparentBuffer != null) {
            this.transparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
        }
        if (this.bloomBuffer != null) {
            this.bloomBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
        }
        if (this.bloomTransparentBuffer != null) {
            this.bloomTransparentBuffer.func_181668_a(7, MachineControllerRenderer.VERTEX_FORMAT);
        }
    }

    @Override
    public void finishDrawing(boolean isStatic) {
        if (isStatic) {
            if (this.staticBuffer != null) {
                this.staticBuffer.func_178977_d();
            }
            if (this.staticBloomBuffer != null) {
                this.staticBloomBuffer.func_178977_d();
            }
            if (this.staticTransparentBuffer != null) {
                this.staticTransparentBuffer.func_178977_d();
            }
            if (this.staticBloomTransparentBuffer != null) {
                this.staticBloomTransparentBuffer.func_178977_d();
            }
            return;
        }
        if (this.buffer != null) {
            this.buffer.func_178977_d();
        }
        if (this.bloomBuffer != null) {
            this.bloomBuffer.func_178977_d();
        }
        if (this.transparentBuffer != null) {
            this.transparentBuffer.func_178977_d();
        }
        if (this.bloomTransparentBuffer != null) {
            this.bloomTransparentBuffer.func_178977_d();
        }
    }

    protected void finalize() throws Throwable {
        if (this.buffer == null && this.bloomBuffer == null && this.transparentBuffer == null && this.bloomTransparentBuffer == null && this.staticBuffer == null && this.staticBloomBuffer == null && this.staticTransparentBuffer == null && this.staticBloomTransparentBuffer == null) {
            super.finalize();
            return;
        }
        Minecraft.func_71410_x().func_152344_a(() -> {
            this.clean();
            this.cleanStatic();
        });
        super.finalize();
    }

    private synchronized void clean() {
        if (this.buffer != null) {
            BufferBuilderPool.returnBuffer(this.buffer);
            this.buffer = null;
        }
        if (this.bloomBuffer != null) {
            BufferBuilderPool.returnBuffer(this.bloomBuffer);
            this.bloomBuffer = null;
        }
        if (this.transparentBuffer != null) {
            BufferBuilderPool.returnBuffer(this.transparentBuffer);
            this.transparentBuffer = null;
        }
        if (this.bloomTransparentBuffer != null) {
            BufferBuilderPool.returnBuffer(this.bloomTransparentBuffer);
            this.bloomTransparentBuffer = null;
        }
    }

    private synchronized void cleanStatic() {
        if (this.staticBuffer != null) {
            BufferBuilderPool.returnBuffer(this.staticBuffer);
            this.staticBuffer = null;
        }
        if (this.staticBloomBuffer != null) {
            BufferBuilderPool.returnBuffer(this.staticBloomBuffer);
            this.staticBloomBuffer = null;
        }
        if (this.staticTransparentBuffer != null) {
            BufferBuilderPool.returnBuffer(this.staticTransparentBuffer);
            this.staticTransparentBuffer = null;
        }
        if (this.staticBloomTransparentBuffer != null) {
            BufferBuilderPool.returnBuffer(this.staticBloomTransparentBuffer);
            this.staticBloomTransparentBuffer = null;
        }
    }
}

