/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.model;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import software.bernie.geckolib3.file.AnimationFile;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class StaticModelBones {
    private final GeoModel model;
    private final AnimationFile animationFile;
    private Set<String> staticBones = new HashSet<String>();

    private StaticModelBones(GeoModel model, AnimationFile animationFile) {
        this.model = model;
        this.animationFile = animationFile;
        this.compile();
    }

    public static StaticModelBones compile(GeoModel model, AnimationFile animation) {
        return new StaticModelBones(model, animation);
    }

    public void compile() {
        Set animatedBones = (Set)this.animationFile.getAllAnimations().stream().flatMap(animation -> animation.boneAnimations.stream()).map(boneAnimation -> boneAnimation.boneName).collect(ImmutableSet.toImmutableSet());
        this.model.topLevelBones.forEach(bone -> this.recursiveAdd((GeoBone)bone, animatedBones));
        this.staticBones = ImmutableSet.copyOf(this.staticBones);
    }

    private void recursiveAdd(GeoBone bone, Set<String> animatedBones) {
        if (animatedBones.contains(bone.name)) {
            return;
        }
        this.staticBones.add(bone.name);
        bone.childBones.stream().filter(childBone -> !childBone.childBones.isEmpty()).filter(childBone -> !animatedBones.contains(childBone.name)).forEach(staticBone -> this.recursiveAdd((GeoBone)staticBone, animatedBones));
    }

    public boolean isStaticBone(String boneName) {
        return this.staticBones.contains(boneName);
    }
}

