/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.preview;

import com.cleanroommc.client.preview.renderer.scene.ISceneRenderHook;
import com.cleanroommc.client.preview.renderer.scene.ImmediateWorldSceneRenderer;
import com.cleanroommc.client.preview.renderer.scene.WorldSceneRenderer;
import com.cleanroommc.client.shader.ShaderManager;
import com.cleanroommc.client.util.BlockInfo;
import com.cleanroommc.client.util.RenderUtils;
import com.cleanroommc.client.util.TrackedDummyWorld;
import com.cleanroommc.client.util.world.LRDummyWorld;
import github.kasuminova.mmce.client.gui.util.AnimationValue;
import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetController;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.mmce.client.gui.widget.event.WorldRendererCacheCleanEvent;
import github.kasuminova.mmce.client.model.DynamicMachineModelRegistry;
import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import github.kasuminova.mmce.common.util.BlockPos2ValueMap;
import github.kasuminova.mmce.common.util.DynamicPattern;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.block.BlockFactoryController;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.base.ColorableMachineTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class WorldSceneRendererWidget
extends DynamicWidget {
    protected final DynamicMachine machine;
    protected final WorldSceneRenderer renderer = new ImmediateWorldSceneRenderer(new LRDummyWorld(new TrackedDummyWorld(), new TrackedDummyWorld()));
    protected final Map<BlockPos, Color> blockOverlayMap = new BlockPos2ValueMap<Color>();
    protected final Vector3f defaultCenter = new Vector3f();
    protected final Vector3f center = new Vector3f();
    protected BlockArray pattern = null;
    protected BlockPos offset = BlockPos.field_177992_a;
    protected BlockPos selected = null;
    protected boolean useLayerRender = false;
    protected int renderLayer = 0;
    protected int dynamicPatternSize = 0;
    protected boolean resetZoom = false;
    protected boolean structureFormed = false;
    protected float rotationYaw = 25.0f;
    protected float rotationPitch = -135.0f;
    protected AnimationValue zoom = AnimationValue.ofFinished(5.0, 200, 0.25, 0.1, 0.25, 1.0);
    protected double defaultZoom = 5.0;
    protected boolean dragging;
    protected int mouseButton = 0;
    protected int lastClickedMouseX = 0;
    protected int lastClickedMouseY = 0;
    protected int lastMouseX;
    protected int lastMouseY;
    protected boolean requireRefreshPattern = false;
    protected boolean cycleBlocks = true;
    protected long tickSnap = ClientScheduler.getClientTick();
    protected long lastPatternUpdate = -1L;
    protected long lastTraceUpdate = -1L;
    protected Consumer<WorldSceneRendererWidget> onPatternUpdate = null;
    protected Consumer<BlockPos> onBlockSelected = null;

    public WorldSceneRendererWidget(DynamicMachine machine) {
        this.machine = machine;
    }

    protected static int getYOffset(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y < 0) {
            return -y;
        }
        return 0;
    }

    @Override
    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.initRenderer();
    }

    protected void initPattern(DynamicMachine machine, boolean resetZoom) {
        this.initializePattern(machine);
        boolean useLayerRender = this.useLayerRender;
        int renderLayer = this.renderLayer;
        long tickSnap = this.tickSnap;
        TrackedDummyWorld world = this.renderer.getLRDummyWorld().getAnotherWorld();
        BlockPos2ValueMap<BlockInfo> converted = new BlockPos2ValueMap<BlockInfo>();
        BlockPos min = this.pattern.getMin();
        BlockPos max = this.pattern.getMax();
        BlockPos offset = this.offset = new BlockPos(0, WorldSceneRendererWidget.getYOffset(min), 0);
        this.pattern.getPattern().forEach((pos, info) -> {
            if (useLayerRender && pos.func_177956_o() != renderLayer) {
                return;
            }
            if (machine.isHideComponentsWhenFormed() && this.structureFormed && !pos.equals((Object)BlockPos.field_177992_a)) {
                return;
            }
            IBlockState sampleState = info.getSampleState(tickSnap);
            TileEntity te = null;
            Block block = sampleState.func_177230_c();
            if (block.hasTileEntity(sampleState)) {
                te = block.createTileEntity((World)world, sampleState);
                if (this.structureFormed && te instanceof ColorableMachineTile) {
                    ColorableMachineTile colorable = (ColorableMachineTile)te;
                    colorable.setMachineColor(machine.getMachineColor());
                }
            }
            converted.put(pos.func_177971_a((Vec3i)offset), new BlockInfo(sampleState, te, null, info.getPreviewTag()));
        });
        world.addBlocks(converted);
        if (machine.isHideComponentsWhenFormed() && this.structureFormed) {
            converted.remove(BlockPos.field_177992_a.func_177971_a((Vec3i)offset));
        }
        this.preInitNextRenderedCore(min.func_177971_a((Vec3i)offset), max.func_177971_a((Vec3i)offset), converted.keySet(), (_1, _2, _3) -> {}, this.resetZoom || resetZoom);
        this.resetZoom = false;
        if (this.onPatternUpdate != null) {
            this.onPatternUpdate.accept(this);
        }
    }

    private void initializePattern(DynamicMachine machine) {
        this.pattern = new BlockArray(machine.getPattern());
        this.addControllerToPattern(machine);
        if (machine.isHideComponentsWhenFormed() && this.structureFormed) {
            return;
        }
        this.addUpgradeIngredientToPattern(machine);
        this.addDynamicPatternToPattern(machine);
    }

    protected void addUpgradeIngredientToPattern(DynamicMachine machine) {
        Map<BlockPos, BlockArray.BlockInformation> pattern = this.pattern.getPattern();
        machine.getModifiersAsMatchingReplacements().forEach((pos, infoList) -> infoList.forEach(info -> {
            if (pattern.containsKey(pos)) {
                BlockArray.BlockInformation newInfo = ((BlockArray.BlockInformation)pattern.get(pos)).copy();
                newInfo.addMatchingStates(info.getMatchingStates());
                this.pattern.addBlock((BlockPos)pos, newInfo);
            } else {
                this.pattern.addBlock((BlockPos)pos, (BlockArray.BlockInformation)info);
            }
        }));
    }

    protected void addDynamicPatternToPattern(DynamicMachine machine) {
        Map<String, DynamicPattern> dynamicPatterns = machine.getDynamicPatterns();
        for (DynamicPattern pattern : dynamicPatterns.values()) {
            this.dynamicPatternSize = Math.max(this.dynamicPatternSize, pattern.getMinSize());
        }
        for (DynamicPattern pattern : dynamicPatterns.values()) {
            pattern.addPatternToBlockArray(this.pattern, Math.min(Math.max(pattern.getMinSize(), this.dynamicPatternSize), pattern.getMaxSize()), pattern.getFaces().iterator().next(), EnumFacing.NORTH);
        }
    }

    protected void addControllerToPattern(DynamicMachine machine) {
        if (machine.isHasFactory() && machine.isFactoryOnly()) {
            BlockFactoryController factory = BlockFactoryController.getControllerWithMachine(machine);
            if (factory == null) {
                factory = BlocksMM.blockFactoryController;
            }
            this.pattern.addBlock(BlockPos.field_177992_a, new BlockArray.BlockInformation(Collections.singletonList(new IBlockStateDescriptor(factory.func_176223_P()))));
            return;
        }
        ArrayList<IBlockStateDescriptor> descriptors = new ArrayList<IBlockStateDescriptor>();
        BlockController ctrl = BlockController.getControllerWithMachine(machine);
        if (ctrl == null) {
            ctrl = BlocksMM.blockController;
        }
        descriptors.add(new IBlockStateDescriptor(ctrl.func_176223_P()));
        if (machine.isHasFactory()) {
            BlockFactoryController factory = BlockFactoryController.getControllerWithMachine(machine);
            if (factory == null) {
                factory = BlocksMM.blockFactoryController;
            }
            descriptors.add(new IBlockStateDescriptor(factory.func_176223_P()));
        }
        this.pattern.addBlock(new BlockPos((Vec3i)BlockPos.field_177992_a), new BlockArray.BlockInformation(descriptors));
    }

    protected void initRenderer() {
        this.initPattern(this.machine, true);
        this.renderer.setOnLookingAt(ray -> {});
        this.renderer.setAfterWorldRender(worldRenderer -> {
            if (this.selected != null) {
                RenderUtils.renderBlockOverLay(this.selected, 0.6f, 0.0f, 0.0f, 0.5f, 1.01f);
            }
            this.blockOverlayMap.forEach((pos, color) -> RenderUtils.renderBlockOverLay(pos.func_177971_a((Vec3i)this.offset), (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f, 1.01f));
            if (!this.structureFormed) {
                return;
            }
            TileEntity te = this.renderer.getWorld().func_175625_s(BlockPos.field_177992_a.func_177971_a((Vec3i)this.offset));
            if (te instanceof TileMultiblockMachineController) {
                TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
                MachineControllerModel model = DynamicMachineModelRegistry.INSTANCE.getMachineDefaultModel(this.machine);
                if (model != null) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)this.offset.func_177956_o(), (float)0.0f);
                    MachineControllerRenderer.INSTANCE.renderDummy(ctrl, model);
                    GlStateManager.func_179121_F();
                }
            }
        });
        this.renderer.setCameraLookAt(this.center, this.zoom.get(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        this.checkCacheRenderer();
        this.lastPatternUpdate = System.currentTimeMillis();
    }

    protected void checkCacheRenderer() {
        boolean shaderPackLoaded = ShaderManager.isOptifineShaderPackLoaded();
        if (shaderPackLoaded) {
            if (this.renderer.isUseCache()) {
                this.renderer.useCacheBuffer(false);
                this.renderer.switchLRRenderer();
            }
        } else if (!this.renderer.isUseCache() && OpenGlHelper.func_176075_f()) {
            this.renderer.useCacheBuffer(true);
        }
    }

    @Override
    public void update(WidgetGui gui) {
        super.update(gui);
        if (System.currentTimeMillis() - this.lastPatternUpdate >= 1500L && this.cycleBlocks || this.requireRefreshPattern) {
            if (this.cycleBlocks) {
                this.tickSnap = ClientScheduler.getClientTick();
            }
            this.refreshPattern();
        }
    }

    protected void refreshPattern() {
        if (!this.renderer.isCompiling() && !this.renderer.isCompilerThreadAlive()) {
            this.renderer.getLRDummyWorld().setAnotherWorld(new TrackedDummyWorld());
            this.initPattern(this.machine, false);
            this.renderer.needCompileCache();
            this.requireRefreshPattern = false;
            this.lastPatternUpdate = System.currentTimeMillis();
        } else {
            this.requireRefreshPattern = true;
        }
    }

    @Override
    public void preRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.handleZoomAnim();
        this.handleMouseMove();
        int guiLeft = gui.getGuiLeft();
        int guiTop = gui.getGuiTop();
        RenderPos renderOffset = new RenderPos(guiLeft, guiTop);
        RenderPos realRenderPos = renderPos.add(WidgetController.TRANSLATE_STATE.get());
        MousePos realMousePos = mousePos.add(renderPos).add(renderOffset);
        this.checkCacheRenderer();
        boolean traceBlock = false;
        if (this.lastTraceUpdate + 50L < System.currentTimeMillis()) {
            traceBlock = true;
            this.lastTraceUpdate = System.currentTimeMillis();
        }
        this.renderer.render(realRenderPos.posX(), realRenderPos.posY(), renderSize.width(), renderSize.height(), realMousePos.mouseX(), realMousePos.mouseY(), traceBlock);
    }

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
    }

    @Override
    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        if (this.isMouseOver(mousePos)) {
            this.zoom.set(MathHelper.func_151237_a((double)(this.zoom.getTargetValue() + (double)(wheel < 0 ? 1.5f : -1.5f)), (double)(this.defaultZoom / 80.0), (double)(this.defaultZoom * 40.0)));
            return true;
        }
        return super.onMouseDWheel(mousePos, renderPos, wheel);
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        this.dragging = true;
        this.mouseButton = mouseButton;
        this.lastMouseX = Mouse.getX();
        this.lastMouseY = Mouse.getY();
        this.lastClickedMouseX = this.lastMouseX;
        this.lastClickedMouseY = this.lastMouseY;
        return true;
    }

    protected void handleZoomAnim() {
        if (!this.zoom.isAnimFinished()) {
            this.renderer.setCameraLookAt(this.center, this.zoom.get(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
    }

    protected void handleMouseMove() {
        if (!this.dragging) {
            return;
        }
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        float mouseOffsetX = mouseX - this.lastMouseX;
        float mouseOffsetY = mouseY - this.lastMouseY;
        if (this.mouseButton == 0) {
            this.rotationPitch += mouseOffsetX * 0.25f + 360.0f;
            this.rotationPitch %= 360.0f;
            this.rotationYaw = (float)MathHelper.func_151237_a((double)(this.rotationYaw - mouseOffsetY * 0.25f), (double)-89.9, (double)89.9);
        } else if (this.mouseButton == 1) {
            double radianPitch = Math.toRadians((this.rotationPitch + 90.0f) % 360.0f);
            double radianYaw = Math.toRadians(this.rotationYaw);
            double motionX = Math.cos(radianPitch) * (double)(mouseOffsetX *= 0.05f) + Math.sin(radianPitch) * Math.sin(radianYaw) * (double)(mouseOffsetY *= 0.05f);
            double motionY = -Math.cos(radianYaw) * (double)mouseOffsetY;
            double motionZ = Math.sin(radianPitch) * (double)mouseOffsetX - Math.cos(radianPitch) * Math.sin(radianYaw) * (double)mouseOffsetY;
            this.center.x += (float)motionX;
            this.center.y += (float)motionY;
            this.center.z += (float)motionZ;
        }
        this.renderer.setCameraLookAt(this.center, this.zoom.get(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void resetCenter() {
        this.center.set(this.defaultCenter.x, this.defaultCenter.y, this.defaultCenter.z);
        this.renderer.setCameraLookAt(this.center, this.zoom.get(), Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        this.dragging = false;
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        if (Math.abs(this.lastClickedMouseX - mouseX) <= 5 && Math.abs(this.lastClickedMouseY - mouseY) <= 5) {
            this.handleBlockClick();
        }
        return false;
    }

    protected void handleBlockClick() {
        RayTraceResult traceResult = this.renderer.getLastTraceResult();
        BlockPos blockPos = this.selected = traceResult == null ? null : traceResult.func_178782_a();
        if (this.onBlockSelected != null) {
            this.onBlockSelected.accept(this.selected);
        }
    }

    public WorldSceneRendererWidget preInitNextRenderedCore(BlockPos min, BlockPos max, Collection<BlockPos> blocks, ISceneRenderHook renderHook, boolean resetCamera) {
        int minX = min.func_177958_n();
        int minY = min.func_177956_o();
        int minZ = min.func_177952_p();
        int maxX = max.func_177958_n();
        int maxY = max.func_177956_o();
        int maxZ = max.func_177952_p();
        this.defaultCenter.set((float)(minX + maxX) / 2.0f + 0.5f, (float)(minY + maxY) / 2.0f + 0.5f, (float)(minZ + maxZ) / 2.0f + 0.5f);
        this.renderer.addRenderedBlocksToAnotherWorld(blocks, renderHook);
        if (resetCamera) {
            double zoom = this.defaultZoom = this.zoom.setImmediate(3.5 * Math.sqrt(Math.max(Math.max(Math.max(maxX - minX + 1, maxY - minY + 1), maxZ - minZ + 1), 1))).get();
            this.center.set(this.defaultCenter.x, this.defaultCenter.y, this.defaultCenter.z);
            this.renderer.setCameraLookAt(this.center, zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        return this;
    }

    @Override
    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof WorldRendererCacheCleanEvent) {
            this.renderer.deleteCacheBuffer();
            this.renderer.getLRDummyWorld().setWorld(null).setAnotherWorld(null);
            return true;
        }
        return false;
    }

    public BlockArray getPattern() {
        return this.pattern;
    }

    public boolean isStructureFormed() {
        return this.structureFormed;
    }

    public WorldSceneRendererWidget setStructureFormed(boolean structureFormed) {
        if (this.structureFormed != structureFormed) {
            this.structureFormed = structureFormed;
            this.refreshPattern();
        }
        return this;
    }

    public boolean isUseLayerRender() {
        return this.useLayerRender;
    }

    public WorldSceneRendererWidget useLayerRender() {
        if (!this.useLayerRender) {
            this.useLayerRender = true;
            this.refreshPattern();
        }
        return this;
    }

    public WorldSceneRendererWidget use3DRender() {
        if (this.useLayerRender) {
            this.useLayerRender = false;
            this.refreshPattern();
        }
        return this;
    }

    public int getRenderLayer() {
        return this.renderLayer;
    }

    public WorldSceneRendererWidget setRenderLayer(int renderLayer) {
        if (this.renderLayer != renderLayer) {
            this.renderLayer = renderLayer;
            if (this.useLayerRender) {
                this.refreshPattern();
            }
        }
        return this;
    }

    public boolean isCycleBlocks() {
        return this.cycleBlocks;
    }

    public WorldSceneRendererWidget setCycleBlocks(boolean cycleBlocks) {
        this.cycleBlocks = cycleBlocks;
        return this;
    }

    public long getTickSnap() {
        return this.tickSnap;
    }

    public int getDynamicPatternSize() {
        return this.dynamicPatternSize;
    }

    public WorldSceneRendererWidget setDynamicPatternSize(int dynamicPatternSize) {
        if (this.dynamicPatternSize != dynamicPatternSize) {
            this.dynamicPatternSize = dynamicPatternSize;
            this.resetZoom = true;
            this.refreshPattern();
        }
        return this;
    }

    public WorldSceneRenderer getWorldRenderer() {
        return this.renderer;
    }

    public BlockPos getRenderOffset() {
        return this.offset;
    }

    public BlockPos getSelected() {
        return this.selected;
    }

    public WorldSceneRendererWidget addBlockOverlays(Map<BlockPos, Color> overlayMap) {
        this.blockOverlayMap.putAll(overlayMap);
        return this;
    }

    public WorldSceneRendererWidget removeBlockOverlays(Set<BlockPos> overlayPosSet) {
        this.blockOverlayMap.keySet().removeAll(overlayPosSet);
        return this;
    }

    public WorldSceneRendererWidget removeBlockOverlay(BlockPos overlayPos) {
        this.blockOverlayMap.keySet().remove(overlayPos);
        return this;
    }

    public WorldSceneRendererWidget setOnPatternUpdate(Consumer<WorldSceneRendererWidget> onPatternUpdate) {
        this.onPatternUpdate = onPatternUpdate;
        return this;
    }

    public WorldSceneRendererWidget setOnBlockSelected(Consumer<BlockPos> onBlockSelected) {
        this.onBlockSelected = onBlockSelected;
        return this;
    }
}

