/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.preview;

import com.cleanroommc.client.shader.ShaderManager;
import github.kasuminova.mmce.client.gui.widget.HorizontalLine;
import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.impl.preview.WorldSceneRendererWidget;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;

public class PreviewStatusBar
extends Column {
    protected final WorldSceneRendererWidget renderer;
    protected final MultiLineLabel messageLabel = new MultiLineLabel(Collections.emptyList());
    protected final HorizontalLine progressLine = new HorizontalLine();
    protected int maxWidth = 0;
    protected boolean shaderPackLoaded = false;
    protected boolean vboUnsupported = false;
    protected boolean vboDisabled = false;

    public PreviewStatusBar(WorldSceneRendererWidget renderer) {
        this.renderer = renderer;
    }

    @Override
    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.messageLabel.setScale(0.72f).setMarginLeft(22);
        this.progressLine.setColor(-7876870).setHeight(2);
        this.addWidgets(this.progressLine, this.messageLabel);
    }

    @Override
    public void update(WidgetGui gui) {
        super.update(gui);
        float progress = this.renderer.getWorldRenderer().getCompileProgress();
        this.shaderPackLoaded = ShaderManager.isOptifineShaderPackLoaded();
        this.vboUnsupported = !OpenGlHelper.field_176083_O;
        boolean bl = this.vboDisabled = !OpenGlHelper.func_176075_f();
        if (progress > 0.0f) {
            this.progressLine.setWidth((int)Math.floor((float)this.maxWidth * progress));
        } else {
            this.progressLine.setWidth(0);
        }
        ArrayList<String> contents = new ArrayList<String>();
        if (progress > 0.0f) {
            contents.add(I18n.func_135052_a((String)"gui.preview.compiling.progress", (Object[])new Object[]{MiscUtils.formatFloat(progress * 100.0f, 1)}));
        }
        if (this.shaderPackLoaded) {
            contents.add(I18n.func_135052_a((String)"gui.preview.optifine_shader_pack_warn", (Object[])new Object[0]));
        }
        if (this.vboUnsupported) {
            contents.add(I18n.func_135052_a((String)"gui.preview.vbo_unsupported_warn", (Object[])new Object[0]));
        } else if (this.vboDisabled) {
            contents.add(I18n.func_135052_a((String)"gui.preview.vbo_disabled_warn", (Object[])new Object[0]));
        }
        this.messageLabel.setContents(contents);
        this.setMaxWidth(this.maxWidth);
    }

    public PreviewStatusBar setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.messageLabel.setWidth(maxWidth - this.messageLabel.getMarginLeft() - this.messageLabel.getMarginRight());
        return this;
    }
}

