/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.patternprovider;

import github.kasuminova.mmce.client.gui.GuiMEPatternProvider;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.impl.preview.IngredientList;
import github.kasuminova.mmce.client.gui.widget.slot.SlotFluidVirtual;
import github.kasuminova.mmce.client.gui.widget.slot.SlotGasVirtual;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtual;
import github.kasuminova.mmce.client.gui.widget.slot.SlotVirtual;
import hellfirepvp.modularmachinery.common.base.Mods;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class PatternProviderIngredientList
extends IngredientList {
    protected static SlotVirtual initSlot(SlotVirtual slot) {
        return slot.setSlotTex(TextureProperties.of(GuiMEPatternProvider.GUI_TEXTURE, 220, 232));
    }

    @Override
    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.scrollbar.setMargin(5, 1, 1, 1);
        this.scrollbar.setWidthHeight(9, 124);
        this.scrollbar.getScroll().setMouseDownTexture(198, 232).setHoveredTexture(187, 232).setTexture(176, 232).setUnavailableTexture(209, 232).setTextureLocation(GuiMEPatternProvider.GUI_TEXTURE).setWidthHeight(9, 18);
    }

    public PatternProviderIngredientList setStackList(List<ItemStack> list, List<FluidStack> fluidList, List<?> gasList) {
        this.getWidgets().clear();
        Row row = new Row();
        int[] stackPerRow = new int[]{0};
        int totalSize = list.size() + fluidList.size() + gasList.size();
        row = this.addSlots(list, row, stackPerRow, totalSize, SlotItemVirtual::ofJEI);
        row = this.addSlots(fluidList, row, stackPerRow, totalSize, SlotFluidVirtual::ofJEI);
        if (Mods.MEKANISM.isPresent() && Mods.MEKENG.isPresent()) {
            row = this.addGasSlots(gasList, row, stackPerRow, totalSize);
        }
        this.addWidget(row.setUseScissor(false));
        return this;
    }

    protected <T> Row addSlots(List<T> gasList, Row row, int[] stackPerRow, int totalSize, Function<T, SlotVirtual> slotSupplier) {
        for (int i = 0; i < gasList.size(); ++i) {
            T stack = gasList.get(i);
            row.addWidget(PatternProviderIngredientList.initSlot(slotSupplier.apply(stack)));
            stackPerRow[0] = stackPerRow[0] + 1;
            if (stackPerRow[0] < this.maxStackPerRow || i + 1 >= totalSize) continue;
            this.addWidget(row.setUseScissor(false));
            row = new Row();
            stackPerRow[0] = 0;
        }
        return row;
    }

    @Optional.Method(modid="mekeng")
    private Row addGasSlots(List<?> gasList, Row row, int[] stackPerRow, int totalSize) {
        return this.addSlots(gasList, row, stackPerRow, totalSize, SlotGasVirtual::ofJEI);
    }
}

