/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.container;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import hellfirepvp.modularmachinery.ModularMachinery;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public abstract class WidgetContainer
extends DynamicWidget {
    protected static final ThreadLocal<LinkedList<Rectangle>> SCISSOR_STACK = ThreadLocal.withInitial(LinkedList::new);
    protected boolean useScissor = true;

    public static void pushScissor(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, int width, int height) {
        int guiLeft = gui.getGuiLeft();
        int guiTop = gui.getGuiTop();
        int offsetX = renderPos.posX();
        int offsetY = renderPos.posY();
        if (renderSize.isLimited()) {
            LinkedList<Rectangle> scissorStack = SCISSOR_STACK.get();
            ScaledResolution res = new ScaledResolution(gui.getGui().field_146297_k);
            int scissorWidth = renderSize.isWidthLimited() ? renderSize.width() : width;
            int scissorHeight = renderSize.isHeightLimited() ? renderSize.height() : height;
            Rectangle scissorFrame = new Rectangle((guiLeft + offsetX) * res.func_78325_e(), gui.getGui().field_146297_k.field_71440_d - (guiTop + offsetY + scissorHeight) * res.func_78325_e(), scissorWidth * res.func_78325_e(), scissorHeight * res.func_78325_e());
            if (scissorStack.peekFirst() == null) {
                GL11.glEnable((int)3089);
            }
            GL11.glScissor((int)scissorFrame.x, (int)scissorFrame.y, (int)scissorFrame.width, (int)scissorFrame.height);
            scissorStack.push(scissorFrame);
        }
    }

    public static void popScissor(RenderSize renderSize) {
        if (renderSize.isLimited()) {
            Rectangle prevScissorFrame;
            LinkedList<Rectangle> scissorStack = SCISSOR_STACK.get();
            if (scissorStack.peekFirst() != null) {
                scissorStack.pop();
            }
            if ((prevScissorFrame = scissorStack.peekFirst()) == null) {
                GL11.glDisable((int)3089);
            } else {
                GL11.glScissor((int)prevScissorFrame.x, (int)prevScissorFrame.y, (int)prevScissorFrame.width, (int)prevScissorFrame.height);
            }
        }
    }

    public static void enableScissor() {
        LinkedList<Rectangle> scissorStack = SCISSOR_STACK.get();
        Rectangle scissorFrame = scissorStack.peekFirst();
        if (scissorFrame != null) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)scissorFrame.x, (int)scissorFrame.y, (int)scissorFrame.width, (int)scissorFrame.height);
        }
    }

    public static void disableScissor() {
        GL11.glDisable((int)3089);
    }

    @Override
    public final void preRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        boolean useScissor = this.useScissor;
        if (useScissor) {
            WidgetContainer.pushScissor(gui, renderSize, renderPos, this.getWidth(), this.getHeight());
        }
        try {
            this.preRenderInternal(gui, renderSize, renderPos, mousePos);
        }
        catch (Exception e) {
            SCISSOR_STACK.get().clear();
            ModularMachinery.log.error("Error when rendering dynamic widgets!", (Throwable)e);
            throw e;
        }
        finally {
            if (useScissor) {
                WidgetContainer.popScissor(renderSize);
            }
        }
    }

    @Override
    public final void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        boolean useScissor = this.useScissor;
        if (useScissor) {
            WidgetContainer.pushScissor(gui, renderSize, renderPos, this.getWidth(), this.getHeight());
        }
        try {
            this.renderInternal(gui, renderSize, renderPos, mousePos);
        }
        catch (Exception e) {
            SCISSOR_STACK.get().clear();
            ModularMachinery.log.error("Error when rendering dynamic widgets!", (Throwable)e);
            throw e;
        }
        finally {
            if (useScissor) {
                WidgetContainer.popScissor(renderSize);
            }
        }
    }

    @Override
    public final void postRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        boolean useScissor = this.useScissor;
        if (useScissor) {
            WidgetContainer.pushScissor(gui, renderSize, renderPos, this.getWidth(), this.getHeight());
        }
        try {
            this.postRenderInternal(gui, renderSize, renderPos, mousePos);
        }
        catch (Exception e) {
            SCISSOR_STACK.get().clear();
            ModularMachinery.log.error("Error when rendering dynamic widgets!", (Throwable)e);
            throw e;
        }
        finally {
            if (useScissor) {
                WidgetContainer.popScissor(renderSize);
            }
        }
    }

    protected abstract void preRenderInternal(WidgetGui var1, RenderSize var2, RenderPos var3, MousePos var4);

    protected abstract void renderInternal(WidgetGui var1, RenderSize var2, RenderPos var3, MousePos var4);

    protected abstract void postRenderInternal(WidgetGui var1, RenderSize var2, RenderPos var3, MousePos var4);

    public abstract List<DynamicWidget> getWidgets();

    public abstract WidgetContainer addWidget(DynamicWidget var1);

    public WidgetContainer addWidgets(DynamicWidget ... widgets) {
        for (DynamicWidget widget : widgets) {
            this.addWidget(widget);
        }
        return this;
    }

    public abstract WidgetContainer removeWidget(DynamicWidget var1);

    @Override
    public void update(WidgetGui gui) {
        for (DynamicWidget widget : this.getWidgets()) {
            if (widget.isDisabled()) continue;
            widget.update(gui);
        }
    }

    @Override
    public void onGUIClosed(WidgetGui gui) {
        this.getWidgets().forEach(widget -> widget.onGUIClosed(gui));
    }

    @Override
    public void initWidget(WidgetGui gui) {
        this.getWidgets().forEach(widget -> widget.initWidget(gui));
    }

    @Override
    public abstract boolean onMouseClick(MousePos var1, RenderPos var2, int var3);

    @Override
    public abstract void onMouseClickGlobal(MousePos var1, RenderPos var2, int var3);

    @Override
    public abstract boolean onMouseReleased(MousePos var1, RenderPos var2);

    @Override
    public abstract boolean onMouseDWheel(MousePos var1, RenderPos var2, int var3);

    @Override
    public abstract boolean onKeyTyped(char var1, int var2);

    @Override
    public abstract List<String> getHoverTooltips(WidgetGui var1, MousePos var2);

    @Override
    public abstract boolean onGuiEvent(GuiEvent var1);

    public boolean isUseScissor() {
        return this.useScissor;
    }

    public WidgetContainer setUseScissor(boolean useScissor) {
        this.useScissor = useScissor;
        return this;
    }
}

