/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.container;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderFunction;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.Scrollbar;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import java.util.Collections;
import java.util.List;

public class ScrollingColumn
extends Column {
    protected final Scrollbar scrollbar = new Scrollbar();

    @Override
    protected void doRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos, RenderFunction renderFunction) {
        int width = renderSize.width() - (this.scrollbar.getMarginLeft() + this.scrollbar.getWidth() + this.scrollbar.getMarginRight());
        int height = renderSize.height();
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetY = widgetRenderPos.posY();
            if (offsetY + widget.getHeight() >= 0) {
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                renderFunction.doRender(widget, gui, new RenderSize(widget.getWidth(), widget.getHeight()).smaller(renderSize), absRenderPos, mousePos.relativeTo(widgetRenderPos));
            }
            if (!renderSize.isHeightLimited() || (y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown()) < renderSize.height()) continue;
            break;
        }
        if (this.scrollbar.isDisabled()) {
            return;
        }
        RenderPos scrollbarRenderPos = new RenderPos(width + this.scrollbar.getMarginLeft(), this.scrollbar.getMarginUp());
        renderFunction.doRender(this.scrollbar, gui, new RenderSize(this.scrollbar.getWidth(), this.scrollbar.getHeight()).smaller(renderSize), renderPos.add(scrollbarRenderPos), mousePos.relativeTo(scrollbarRenderPos));
    }

    @Override
    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.scrollbar.setMargin(0, 1, 1, 1);
        this.scrollbar.setMouseWheelCheckPos(false);
    }

    @Override
    public ScrollingColumn addWidget(DynamicWidget widget) {
        super.addWidget(widget);
        return this;
    }

    @Override
    public ScrollingColumn removeWidget(DynamicWidget widget) {
        super.removeWidget(widget);
        return this;
    }

    @Override
    public void update(WidgetGui gui) {
        super.update(gui);
        this.scrollbar.setRange(0, Math.max(this.getTotalHeight() - this.height, 0));
        this.scrollbar.setScrollUnit(this.scrollbar.getRange() / 10);
        this.scrollbar.update(gui);
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos absRenderPos;
            MousePos relativeMousePos;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            if (offsetY + widget.getHeight() >= 0 && widget.isMouseOver(relativeMousePos = mousePos.relativeTo(widgetRenderPos)) && widget.onMouseClick(relativeMousePos, absRenderPos = widgetRenderPos.add(renderPos), mouseButton)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.scrollbar.isDisabled()) {
            return false;
        }
        RenderPos scrollbarRenderPos = new RenderPos(width - (this.scrollbar.getWidth() + this.scrollbar.getMarginRight()), height - (this.scrollbar.getHeight() + this.scrollbar.getMarginDown()));
        MousePos scrollbarRelativeMousePos = mousePos.relativeTo(scrollbarRenderPos);
        if (this.scrollbar.isMouseOver(scrollbarRelativeMousePos)) {
            return this.scrollbar.onMouseClick(scrollbarRelativeMousePos, renderPos.add(scrollbarRenderPos), mouseButton);
        }
        return false;
    }

    @Override
    public void onMouseClickGlobal(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            if (offsetY + widget.getHeight() >= 0) {
                MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                widget.onMouseClickGlobal(relativeMousePos, absRenderPos, mouseButton);
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
    }

    @Override
    public boolean onMouseClickMove(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseClickMove(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.scrollbar.isDisabled()) {
            return false;
        }
        RenderPos scrollbarRenderPos = new RenderPos(width - (this.scrollbar.getWidth() + this.scrollbar.getMarginRight()), height - (this.scrollbar.getHeight() + this.scrollbar.getMarginDown()));
        return this.scrollbar.onMouseClickMove(mousePos.relativeTo(scrollbarRenderPos), renderPos.add(scrollbarRenderPos), mouseButton);
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseReleased(mousePos.relativeTo(widgetRenderPos), absRenderPos)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.scrollbar.isDisabled()) {
            return false;
        }
        RenderPos scrollbarRenderPos = new RenderPos(width - (this.scrollbar.getWidth() + this.scrollbar.getMarginRight()), height - (this.scrollbar.getHeight() + this.scrollbar.getMarginDown()));
        return this.scrollbar.onMouseReleased(mousePos.relativeTo(scrollbarRenderPos), renderPos.add(scrollbarRenderPos));
    }

    @Override
    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseDWheel(mousePos.relativeTo(widgetRenderPos), absRenderPos, wheel)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.scrollbar.isDisabled()) {
            return false;
        }
        if (this.isMouseOver(mousePos)) {
            RenderPos scrollbarRenderPos = new RenderPos(width - (this.scrollbar.getWidth() + this.scrollbar.getMarginRight()), height - (this.scrollbar.getHeight() + this.scrollbar.getMarginDown()));
            MousePos scrollbarRelativeMousePos = mousePos.relativeTo(scrollbarRenderPos);
            return this.scrollbar.onMouseDWheel(scrollbarRelativeMousePos, renderPos.add(scrollbarRenderPos), wheel);
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled() || !widget.onKeyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        List<String> hoverTooltips;
        int width = this.width;
        int height = this.height;
        int y = this.getTotalHeight() > height ? -this.scrollbar.getCurrentScroll() : 0;
        List<String> tooltips = null;
        for (DynamicWidget widget : this.widgets) {
            List<String> hoverTooltips2;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            if (widget.isMouseOver(relativeMousePos) && !(hoverTooltips2 = widget.getHoverTooltips(widgetGui, relativeMousePos)).isEmpty()) {
                tooltips = hoverTooltips2;
                break;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (tooltips != null) {
            return tooltips;
        }
        if (this.scrollbar.isDisabled()) {
            return Collections.emptyList();
        }
        RenderPos scrollbarRenderPos = new RenderPos(width - (this.scrollbar.getWidth() + this.scrollbar.getMarginRight()), height - (this.scrollbar.getHeight() + this.scrollbar.getMarginDown()));
        MousePos scrollbarMousePos = mousePos.relativeTo(scrollbarRenderPos);
        if (this.scrollbar.isMouseOver(scrollbarMousePos) && !(hoverTooltips = this.scrollbar.getHoverTooltips(widgetGui, scrollbarMousePos)).isEmpty()) {
            tooltips = hoverTooltips;
        }
        return tooltips != null ? tooltips : Collections.emptyList();
    }

    @Override
    public boolean onGuiEvent(GuiEvent event) {
        if (this.scrollbar.onGuiEvent(event)) {
            return true;
        }
        return super.onGuiEvent(event);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public ScrollingColumn setWidth(int width) {
        this.width = width;
        return this;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ScrollingColumn setHeight(int height) {
        this.height = height;
        this.scrollbar.setHeight(height - 2);
        return this;
    }

    @Override
    public ScrollingColumn setWidthHeight(int width, int height) {
        return this.setWidth(width).setHeight(height);
    }

    public int getTotalHeight() {
        int total = 0;
        for (DynamicWidget widget : this.widgets) {
            if (widget.isUseAbsPos()) continue;
            total += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return total;
    }
}

