/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.container;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderFunction;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.WidgetContainer;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Column
extends WidgetContainer {
    protected final List<DynamicWidget> widgets = new ArrayList<DynamicWidget>();
    protected boolean leftAligned = true;
    protected boolean rightAligned = false;

    @Override
    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.doRender(gui, renderSize, renderPos, mousePos, DynamicWidget::preRender);
    }

    @Override
    protected void renderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.doRender(gui, renderSize, renderPos, mousePos, DynamicWidget::render);
    }

    @Override
    protected void postRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.doRender(gui, renderSize, renderPos, mousePos, DynamicWidget::postRender);
    }

    protected void doRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos, RenderFunction renderFunction) {
        int y = 0;
        int width = this.getWidth();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            if (widget.isVisible()) {
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                renderFunction.doRender(widget, gui, new RenderSize(widget.getWidth(), widget.getHeight()).smaller(renderSize), absRenderPos, mousePos.relativeTo(widgetRenderPos));
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
    }

    @Override
    public List<DynamicWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public Column addWidget(DynamicWidget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Containers cannot be added to their own containers!");
        }
        this.widgets.add(widget);
        return this;
    }

    @Override
    public Column removeWidget(DynamicWidget widget) {
        this.widgets.remove(widget);
        return this;
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int y = 0;
        int width = this.getWidth();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            if (widget.isMouseOver(relativeMousePos)) {
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                if (widget.onMouseClick(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton)) {
                    return true;
                }
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return false;
    }

    @Override
    public void onMouseClickGlobal(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int y = 0;
        int width = this.getWidth();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            widget.onMouseClickGlobal(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton);
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
    }

    @Override
    public boolean onMouseClickMove(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int y = 0;
        int width = this.getWidth();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseClickMove(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        int y = 0;
        int width = this.getWidth();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseReleased(mousePos.relativeTo(widgetRenderPos), absRenderPos)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return false;
    }

    @Override
    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        int y = 0;
        int width = this.getWidth();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseDWheel(mousePos.relativeTo(widgetRenderPos), absRenderPos, wheel)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled() || !widget.onKeyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        int y = 0;
        int width = this.getWidth();
        List<String> tooltips = null;
        for (DynamicWidget widget : this.widgets) {
            List<String> hoverTooltips;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            if (widget.isMouseOver(relativeMousePos) && !(hoverTooltips = widget.getHoverTooltips(widgetGui, relativeMousePos)).isEmpty()) {
                tooltips = hoverTooltips;
                break;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return tooltips != null ? tooltips : Collections.emptyList();
    }

    @Override
    public boolean onGuiEvent(GuiEvent event) {
        for (DynamicWidget widget : this.widgets) {
            if (!widget.onGuiEvent(event)) continue;
            return true;
        }
        return false;
    }

    public RenderPos getWidgetRenderOffset(DynamicWidget widget, int width, int y) {
        int yOffset;
        int xOffset;
        if (widget.isUseAbsPos()) {
            xOffset = widget.getAbsX();
            yOffset = widget.getAbsY();
        } else if (this.isCenterAligned()) {
            xOffset = (width - (widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight())) / 2;
            yOffset = y + widget.getMarginUp();
        } else if (this.leftAligned) {
            xOffset = widget.getMarginLeft();
            yOffset = y + widget.getMarginUp();
        } else if (this.rightAligned) {
            xOffset = width - (widget.getWidth() + widget.getMarginRight());
            yOffset = y + widget.getMarginUp();
        } else {
            return null;
        }
        return new RenderPos(xOffset, yOffset);
    }

    @Override
    public int getWidth() {
        int maxX = 0;
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled()) continue;
            int width = 0;
            if (widget.isUseAbsPos()) {
                width += widget.getAbsX();
            }
            if ((width += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight()) <= maxX) continue;
            maxX = width;
        }
        return maxX;
    }

    @Override
    public DynamicWidget setWidth(int width) {
        return this;
    }

    @Override
    public int getHeight() {
        int height = 0;
        int absWidgetMaxHeight = 0;
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled()) continue;
            int widgetHeight = widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
            if (widget.isUseAbsPos()) {
                absWidgetMaxHeight = Math.max(widgetHeight + widget.getAbsY(), absWidgetMaxHeight);
                continue;
            }
            height += widgetHeight;
        }
        return Math.max(height, absWidgetMaxHeight);
    }

    @Override
    public DynamicWidget setHeight(int height) {
        return this;
    }

    @Override
    public DynamicWidget setWidthHeight(int width, int height) {
        return this;
    }

    public boolean isLeftAligned() {
        return this.leftAligned;
    }

    public Column setLeftAligned(boolean leftAligned) {
        this.rightAligned = !leftAligned;
        this.leftAligned = leftAligned;
        return this;
    }

    public boolean isRightAligned() {
        return this.rightAligned;
    }

    public Column setRightAligned(boolean rightAligned) {
        this.leftAligned = !rightAligned;
        this.rightAligned = rightAligned;
        return this;
    }

    public boolean isCenterAligned() {
        return this.leftAligned && this.rightAligned;
    }

    public Column setCenterAligned(boolean centerAligned) {
        if (centerAligned) {
            this.leftAligned = true;
            this.rightAligned = true;
            return this;
        }
        this.leftAligned = true;
        this.rightAligned = false;
        return this;
    }
}

