/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class Button
extends DynamicWidget {
    protected ResourceLocation textureLocation = null;
    protected TextureProperties texture = TextureProperties.EMPTY;
    protected TextureProperties hoveredTexture = TextureProperties.EMPTY;
    protected TextureProperties unavailableTexture = TextureProperties.EMPTY;
    protected boolean available = true;
    protected Consumer<Button> onClickedListener = null;
    protected Function<Button, List<String>> tooltipFunction = null;

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isUnavailable()) {
            this.unavailableTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        if (this.isMouseOver(mousePos)) {
            this.hoveredTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        this.texture.render(this.textureLocation, renderPos, renderSize, gui);
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (this.isVisible() && this.onClickedListener != null && mouseButton == 0) {
            this.onClickedListener.accept(this);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        if (this.available && this.tooltipFunction != null) {
            return this.tooltipFunction.apply(this);
        }
        return super.getHoverTooltips(widgetGui, mousePos);
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public Button setTextureLocation(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
        return this;
    }

    public Button setTexture(int textureX, int textureY) {
        return this.setTexture(TextureProperties.of(textureX, textureY));
    }

    public Button setHoveredTexture(int hoveredTextureX, int hoveredTextureY) {
        return this.setHoveredTexture(TextureProperties.of(hoveredTextureX, hoveredTextureY));
    }

    public Button setUnavailableTexture(int unavailableTextureX, int unavailableTextureY) {
        return this.setUnavailableTexture(TextureProperties.of(unavailableTextureX, unavailableTextureY));
    }

    public TextureProperties getTexture() {
        return this.texture;
    }

    public Button setTexture(TextureProperties texture) {
        this.texture = Optional.ofNullable(texture).orElse(TextureProperties.EMPTY);
        return this;
    }

    public TextureProperties getHoveredTexture() {
        return this.hoveredTexture;
    }

    public Button setHoveredTexture(TextureProperties hoveredTexture) {
        this.hoveredTexture = Optional.ofNullable(hoveredTexture).orElse(TextureProperties.EMPTY);
        return this;
    }

    public TextureProperties getUnavailableTexture() {
        return this.unavailableTexture;
    }

    public Button setUnavailableTexture(TextureProperties unavailableTexture) {
        this.unavailableTexture = Optional.ofNullable(unavailableTexture).orElse(TextureProperties.EMPTY);
        return this;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Button setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public boolean isUnavailable() {
        return !this.available;
    }

    public Button setAvailable() {
        this.available = true;
        return this;
    }

    public Button setUnavailable() {
        this.available = false;
        return this;
    }

    public Consumer<Button> getOnClickedListener() {
        return this.onClickedListener;
    }

    public Button setOnClickedListener(Consumer<Button> onClickedListener) {
        this.onClickedListener = onClickedListener;
        return this;
    }

    public Function<Button, List<String>> getTooltipFunction() {
        return this.tooltipFunction;
    }

    public Button setTooltipFunction(Function<Button, List<String>> tooltipFunction) {
        this.tooltipFunction = tooltipFunction;
        return this;
    }
}

