/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.util;

import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public final class TextureProperties {
    @Nullable
    private final ResourceLocation texRes;
    private final int texX;
    private final int texY;
    private final int width;
    private final int height;
    public static final TextureProperties EMPTY = new TextureProperties(null, 0, 0, 0, 0);

    public TextureProperties(@Nullable ResourceLocation texRes, int texX, int texY, int width, int height) {
        this.texRes = texRes;
        this.texX = texX;
        this.texY = texY;
        this.width = width;
        this.height = height;
    }

    public static TextureProperties of(@Nullable ResourceLocation texRes, int texX, int texY, int width, int height) {
        return new TextureProperties(texRes, texX, texY, width, height);
    }

    public static TextureProperties of(int texX, int texY, int width, int height) {
        return TextureProperties.of(null, texX, texY, width, height);
    }

    public static TextureProperties of(int texX, int texY, int widthHeight) {
        return TextureProperties.of(null, texX, texY, widthHeight, widthHeight);
    }

    public static TextureProperties of(@Nullable ResourceLocation texRes, int texX, int texY) {
        return TextureProperties.of(texRes, texX, texY, 0, 0);
    }

    public static TextureProperties of(int texX, int texY) {
        return TextureProperties.of(null, texX, texY);
    }

    private static void bind(TextureManager textureManager, ResourceLocation texRes) {
        textureManager.func_110577_a(texRes);
    }

    public void bind(TextureManager textureManager) {
        if (this.texRes != null) {
            TextureProperties.bind(textureManager, this.texRes);
        }
    }

    public void render(RenderPos renderPos, WidgetGui gui) {
        this.render(renderPos, gui.getGui());
    }

    public void render(RenderPos renderPos, GuiScreen gui) {
        this.bind(gui.field_146297_k.func_110434_K());
        gui.func_73729_b(renderPos.posX(), renderPos.posY(), this.texX, this.texY, this.width, this.height);
    }

    public void renderIfPresent(RenderPos renderPos, WidgetGui gui) {
        this.ifPresent(t -> t.render(renderPos, gui));
    }

    public void renderIfPresent(RenderPos renderPos, GuiScreen gui) {
        this.ifPresent(t -> t.render(renderPos, gui));
    }

    public void renderIfPresent(RenderPos renderPos, WidgetGui gui, Consumer<TextureProperties> before) {
        this.ifPresent(t -> before.andThen(t1 -> t.render(renderPos, gui)).accept((TextureProperties)t));
    }

    public void renderIfPresent(RenderPos renderPos, GuiScreen gui, Consumer<TextureProperties> before) {
        this.ifPresent(t -> before.andThen(t1 -> t.render(renderPos, gui)).accept((TextureProperties)t));
    }

    public void renderIfPresent(RenderPos renderPos, WidgetGui gui, @Nullable Consumer<TextureProperties> before, @Nullable Consumer<TextureProperties> after) {
        this.ifPresent(t -> {
            Optional.ofNullable(before).ifPresent((? super T bc) -> bc.accept(t));
            t.render(renderPos, gui);
            Optional.ofNullable(after).ifPresent((? super T ac) -> ac.accept(t));
        });
    }

    public void renderIfPresent(RenderPos renderPos, GuiScreen gui, @Nullable Consumer<TextureProperties> before, @Nullable Consumer<TextureProperties> after) {
        this.ifPresent(t -> {
            Optional.ofNullable(before).ifPresent((? super T bc) -> bc.accept(t));
            t.render(renderPos, gui);
            Optional.ofNullable(after).ifPresent((? super T ac) -> ac.accept(t));
        });
    }

    public void ifPresent(Consumer<TextureProperties> runnable) {
        if (this.texRes != null && this.width > 0 && this.height > 0) {
            runnable.accept(this);
        }
    }

    public void render(@Nullable ResourceLocation customTexRes, RenderPos renderPos, WidgetGui gui) {
        this.render(customTexRes, renderPos, gui.getGui());
    }

    public void render(@Nullable ResourceLocation customTexRes, RenderPos renderPos, GuiScreen gui) {
        TextureManager textureManager = gui.field_146297_k.func_110434_K();
        if (this.texRes != null) {
            this.bind(textureManager);
        } else if (customTexRes != null) {
            TextureProperties.bind(textureManager, customTexRes);
        } else {
            return;
        }
        gui.func_73729_b(renderPos.posX(), renderPos.posY(), this.texX, this.texY, this.width, this.height);
    }

    public void renderIfPresent(@Nullable ResourceLocation customTexRes, RenderPos renderPos, WidgetGui gui) {
        this.ifSizePresent(t -> t.render(customTexRes, renderPos, gui));
    }

    public void renderIfPresent(@Nullable ResourceLocation customTexRes, RenderPos renderPos, GuiScreen gui) {
        this.ifSizePresent(t -> t.render(customTexRes, renderPos, gui));
    }

    public void renderIfPresent(@Nullable ResourceLocation customTexRes, RenderPos renderPos, WidgetGui gui, Consumer<TextureProperties> before) {
        this.ifSizePresent(t -> before.andThen(t1 -> t.render(customTexRes, renderPos, gui)).accept((TextureProperties)t));
    }

    public void renderIfPresent(@Nullable ResourceLocation customTexRes, RenderPos renderPos, GuiScreen gui, Consumer<TextureProperties> before) {
        this.ifSizePresent(t -> before.andThen(t1 -> t.render(customTexRes, renderPos, gui)).accept((TextureProperties)t));
    }

    public void renderIfPresent(@Nullable ResourceLocation customTexRes, RenderPos renderPos, WidgetGui gui, @Nullable Consumer<TextureProperties> before, @Nullable Consumer<TextureProperties> after) {
        this.ifPresent(t -> {
            Optional.ofNullable(before).ifPresent((? super T bc) -> bc.accept(t));
            t.render(customTexRes, renderPos, gui);
            Optional.ofNullable(after).ifPresent((? super T ac) -> ac.accept(t));
        });
    }

    public void renderIfPresent(@Nullable ResourceLocation customTexRes, RenderPos renderPos, GuiScreen gui, @Nullable Consumer<TextureProperties> before, @Nullable Consumer<TextureProperties> after) {
        this.ifPresent(t -> {
            Optional.ofNullable(before).ifPresent((? super T bc) -> bc.accept(t));
            t.render(customTexRes, renderPos, gui);
            Optional.ofNullable(after).ifPresent((? super T ac) -> ac.accept(t));
        });
    }

    public void ifSizePresent(Consumer<TextureProperties> runnable) {
        if (this.width > 0 && this.height > 0) {
            runnable.accept(this);
        }
    }

    public void render(@Nullable ResourceLocation customTexRes, RenderPos renderPos, RenderSize renderSize, WidgetGui gui) {
        this.render(customTexRes, renderPos, renderSize, gui.getGui());
    }

    public void render(@Nullable ResourceLocation customTexRes, RenderPos renderPos, RenderSize renderSize, GuiScreen gui) {
        TextureManager textureManager = gui.field_146297_k.func_110434_K();
        if (this.texRes != null) {
            this.bind(textureManager);
        } else if (customTexRes != null) {
            TextureProperties.bind(textureManager, customTexRes);
        } else {
            return;
        }
        gui.func_73729_b(renderPos.posX(), renderPos.posY(), this.texX, this.texY, renderSize.width(), renderSize.height());
    }

    public void render(RenderPos renderPos, RenderSize renderSize, WidgetGui gui) {
        this.render(renderPos, renderSize, gui.getGui());
    }

    public void render(RenderPos renderPos, RenderSize renderSize, GuiScreen gui) {
        this.bind(gui.field_146297_k.func_110434_K());
        gui.func_73729_b(renderPos.posX(), renderPos.posY(), this.texX, this.texY, renderSize.width(), renderSize.height());
    }

    public void renderIfPresent(RenderPos renderPos, RenderSize renderSize, WidgetGui gui) {
        this.ifTexPresent(t -> t.render(renderPos, renderSize, gui));
    }

    public void renderIfPresent(RenderPos renderPos, RenderSize renderSize, GuiScreen gui) {
        this.ifTexPresent(t -> t.render(renderPos, renderSize, gui));
    }

    public void renderIfPresent(RenderPos renderPos, RenderSize renderSize, WidgetGui gui, Consumer<TextureProperties> before) {
        this.ifTexPresent(t -> before.andThen(t1 -> t.render(renderPos, renderSize, gui)).accept((TextureProperties)t));
    }

    public void renderIfPresent(RenderPos renderPos, RenderSize renderSize, GuiScreen gui, Consumer<TextureProperties> before) {
        this.ifTexPresent(t -> before.andThen(t1 -> t.render(renderPos, renderSize, gui)).accept((TextureProperties)t));
    }

    public void renderIfPresent(RenderPos renderPos, RenderSize renderSize, WidgetGui gui, @Nullable Consumer<TextureProperties> before, @Nullable Consumer<TextureProperties> after) {
        this.ifPresent(t -> {
            Optional.ofNullable(before).ifPresent((? super T bc) -> bc.accept(t));
            t.render(renderPos, renderSize, gui);
            Optional.ofNullable(after).ifPresent((? super T ac) -> ac.accept(t));
        });
    }

    public void renderIfPresent(RenderPos renderPos, RenderSize renderSize, GuiScreen gui, @Nullable Consumer<TextureProperties> before, @Nullable Consumer<TextureProperties> after) {
        this.ifPresent(t -> {
            Optional.ofNullable(before).ifPresent((? super T bc) -> bc.accept(t));
            t.render(renderPos, renderSize, gui);
            Optional.ofNullable(after).ifPresent((? super T ac) -> ac.accept(t));
        });
    }

    public void ifTexPresent(Consumer<TextureProperties> runnable) {
        if (this.texRes != null) {
            runnable.accept(this);
        }
    }

    public String toString() {
        return "TextureProperties[" + "texRes=" + this.texRes + "," + "texX=" + this.texX + "," + "texY=" + this.texY + "," + "width=" + this.width + "," + "height=" + this.height + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.texRes != null ? this.texRes.hashCode() : 0);
        result = 31 * result + this.texX;
        result = 31 * result + this.texY;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((TextureProperties)arg0).texRes, this.texRes)) {
            return false;
        }
        if (((TextureProperties)arg0).texX != this.texX) {
            return false;
        }
        if (((TextureProperties)arg0).texY != this.texY) {
            return false;
        }
        if (((TextureProperties)arg0).width != this.width) {
            return false;
        }
        return ((TextureProperties)arg0).height == this.height;
        {
        }
    }

    @Nullable
    public ResourceLocation texRes() {
        return this.texRes;
    }

    public int texX() {
        return this.texX;
    }

    public int texY() {
        return this.texY;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

